/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBudgetActionResponse extends BudgetsResponse implements
        ToCopyableBuilder<UpdateBudgetActionResponse.Builder, UpdateBudgetActionResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UpdateBudgetActionResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(UpdateBudgetActionResponse::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<Action> OLD_ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO)
            .memberName("OldAction").getter(getter(UpdateBudgetActionResponse::oldAction)).setter(setter(Builder::oldAction))
            .constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldAction").build()).build();

    private static final SdkField<Action> NEW_ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO)
            .memberName("NewAction").getter(getter(UpdateBudgetActionResponse::newAction)).setter(setter(Builder::newAction))
            .constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, OLD_ACTION_FIELD, NEW_ACTION_FIELD));

    private final String accountId;

    private final String budgetName;

    private final Action oldAction;

    private final Action newAction;

    private UpdateBudgetActionResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldAction = builder.oldAction;
        this.newAction = builder.newAction;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * The previous action resource information.
     * </p>
     * 
     * @return The previous action resource information.
     */
    public final Action oldAction() {
        return oldAction;
    }

    /**
     * <p>
     * The updated action resource information.
     * </p>
     * 
     * @return The updated action resource information.
     */
    public final Action newAction() {
        return newAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(oldAction());
        hashCode = 31 * hashCode + Objects.hashCode(newAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetActionResponse)) {
            return false;
        }
        UpdateBudgetActionResponse other = (UpdateBudgetActionResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(oldAction(), other.oldAction()) && Objects.equals(newAction(), other.newAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBudgetActionResponse").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("OldAction", oldAction()).add("NewAction", newAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "OldAction":
            return Optional.ofNullable(clazz.cast(oldAction()));
        case "NewAction":
            return Optional.ofNullable(clazz.cast(newAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetActionResponse, T> g) {
        return obj -> g.apply((UpdateBudgetActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBudgetActionResponse> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * The previous action resource information.
         * </p>
         * 
         * @param oldAction
         *        The previous action resource information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldAction(Action oldAction);

        /**
         * <p>
         * The previous action resource information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #oldAction(Action)}.
         * 
         * @param oldAction
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oldAction(Action)
         */
        default Builder oldAction(Consumer<Action.Builder> oldAction) {
            return oldAction(Action.builder().applyMutation(oldAction).build());
        }

        /**
         * <p>
         * The updated action resource information.
         * </p>
         * 
         * @param newAction
         *        The updated action resource information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAction(Action newAction);

        /**
         * <p>
         * The updated action resource information.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #newAction(Action)}.
         * 
         * @param newAction
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newAction(Action)
         */
        default Builder newAction(Consumer<Action.Builder> newAction) {
            return newAction(Action.builder().applyMutation(newAction).build());
        }
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Action oldAction;

        private Action newAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetActionResponse model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            oldAction(model.oldAction);
            newAction(model.newAction);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        @Transient
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final Action.Builder getOldAction() {
            return oldAction != null ? oldAction.toBuilder() : null;
        }

        public final void setOldAction(Action.BuilderImpl oldAction) {
            this.oldAction = oldAction != null ? oldAction.build() : null;
        }

        @Override
        @Transient
        public final Builder oldAction(Action oldAction) {
            this.oldAction = oldAction;
            return this;
        }

        public final Action.Builder getNewAction() {
            return newAction != null ? newAction.toBuilder() : null;
        }

        public final void setNewAction(Action.BuilderImpl newAction) {
            this.newAction = newAction != null ? newAction.build() : null;
        }

        @Override
        @Transient
        public final Builder newAction(Action newAction) {
            this.newAction = newAction;
            return this;
        }

        @Override
        public UpdateBudgetActionResponse build() {
            return new UpdateBudgetActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
