/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A history of the state of a budget at the end of the budget's specified time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetPerformanceHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<BudgetPerformanceHistory.Builder, BudgetPerformanceHistory> {
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(BudgetPerformanceHistory::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetType").getter(getter(BudgetPerformanceHistory::budgetTypeAsString))
            .setter(setter(Builder::budgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetType").build()).build();

    private static final SdkField<Map<String, List<String>>> COST_FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("CostFilters")
            .getter(getter(BudgetPerformanceHistory::costFilters))
            .setter(setter(Builder::costFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostFilters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<CostTypes> COST_TYPES_FIELD = SdkField.<CostTypes> builder(MarshallingType.SDK_POJO)
            .memberName("CostTypes").getter(getter(BudgetPerformanceHistory::costTypes)).setter(setter(Builder::costTypes))
            .constructor(CostTypes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostTypes").build()).build();

    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeUnit").getter(getter(BudgetPerformanceHistory::timeUnitAsString)).setter(setter(Builder::timeUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()).build();

    private static final SdkField<List<BudgetedAndActualAmounts>> BUDGETED_AND_ACTUAL_AMOUNTS_LIST_FIELD = SdkField
            .<List<BudgetedAndActualAmounts>> builder(MarshallingType.LIST)
            .memberName("BudgetedAndActualAmountsList")
            .getter(getter(BudgetPerformanceHistory::budgetedAndActualAmountsList))
            .setter(setter(Builder::budgetedAndActualAmountsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetedAndActualAmountsList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BudgetedAndActualAmounts> builder(MarshallingType.SDK_POJO)
                                            .constructor(BudgetedAndActualAmounts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_NAME_FIELD,
            BUDGET_TYPE_FIELD, COST_FILTERS_FIELD, COST_TYPES_FIELD, TIME_UNIT_FIELD, BUDGETED_AND_ACTUAL_AMOUNTS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String budgetName;

    private final String budgetType;

    private final Map<String, List<String>> costFilters;

    private final CostTypes costTypes;

    private final String timeUnit;

    private final List<BudgetedAndActualAmounts> budgetedAndActualAmountsList;

    private BudgetPerformanceHistory(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetType = builder.budgetType;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.budgetedAndActualAmountsList = builder.budgetedAndActualAmountsList;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the BudgetType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link BudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeAsString}.
     * </p>
     * 
     * @return The value of the BudgetType property for this object.
     * @see BudgetType
     */
    public final BudgetType budgetType() {
        return BudgetType.fromValue(budgetType);
    }

    /**
     * Returns the value of the BudgetType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #budgetType} will
     * return {@link BudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #budgetTypeAsString}.
     * </p>
     * 
     * @return The value of the BudgetType property for this object.
     * @see BudgetType
     */
    public final String budgetTypeAsString() {
        return budgetType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCostFilters() {
        return costFilters != null && !(costFilters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The history of the cost filters for a budget during the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostFilters} method.
     * </p>
     * 
     * @return The history of the cost filters for a budget during the specified time period.
     */
    public final Map<String, List<String>> costFilters() {
        return costFilters;
    }

    /**
     * <p>
     * The history of the cost types for a budget during the specified time period.
     * </p>
     * 
     * @return The history of the cost types for a budget during the specified time period.
     */
    public final CostTypes costTypes() {
        return costTypes;
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public final TimeUnit timeUnit() {
        return TimeUnit.fromValue(timeUnit);
    }

    /**
     * Returns the value of the TimeUnit property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeUnit} will
     * return {@link TimeUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeUnitAsString}.
     * </p>
     * 
     * @return The value of the TimeUnit property for this object.
     * @see TimeUnit
     */
    public final String timeUnitAsString() {
        return timeUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the BudgetedAndActualAmountsList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBudgetedAndActualAmountsList() {
        return budgetedAndActualAmountsList != null && !(budgetedAndActualAmountsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBudgetedAndActualAmountsList} method.
     * </p>
     * 
     * @return A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.
     */
    public final List<BudgetedAndActualAmounts> budgetedAndActualAmountsList() {
        return budgetedAndActualAmountsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCostFilters() ? costFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(costTypes());
        hashCode = 31 * hashCode + Objects.hashCode(timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBudgetedAndActualAmountsList() ? budgetedAndActualAmountsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetPerformanceHistory)) {
            return false;
        }
        BudgetPerformanceHistory other = (BudgetPerformanceHistory) obj;
        return Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(budgetTypeAsString(), other.budgetTypeAsString()) && hasCostFilters() == other.hasCostFilters()
                && Objects.equals(costFilters(), other.costFilters()) && Objects.equals(costTypes(), other.costTypes())
                && Objects.equals(timeUnitAsString(), other.timeUnitAsString())
                && hasBudgetedAndActualAmountsList() == other.hasBudgetedAndActualAmountsList()
                && Objects.equals(budgetedAndActualAmountsList(), other.budgetedAndActualAmountsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetPerformanceHistory").add("BudgetName", budgetName())
                .add("BudgetType", budgetTypeAsString()).add("CostFilters", hasCostFilters() ? costFilters() : null)
                .add("CostTypes", costTypes()).add("TimeUnit", timeUnitAsString())
                .add("BudgetedAndActualAmountsList", hasBudgetedAndActualAmountsList() ? budgetedAndActualAmountsList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "BudgetType":
            return Optional.ofNullable(clazz.cast(budgetTypeAsString()));
        case "CostFilters":
            return Optional.ofNullable(clazz.cast(costFilters()));
        case "CostTypes":
            return Optional.ofNullable(clazz.cast(costTypes()));
        case "TimeUnit":
            return Optional.ofNullable(clazz.cast(timeUnitAsString()));
        case "BudgetedAndActualAmountsList":
            return Optional.ofNullable(clazz.cast(budgetedAndActualAmountsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetPerformanceHistory, T> g) {
        return obj -> g.apply((BudgetPerformanceHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetPerformanceHistory> {
        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(String budgetType);

        /**
         * Sets the value of the BudgetType property for this object.
         *
         * @param budgetType
         *        The new value for the BudgetType property for this object.
         * @see BudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetType
         */
        Builder budgetType(BudgetType budgetType);

        /**
         * <p>
         * The history of the cost filters for a budget during the specified time period.
         * </p>
         * 
         * @param costFilters
         *        The history of the cost filters for a budget during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costFilters(Map<String, ? extends Collection<String>> costFilters);

        /**
         * <p>
         * The history of the cost types for a budget during the specified time period.
         * </p>
         * 
         * @param costTypes
         *        The history of the cost types for a budget during the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costTypes(CostTypes costTypes);

        /**
         * <p>
         * The history of the cost types for a budget during the specified time period.
         * </p>
         * This is a convenience that creates an instance of the {@link CostTypes.Builder} avoiding the need to create
         * one manually via {@link CostTypes#builder()}.
         *
         * When the {@link Consumer} completes, {@link CostTypes.Builder#build()} is called immediately and its result
         * is passed to {@link #costTypes(CostTypes)}.
         * 
         * @param costTypes
         *        a consumer that will call methods on {@link CostTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costTypes(CostTypes)
         */
        default Builder costTypes(Consumer<CostTypes.Builder> costTypes) {
            return costTypes(CostTypes.builder().applyMutation(costTypes).build());
        }

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(String timeUnit);

        /**
         * Sets the value of the TimeUnit property for this object.
         *
         * @param timeUnit
         *        The new value for the TimeUnit property for this object.
         * @see TimeUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeUnit
         */
        Builder timeUnit(TimeUnit timeUnit);

        /**
         * <p>
         * A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.
         * </p>
         * 
         * @param budgetedAndActualAmountsList
         *        A list of amounts of cost or usage that you created budgets for, compared to your actual costs or
         *        usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> budgetedAndActualAmountsList);

        /**
         * <p>
         * A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.
         * </p>
         * 
         * @param budgetedAndActualAmountsList
         *        A list of amounts of cost or usage that you created budgets for, compared to your actual costs or
         *        usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetedAndActualAmountsList(BudgetedAndActualAmounts... budgetedAndActualAmountsList);

        /**
         * <p>
         * A list of amounts of cost or usage that you created budgets for, compared to your actual costs or usage.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BudgetedAndActualAmounts>.Builder} avoiding
         * the need to create one manually via {@link List<BudgetedAndActualAmounts>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BudgetedAndActualAmounts>.Builder#build()} is called
         * immediately and its result is passed to {@link #budgetedAndActualAmountsList(List<BudgetedAndActualAmounts>)}
         * .
         * 
         * @param budgetedAndActualAmountsList
         *        a consumer that will call methods on {@link List<BudgetedAndActualAmounts>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetedAndActualAmountsList(List<BudgetedAndActualAmounts>)
         */
        Builder budgetedAndActualAmountsList(Consumer<BudgetedAndActualAmounts.Builder>... budgetedAndActualAmountsList);
    }

    static final class BuilderImpl implements Builder {
        private String budgetName;

        private String budgetType;

        private Map<String, List<String>> costFilters = DefaultSdkAutoConstructMap.getInstance();

        private CostTypes costTypes;

        private String timeUnit;

        private List<BudgetedAndActualAmounts> budgetedAndActualAmountsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetPerformanceHistory model) {
            budgetName(model.budgetName);
            budgetType(model.budgetType);
            costFilters(model.costFilters);
            costTypes(model.costTypes);
            timeUnit(model.timeUnit);
            budgetedAndActualAmountsList(model.budgetedAndActualAmountsList);
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        @Transient
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getBudgetType() {
            return budgetType;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        @Override
        @Transient
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        @Transient
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType == null ? null : budgetType.toString());
            return this;
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            if (costFilters instanceof SdkAutoConstructMap) {
                return null;
            }
            return costFilters;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        @Override
        @Transient
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final CostTypes.Builder getCostTypes() {
            return costTypes != null ? costTypes.toBuilder() : null;
        }

        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        @Override
        @Transient
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final String getTimeUnit() {
            return timeUnit;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        @Transient
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit == null ? null : timeUnit.toString());
            return this;
        }

        public final List<BudgetedAndActualAmounts.Builder> getBudgetedAndActualAmountsList() {
            List<BudgetedAndActualAmounts.Builder> result = BudgetedAndActualAmountsListCopier
                    .copyToBuilder(this.budgetedAndActualAmountsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgetedAndActualAmountsList(
                Collection<BudgetedAndActualAmounts.BuilderImpl> budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList = BudgetedAndActualAmountsListCopier.copyFromBuilder(budgetedAndActualAmountsList);
        }

        @Override
        @Transient
        public final Builder budgetedAndActualAmountsList(Collection<BudgetedAndActualAmounts> budgetedAndActualAmountsList) {
            this.budgetedAndActualAmountsList = BudgetedAndActualAmountsListCopier.copy(budgetedAndActualAmountsList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder budgetedAndActualAmountsList(BudgetedAndActualAmounts... budgetedAndActualAmountsList) {
            budgetedAndActualAmountsList(Arrays.asList(budgetedAndActualAmountsList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder budgetedAndActualAmountsList(
                Consumer<BudgetedAndActualAmounts.Builder>... budgetedAndActualAmountsList) {
            budgetedAndActualAmountsList(Stream.of(budgetedAndActualAmountsList)
                    .map(c -> BudgetedAndActualAmounts.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BudgetPerformanceHistory build() {
            return new BudgetPerformanceHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
