/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A budget action resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionId").getter(getter(Action::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BudgetName").getter(getter(Action::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationType").getter(getter(Action::notificationTypeAsString))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(Action::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<ActionThreshold> ACTION_THRESHOLD_FIELD = SdkField
            .<ActionThreshold> builder(MarshallingType.SDK_POJO).memberName("ActionThreshold")
            .getter(getter(Action::actionThreshold)).setter(setter(Builder::actionThreshold))
            .constructor(ActionThreshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionThreshold").build()).build();

    private static final SdkField<Definition> DEFINITION_FIELD = SdkField.<Definition> builder(MarshallingType.SDK_POJO)
            .memberName("Definition").getter(getter(Action::definition)).setter(setter(Builder::definition))
            .constructor(Definition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(Action::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<String> APPROVAL_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApprovalModel").getter(getter(Action::approvalModelAsString)).setter(setter(Builder::approvalModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalModel").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Action::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField
            .<List<Subscriber>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(Action::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subscriber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            BUDGET_NAME_FIELD, NOTIFICATION_TYPE_FIELD, ACTION_TYPE_FIELD, ACTION_THRESHOLD_FIELD, DEFINITION_FIELD,
            EXECUTION_ROLE_ARN_FIELD, APPROVAL_MODEL_FIELD, STATUS_FIELD, SUBSCRIBERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String budgetName;

    private final String notificationType;

    private final String actionType;

    private final ActionThreshold actionThreshold;

    private final Definition definition;

    private final String executionRoleArn;

    private final String approvalModel;

    private final String status;

    private final List<Subscriber> subscribers;

    private Action(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.budgetName = builder.budgetName;
        this.notificationType = builder.notificationType;
        this.actionType = builder.actionType;
        this.actionThreshold = builder.actionThreshold;
        this.definition = builder.definition;
        this.executionRoleArn = builder.executionRoleArn;
        this.approvalModel = builder.approvalModel;
        this.status = builder.status;
        this.subscribers = builder.subscribers;
    }

    /**
     * <p>
     * A system-generated universally unique identifier (UUID) for the action.
     * </p>
     * 
     * @return A system-generated universally unique identifier (UUID) for the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public final String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public final NotificationType notificationType() {
        return NotificationType.fromValue(notificationType);
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #notificationType}
     * will return {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #notificationTypeAsString}.
     * </p>
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public final String notificationTypeAsString() {
        return notificationType;
    }

    /**
     * <p>
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also
     * determines the format for definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action. This defines the type of tasks that can be carried out by this action. This field
     *         also determines the format for definition.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action. This defines the type of tasks that can be carried out by this action. This field also
     * determines the format for definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action. This defines the type of tasks that can be carried out by this action. This field
     *         also determines the format for definition.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The trigger threshold of the action.
     * </p>
     * 
     * @return The trigger threshold of the action.
     */
    public final ActionThreshold actionThreshold() {
        return actionThreshold;
    }

    /**
     * <p>
     * Where you specify all of the type-specific parameters.
     * </p>
     * 
     * @return Where you specify all of the type-specific parameters.
     */
    public final Definition definition() {
        return definition;
    }

    /**
     * <p>
     * The role passed for action execution and reversion. Roles and actions must be in the same account.
     * </p>
     * 
     * @return The role passed for action execution and reversion. Roles and actions must be in the same account.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * This specifies if the action needs manual or automatic approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalModel}
     * will return {@link ApprovalModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalModelAsString}.
     * </p>
     * 
     * @return This specifies if the action needs manual or automatic approval.
     * @see ApprovalModel
     */
    public final ApprovalModel approvalModel() {
        return ApprovalModel.fromValue(approvalModel);
    }

    /**
     * <p>
     * This specifies if the action needs manual or automatic approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #approvalModel}
     * will return {@link ApprovalModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #approvalModelAsString}.
     * </p>
     * 
     * @return This specifies if the action needs manual or automatic approval.
     * @see ApprovalModel
     */
    public final String approvalModelAsString() {
        return approvalModel;
    }

    /**
     * <p>
     * The status of action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of action.
     * @see ActionStatus
     */
    public final ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of action.
     * @see ActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Subscribers property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The value of the Subscribers property for this object.
     */
    public final List<Subscriber> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(approvalModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(notificationTypeAsString(), other.notificationTypeAsString())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(actionThreshold(), other.actionThreshold()) && Objects.equals(definition(), other.definition())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(approvalModelAsString(), other.approvalModelAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasSubscribers() == other.hasSubscribers()
                && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("ActionId", actionId()).add("BudgetName", budgetName())
                .add("NotificationType", notificationTypeAsString()).add("ActionType", actionTypeAsString())
                .add("ActionThreshold", actionThreshold()).add("Definition", definition())
                .add("ExecutionRoleArn", executionRoleArn()).add("ApprovalModel", approvalModelAsString())
                .add("Status", statusAsString()).add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "NotificationType":
            return Optional.ofNullable(clazz.cast(notificationTypeAsString()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ActionThreshold":
            return Optional.ofNullable(clazz.cast(actionThreshold()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "ApprovalModel":
            return Optional.ofNullable(clazz.cast(approvalModelAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * A system-generated universally unique identifier (UUID) for the action.
         * </p>
         * 
         * @param actionId
         *        A system-generated universally unique identifier (UUID) for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * <p>
         * The type of action. This defines the type of tasks that can be carried out by this action. This field also
         * determines the format for definition.
         * </p>
         * 
         * @param actionType
         *        The type of action. This defines the type of tasks that can be carried out by this action. This field
         *        also determines the format for definition.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action. This defines the type of tasks that can be carried out by this action. This field also
         * determines the format for definition.
         * </p>
         * 
         * @param actionType
         *        The type of action. This defines the type of tasks that can be carried out by this action. This field
         *        also determines the format for definition.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The trigger threshold of the action.
         * </p>
         * 
         * @param actionThreshold
         *        The trigger threshold of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionThreshold(ActionThreshold actionThreshold);

        /**
         * <p>
         * The trigger threshold of the action.
         * </p>
         * This is a convenience that creates an instance of the {@link ActionThreshold.Builder} avoiding the need to
         * create one manually via {@link ActionThreshold#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionThreshold.Builder#build()} is called immediately and its
         * result is passed to {@link #actionThreshold(ActionThreshold)}.
         * 
         * @param actionThreshold
         *        a consumer that will call methods on {@link ActionThreshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionThreshold(ActionThreshold)
         */
        default Builder actionThreshold(Consumer<ActionThreshold.Builder> actionThreshold) {
            return actionThreshold(ActionThreshold.builder().applyMutation(actionThreshold).build());
        }

        /**
         * <p>
         * Where you specify all of the type-specific parameters.
         * </p>
         * 
         * @param definition
         *        Where you specify all of the type-specific parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(Definition definition);

        /**
         * <p>
         * Where you specify all of the type-specific parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link Definition.Builder} avoiding the need to create
         * one manually via {@link Definition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Definition.Builder#build()} is called immediately and its result
         * is passed to {@link #definition(Definition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link Definition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(Definition)
         */
        default Builder definition(Consumer<Definition.Builder> definition) {
            return definition(Definition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The role passed for action execution and reversion. Roles and actions must be in the same account.
         * </p>
         * 
         * @param executionRoleArn
         *        The role passed for action execution and reversion. Roles and actions must be in the same account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * This specifies if the action needs manual or automatic approval.
         * </p>
         * 
         * @param approvalModel
         *        This specifies if the action needs manual or automatic approval.
         * @see ApprovalModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalModel
         */
        Builder approvalModel(String approvalModel);

        /**
         * <p>
         * This specifies if the action needs manual or automatic approval.
         * </p>
         * 
         * @param approvalModel
         *        This specifies if the action needs manual or automatic approval.
         * @see ApprovalModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApprovalModel
         */
        Builder approvalModel(ApprovalModel approvalModel);

        /**
         * <p>
         * The status of action.
         * </p>
         * 
         * @param status
         *        The status of action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of action.
         * </p>
         * 
         * @param status
         *        The status of action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<Subscriber> subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * @param subscribers
         *        The new value for the Subscribers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Subscriber... subscribers);

        /**
         * Sets the value of the Subscribers property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Subscriber>.Builder} avoiding the need to
         * create one manually via {@link List<Subscriber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subscriber>.Builder#build()} is called immediately and its
         * result is passed to {@link #subscribers(List<Subscriber>)}.
         * 
         * @param subscribers
         *        a consumer that will call methods on {@link List<Subscriber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribers(List<Subscriber>)
         */
        Builder subscribers(Consumer<Subscriber.Builder>... subscribers);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String budgetName;

        private String notificationType;

        private String actionType;

        private ActionThreshold actionThreshold;

        private Definition definition;

        private String executionRoleArn;

        private String approvalModel;

        private String status;

        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            actionId(model.actionId);
            budgetName(model.budgetName);
            notificationType(model.notificationType);
            actionType(model.actionType);
            actionThreshold(model.actionThreshold);
            definition(model.definition);
            executionRoleArn(model.executionRoleArn);
            approvalModel(model.approvalModel);
            status(model.status);
            subscribers(model.subscribers);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        @Transient
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        @Transient
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        @Transient
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType == null ? null : notificationType.toString());
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        @Transient
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        @Transient
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final ActionThreshold.Builder getActionThreshold() {
            return actionThreshold != null ? actionThreshold.toBuilder() : null;
        }

        public final void setActionThreshold(ActionThreshold.BuilderImpl actionThreshold) {
            this.actionThreshold = actionThreshold != null ? actionThreshold.build() : null;
        }

        @Override
        @Transient
        public final Builder actionThreshold(ActionThreshold actionThreshold) {
            this.actionThreshold = actionThreshold;
            return this;
        }

        public final Definition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(Definition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        @Transient
        public final Builder definition(Definition definition) {
            this.definition = definition;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getApprovalModel() {
            return approvalModel;
        }

        public final void setApprovalModel(String approvalModel) {
            this.approvalModel = approvalModel;
        }

        @Override
        @Transient
        public final Builder approvalModel(String approvalModel) {
            this.approvalModel = approvalModel;
            return this;
        }

        @Override
        @Transient
        public final Builder approvalModel(ApprovalModel approvalModel) {
            this.approvalModel(approvalModel == null ? null : approvalModel.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Subscriber.Builder> getSubscribers() {
            List<Subscriber.Builder> result = SubscribersCopier.copyToBuilder(this.subscribers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        @Override
        @Transient
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribers(Subscriber... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder>... subscribers) {
            subscribers(Stream.of(subscribers).map(c -> Subscriber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
