/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.budgets.model.CreateBudgetActionRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetActionResponse;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.CreateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.CreateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetActionResponse;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest;
import software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionResponse;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetActionResponse;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionHistoriesPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForAccountPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForBudgetPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetNotificationsForAccountPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetPerformanceHistoryPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeBudgetsPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeNotificationsForBudgetPublisher;
import software.amazon.awssdk.services.budgets.paginators.DescribeSubscribersForNotificationPublisher;

/**
 * Service client for accessing AWSBudgets asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Use the Amazon Web Services Budgets API to plan your service usage, service costs, and instance reservations. This
 * API reference provides descriptions, syntax, and usage examples for each of the actions and data types for the Amazon
 * Web Services Budgets feature.
 * </p>
 * <p>
 * Budgets provide you with a way to see the following information:
 * </p>
 * <ul>
 * <li>
 * <p>
 * How close your plan is to your budgeted amount or to the free tier limits
 * </p>
 * </li>
 * <li>
 * <p>
 * Your usage-to-date, including how much you've used of your Reserved Instances (RIs)
 * </p>
 * </li>
 * <li>
 * <p>
 * Your current estimated charges from Amazon Web Services, and how much your predicted usage will accrue in charges by
 * the end of the month
 * </p>
 * </li>
 * <li>
 * <p>
 * How much of your budget has been used
 * </p>
 * </li>
 * </ul>
 * <p>
 * Amazon Web Services updates your budget status several times a day. Budgets track your unblended costs,
 * subscriptions, refunds, and RIs. You can create the following types of budgets:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Cost budgets</b> - Plan how much you want to spend on a service.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Usage budgets</b> - Plan how much you want to use one or more services.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>RI utilization budgets</b> - Define a utilization threshold, and receive alerts when your RI usage falls below
 * that threshold. This lets you see if your RIs are unused or under-utilized.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>RI coverage budgets</b> - Define a coverage threshold, and receive alerts when the number of your instance hours
 * that are covered by RIs fall below that threshold. This lets you see how much of your instance usage is covered by a
 * reservation.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Service Endpoint
 * </p>
 * <p>
 * The Amazon Web Services Budgets API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://budgets.amazonaws.com
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about costs that are associated with the Amazon Web Services Budgets API, see <a
 * href="https://aws.amazon.com/aws-cost-management/pricing/">Amazon Web Services Cost Management Pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BudgetsAsyncClient extends AwsClient {
    String SERVICE_NAME = "budgets";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "budgets";

    /**
     * <p>
     * Creates a budget and, if included, notifications and subscribers.
     * </p>
     * <important>
     * <p>
     * Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one
     * time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code>
     * syntax. For <code>PlannedBudgetLimits</code>, see the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important>
     *
     * @param createBudgetRequest
     *        Request of CreateBudget
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudget
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(CreateBudgetRequest createBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a budget and, if included, notifications and subscribers.
     * </p>
     * <important>
     * <p>
     * Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one
     * time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code>
     * syntax. For <code>PlannedBudgetLimits</code>, see the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBudgetRequest#builder()}
     * </p>
     *
     * @param createBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.CreateBudgetRequest.Builder} to create a request.
     *        Request of CreateBudget
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudget
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(Consumer<CreateBudgetRequest.Builder> createBudgetRequest) {
        return createBudget(CreateBudgetRequest.builder().applyMutation(createBudgetRequest).build());
    }

    /**
     * <p>
     * Creates a budget action.
     * </p>
     *
     * @param createBudgetActionRequest
     * @return A Java Future containing the result of the CreateBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudgetAction
     */
    default CompletableFuture<CreateBudgetActionResponse> createBudgetAction(CreateBudgetActionRequest createBudgetActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a budget action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBudgetActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBudgetActionRequest#builder()}
     * </p>
     *
     * @param createBudgetActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.CreateBudgetActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudgetAction
     */
    default CompletableFuture<CreateBudgetActionResponse> createBudgetAction(
            Consumer<CreateBudgetActionRequest.Builder> createBudgetActionRequest) {
        return createBudgetAction(CreateBudgetActionRequest.builder().applyMutation(createBudgetActionRequest).build());
    }

    /**
     * <p>
     * Creates a notification. You must create the budget before you create the associated notification.
     * </p>
     *
     * @param createNotificationRequest
     *        Request of CreateNotification
     * @return A Java Future containing the result of the CreateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateNotification
     */
    default CompletableFuture<CreateNotificationResponse> createNotification(CreateNotificationRequest createNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a notification. You must create the budget before you create the associated notification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotificationRequest#builder()}
     * </p>
     *
     * @param createNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.CreateNotificationRequest.Builder} to create a
     *        request. Request of CreateNotification
     * @return A Java Future containing the result of the CreateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateNotification
     */
    default CompletableFuture<CreateNotificationResponse> createNotification(
            Consumer<CreateNotificationRequest.Builder> createNotificationRequest) {
        return createNotification(CreateNotificationRequest.builder().applyMutation(createNotificationRequest).build());
    }

    /**
     * <p>
     * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
     * </p>
     *
     * @param createSubscriberRequest
     *        Request of CreateSubscriber
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateSubscriber
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a subscriber. You must create the associated budget and notification before you create the subscriber.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubscriberRequest#builder()}
     * </p>
     *
     * @param createSubscriberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest.Builder} to create a request.
     *        Request of CreateSubscriber
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>CreationLimitExceededException You've exceeded the notification or subscriber limit.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateSubscriber
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(
            Consumer<CreateSubscriberRequest.Builder> createSubscriberRequest) {
        return createSubscriber(CreateSubscriberRequest.builder().applyMutation(createSubscriberRequest).build());
    }

    /**
     * <p>
     * Deletes a budget. You can delete your budget at any time.
     * </p>
     * <important>
     * <p>
     * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
     * </p>
     * </important>
     *
     * @param deleteBudgetRequest
     *        Request of DeleteBudget
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudget
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a budget. You can delete your budget at any time.
     * </p>
     * <important>
     * <p>
     * Deleting a budget also deletes the notifications and subscribers that are associated with that budget.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBudgetRequest#builder()}
     * </p>
     *
     * @param deleteBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest.Builder} to create a request.
     *        Request of DeleteBudget
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudget
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(Consumer<DeleteBudgetRequest.Builder> deleteBudgetRequest) {
        return deleteBudget(DeleteBudgetRequest.builder().applyMutation(deleteBudgetRequest).build());
    }

    /**
     * <p>
     * Deletes a budget action.
     * </p>
     *
     * @param deleteBudgetActionRequest
     * @return A Java Future containing the result of the DeleteBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudgetAction
     */
    default CompletableFuture<DeleteBudgetActionResponse> deleteBudgetAction(DeleteBudgetActionRequest deleteBudgetActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a budget action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBudgetActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBudgetActionRequest#builder()}
     * </p>
     *
     * @param deleteBudgetActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DeleteBudgetActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudgetAction
     */
    default CompletableFuture<DeleteBudgetActionResponse> deleteBudgetAction(
            Consumer<DeleteBudgetActionRequest.Builder> deleteBudgetActionRequest) {
        return deleteBudgetAction(DeleteBudgetActionRequest.builder().applyMutation(deleteBudgetActionRequest).build());
    }

    /**
     * <p>
     * Deletes a notification.
     * </p>
     * <important>
     * <p>
     * Deleting a notification also deletes the subscribers that are associated with the notification.
     * </p>
     * </important>
     *
     * @param deleteNotificationRequest
     *        Request of DeleteNotification
     * @return A Java Future containing the result of the DeleteNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteNotification
     */
    default CompletableFuture<DeleteNotificationResponse> deleteNotification(DeleteNotificationRequest deleteNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notification.
     * </p>
     * <important>
     * <p>
     * Deleting a notification also deletes the subscribers that are associated with the notification.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotificationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest.Builder} to create a
     *        request. Request of DeleteNotification
     * @return A Java Future containing the result of the DeleteNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteNotification
     */
    default CompletableFuture<DeleteNotificationResponse> deleteNotification(
            Consumer<DeleteNotificationRequest.Builder> deleteNotificationRequest) {
        return deleteNotification(DeleteNotificationRequest.builder().applyMutation(deleteNotificationRequest).build());
    }

    /**
     * <p>
     * Deletes a subscriber.
     * </p>
     * <important>
     * <p>
     * Deleting the last subscriber to a notification also deletes the notification.
     * </p>
     * </important>
     *
     * @param deleteSubscriberRequest
     *        Request of DeleteSubscriber
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteSubscriber
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscriber.
     * </p>
     * <important>
     * <p>
     * Deleting the last subscriber to a notification also deletes the notification.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubscriberRequest#builder()}
     * </p>
     *
     * @param deleteSubscriberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest.Builder} to create a request.
     *        Request of DeleteSubscriber
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteSubscriber
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(
            Consumer<DeleteSubscriberRequest.Builder> deleteSubscriberRequest) {
        return deleteSubscriber(DeleteSubscriberRequest.builder().applyMutation(deleteSubscriberRequest).build());
    }

    /**
     * <p>
     * Describes a budget.
     * </p>
     * <important>
     * <p>
     * The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see
     * the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important>
     *
     * @param describeBudgetRequest
     *        Request of DescribeBudget
     * @return A Java Future containing the result of the DescribeBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudget
     */
    default CompletableFuture<DescribeBudgetResponse> describeBudget(DescribeBudgetRequest describeBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a budget.
     * </p>
     * <important>
     * <p>
     * The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see
     * the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudget.html#API_DescribeBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBudgetRequest#builder()}
     * </p>
     *
     * @param describeBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest.Builder} to create a request.
     *        Request of DescribeBudget
     * @return A Java Future containing the result of the DescribeBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudget
     */
    default CompletableFuture<DescribeBudgetResponse> describeBudget(Consumer<DescribeBudgetRequest.Builder> describeBudgetRequest) {
        return describeBudget(DescribeBudgetRequest.builder().applyMutation(describeBudgetRequest).build());
    }

    /**
     * <p>
     * Describes a budget action detail.
     * </p>
     *
     * @param describeBudgetActionRequest
     * @return A Java Future containing the result of the DescribeBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetAction
     */
    default CompletableFuture<DescribeBudgetActionResponse> describeBudgetAction(
            DescribeBudgetActionRequest describeBudgetActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a budget action detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBudgetActionRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetAction
     */
    default CompletableFuture<DescribeBudgetActionResponse> describeBudgetAction(
            Consumer<DescribeBudgetActionRequest.Builder> describeBudgetActionRequest) {
        return describeBudgetAction(DescribeBudgetActionRequest.builder().applyMutation(describeBudgetActionRequest).build());
    }

    /**
     * <p>
     * Describes a budget action history detail.
     * </p>
     *
     * @param describeBudgetActionHistoriesRequest
     * @return A Java Future containing the result of the DescribeBudgetActionHistories operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionHistories
     */
    default CompletableFuture<DescribeBudgetActionHistoriesResponse> describeBudgetActionHistories(
            DescribeBudgetActionHistoriesRequest describeBudgetActionHistoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a budget action history detail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionHistoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionHistoriesRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionHistoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBudgetActionHistories operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionHistories
     */
    default CompletableFuture<DescribeBudgetActionHistoriesResponse> describeBudgetActionHistories(
            Consumer<DescribeBudgetActionHistoriesRequest.Builder> describeBudgetActionHistoriesRequest) {
        return describeBudgetActionHistories(DescribeBudgetActionHistoriesRequest.builder()
                .applyMutation(describeBudgetActionHistoriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionHistories(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionHistoriesPublisher publisher = client.describeBudgetActionHistoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionHistoriesPublisher publisher = client.describeBudgetActionHistoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionHistories(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBudgetActionHistoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionHistories
     */
    default DescribeBudgetActionHistoriesPublisher describeBudgetActionHistoriesPaginator(
            DescribeBudgetActionHistoriesRequest describeBudgetActionHistoriesRequest) {
        return new DescribeBudgetActionHistoriesPublisher(this, describeBudgetActionHistoriesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionHistories(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionHistoriesPublisher publisher = client.describeBudgetActionHistoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionHistoriesPublisher publisher = client.describeBudgetActionHistoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionHistories(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionHistoriesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionHistoriesRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionHistoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionHistories
     */
    default DescribeBudgetActionHistoriesPublisher describeBudgetActionHistoriesPaginator(
            Consumer<DescribeBudgetActionHistoriesRequest.Builder> describeBudgetActionHistoriesRequest) {
        return describeBudgetActionHistoriesPaginator(DescribeBudgetActionHistoriesRequest.builder()
                .applyMutation(describeBudgetActionHistoriesRequest).build());
    }

    /**
     * <p>
     * Describes all of the budget actions for an account.
     * </p>
     *
     * @param describeBudgetActionsForAccountRequest
     * @return A Java Future containing the result of the DescribeBudgetActionsForAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForAccount
     */
    default CompletableFuture<DescribeBudgetActionsForAccountResponse> describeBudgetActionsForAccount(
            DescribeBudgetActionsForAccountRequest describeBudgetActionsForAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all of the budget actions for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionsForAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionsForAccountRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionsForAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBudgetActionsForAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForAccount
     */
    default CompletableFuture<DescribeBudgetActionsForAccountResponse> describeBudgetActionsForAccount(
            Consumer<DescribeBudgetActionsForAccountRequest.Builder> describeBudgetActionsForAccountRequest) {
        return describeBudgetActionsForAccount(DescribeBudgetActionsForAccountRequest.builder()
                .applyMutation(describeBudgetActionsForAccountRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForAccountPublisher publisher = client.describeBudgetActionsForAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForAccountPublisher publisher = client.describeBudgetActionsForAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBudgetActionsForAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForAccount
     */
    default DescribeBudgetActionsForAccountPublisher describeBudgetActionsForAccountPaginator(
            DescribeBudgetActionsForAccountRequest describeBudgetActionsForAccountRequest) {
        return new DescribeBudgetActionsForAccountPublisher(this, describeBudgetActionsForAccountRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForAccountPublisher publisher = client.describeBudgetActionsForAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForAccountPublisher publisher = client.describeBudgetActionsForAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionsForAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionsForAccountRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionsForAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForAccountRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForAccount
     */
    default DescribeBudgetActionsForAccountPublisher describeBudgetActionsForAccountPaginator(
            Consumer<DescribeBudgetActionsForAccountRequest.Builder> describeBudgetActionsForAccountRequest) {
        return describeBudgetActionsForAccountPaginator(DescribeBudgetActionsForAccountRequest.builder()
                .applyMutation(describeBudgetActionsForAccountRequest).build());
    }

    /**
     * <p>
     * Describes all of the budget actions for a budget.
     * </p>
     *
     * @param describeBudgetActionsForBudgetRequest
     * @return A Java Future containing the result of the DescribeBudgetActionsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForBudget
     */
    default CompletableFuture<DescribeBudgetActionsForBudgetResponse> describeBudgetActionsForBudget(
            DescribeBudgetActionsForBudgetRequest describeBudgetActionsForBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all of the budget actions for a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionsForBudgetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionsForBudgetRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionsForBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBudgetActionsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForBudget
     */
    default CompletableFuture<DescribeBudgetActionsForBudgetResponse> describeBudgetActionsForBudget(
            Consumer<DescribeBudgetActionsForBudgetRequest.Builder> describeBudgetActionsForBudgetRequest) {
        return describeBudgetActionsForBudget(DescribeBudgetActionsForBudgetRequest.builder()
                .applyMutation(describeBudgetActionsForBudgetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionsForBudget(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForBudgetPublisher publisher = client.describeBudgetActionsForBudgetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForBudgetPublisher publisher = client.describeBudgetActionsForBudgetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionsForBudget(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBudgetActionsForBudgetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForBudget
     */
    default DescribeBudgetActionsForBudgetPublisher describeBudgetActionsForBudgetPaginator(
            DescribeBudgetActionsForBudgetRequest describeBudgetActionsForBudgetRequest) {
        return new DescribeBudgetActionsForBudgetPublisher(this, describeBudgetActionsForBudgetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetActionsForBudget(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForBudgetPublisher publisher = client.describeBudgetActionsForBudgetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetActionsForBudgetPublisher publisher = client.describeBudgetActionsForBudgetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetActionsForBudget(software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetActionsForBudgetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetActionsForBudgetRequest#builder()}
     * </p>
     *
     * @param describeBudgetActionsForBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetActionsForBudgetRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetActionsForBudget
     */
    default DescribeBudgetActionsForBudgetPublisher describeBudgetActionsForBudgetPaginator(
            Consumer<DescribeBudgetActionsForBudgetRequest.Builder> describeBudgetActionsForBudgetRequest) {
        return describeBudgetActionsForBudgetPaginator(DescribeBudgetActionsForBudgetRequest.builder()
                .applyMutation(describeBudgetActionsForBudgetRequest).build());
    }

    /**
     * <p>
     * Lists the budget names and notifications that are associated with an account.
     * </p>
     *
     * @param describeBudgetNotificationsForAccountRequest
     * @return A Java Future containing the result of the DescribeBudgetNotificationsForAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetNotificationsForAccount
     */
    default CompletableFuture<DescribeBudgetNotificationsForAccountResponse> describeBudgetNotificationsForAccount(
            DescribeBudgetNotificationsForAccountRequest describeBudgetNotificationsForAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the budget names and notifications that are associated with an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeBudgetNotificationsForAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeBudgetNotificationsForAccountRequest#builder()}
     * </p>
     *
     * @param describeBudgetNotificationsForAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeBudgetNotificationsForAccount operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetNotificationsForAccount
     */
    default CompletableFuture<DescribeBudgetNotificationsForAccountResponse> describeBudgetNotificationsForAccount(
            Consumer<DescribeBudgetNotificationsForAccountRequest.Builder> describeBudgetNotificationsForAccountRequest) {
        return describeBudgetNotificationsForAccount(DescribeBudgetNotificationsForAccountRequest.builder()
                .applyMutation(describeBudgetNotificationsForAccountRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetNotificationsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetNotificationsForAccountPublisher publisher = client.describeBudgetNotificationsForAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetNotificationsForAccountPublisher publisher = client.describeBudgetNotificationsForAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetNotificationsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBudgetNotificationsForAccountRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetNotificationsForAccount
     */
    default DescribeBudgetNotificationsForAccountPublisher describeBudgetNotificationsForAccountPaginator(
            DescribeBudgetNotificationsForAccountRequest describeBudgetNotificationsForAccountRequest) {
        return new DescribeBudgetNotificationsForAccountPublisher(this, describeBudgetNotificationsForAccountRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetNotificationsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetNotificationsForAccountPublisher publisher = client.describeBudgetNotificationsForAccountPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetNotificationsForAccountPublisher publisher = client.describeBudgetNotificationsForAccountPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetNotificationsForAccount(software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeBudgetNotificationsForAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeBudgetNotificationsForAccountRequest#builder()}
     * </p>
     *
     * @param describeBudgetNotificationsForAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetNotificationsForAccountRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetNotificationsForAccount
     */
    default DescribeBudgetNotificationsForAccountPublisher describeBudgetNotificationsForAccountPaginator(
            Consumer<DescribeBudgetNotificationsForAccountRequest.Builder> describeBudgetNotificationsForAccountRequest) {
        return describeBudgetNotificationsForAccountPaginator(DescribeBudgetNotificationsForAccountRequest.builder()
                .applyMutation(describeBudgetNotificationsForAccountRequest).build());
    }

    /**
     * <p>
     * Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget
     * history isn't available for <code>ANNUAL</code> budgets.
     * </p>
     *
     * @param describeBudgetPerformanceHistoryRequest
     * @return A Java Future containing the result of the DescribeBudgetPerformanceHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetPerformanceHistory
     */
    default CompletableFuture<DescribeBudgetPerformanceHistoryResponse> describeBudgetPerformanceHistory(
            DescribeBudgetPerformanceHistoryRequest describeBudgetPerformanceHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the history for <code>DAILY</code>, <code>MONTHLY</code>, and <code>QUARTERLY</code> budgets. Budget
     * history isn't available for <code>ANNUAL</code> budgets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetPerformanceHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetPerformanceHistoryRequest#builder()}
     * </p>
     *
     * @param describeBudgetPerformanceHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeBudgetPerformanceHistory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetPerformanceHistory
     */
    default CompletableFuture<DescribeBudgetPerformanceHistoryResponse> describeBudgetPerformanceHistory(
            Consumer<DescribeBudgetPerformanceHistoryRequest.Builder> describeBudgetPerformanceHistoryRequest) {
        return describeBudgetPerformanceHistory(DescribeBudgetPerformanceHistoryRequest.builder()
                .applyMutation(describeBudgetPerformanceHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetPerformanceHistory(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetPerformanceHistoryPublisher publisher = client.describeBudgetPerformanceHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetPerformanceHistoryPublisher publisher = client.describeBudgetPerformanceHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetPerformanceHistory(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBudgetPerformanceHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetPerformanceHistory
     */
    default DescribeBudgetPerformanceHistoryPublisher describeBudgetPerformanceHistoryPaginator(
            DescribeBudgetPerformanceHistoryRequest describeBudgetPerformanceHistoryRequest) {
        return new DescribeBudgetPerformanceHistoryPublisher(this, describeBudgetPerformanceHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgetPerformanceHistory(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetPerformanceHistoryPublisher publisher = client.describeBudgetPerformanceHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetPerformanceHistoryPublisher publisher = client.describeBudgetPerformanceHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgetPerformanceHistory(software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetPerformanceHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBudgetPerformanceHistoryRequest#builder()}
     * </p>
     *
     * @param describeBudgetPerformanceHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetPerformanceHistoryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgetPerformanceHistory
     */
    default DescribeBudgetPerformanceHistoryPublisher describeBudgetPerformanceHistoryPaginator(
            Consumer<DescribeBudgetPerformanceHistoryRequest.Builder> describeBudgetPerformanceHistoryRequest) {
        return describeBudgetPerformanceHistoryPaginator(DescribeBudgetPerformanceHistoryRequest.builder()
                .applyMutation(describeBudgetPerformanceHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the budgets that are associated with an account.
     * </p>
     * <important>
     * <p>
     * The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see
     * the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples"
     * >Examples</a> section.
     * </p>
     * </important>
     *
     * @param describeBudgetsRequest
     *        Request of DescribeBudgets
     * @return A Java Future containing the result of the DescribeBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default CompletableFuture<DescribeBudgetsResponse> describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the budgets that are associated with an account.
     * </p>
     * <important>
     * <p>
     * The Request Syntax section shows the <code>BudgetLimit</code> syntax. For <code>PlannedBudgetLimits</code>, see
     * the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_DescribeBudgets.html#API_DescribeBudgets_Examples"
     * >Examples</a> section.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBudgetsRequest#builder()}
     * </p>
     *
     * @param describeBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest.Builder} to create a request.
     *        Request of DescribeBudgets
     * @return A Java Future containing the result of the DescribeBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default CompletableFuture<DescribeBudgetsResponse> describeBudgets(
            Consumer<DescribeBudgetsRequest.Builder> describeBudgetsRequest) {
        return describeBudgets(DescribeBudgetsRequest.builder().applyMutation(describeBudgetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgets(software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetsPublisher publisher = client.describeBudgetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetsPublisher publisher = client.describeBudgetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgets(software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest)} operation.</b>
     * </p>
     *
     * @param describeBudgetsRequest
     *        Request of DescribeBudgets
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default DescribeBudgetsPublisher describeBudgetsPaginator(DescribeBudgetsRequest describeBudgetsRequest) {
        return new DescribeBudgetsPublisher(this, describeBudgetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBudgets(software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetsPublisher publisher = client.describeBudgetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeBudgetsPublisher publisher = client.describeBudgetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBudgets(software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBudgetsRequest#builder()}
     * </p>
     *
     * @param describeBudgetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest.Builder} to create a request.
     *        Request of DescribeBudgets
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default DescribeBudgetsPublisher describeBudgetsPaginator(Consumer<DescribeBudgetsRequest.Builder> describeBudgetsRequest) {
        return describeBudgetsPaginator(DescribeBudgetsRequest.builder().applyMutation(describeBudgetsRequest).build());
    }

    /**
     * <p>
     * Lists the notifications that are associated with a budget.
     * </p>
     *
     * @param describeNotificationsForBudgetRequest
     *        Request of DescribeNotificationsForBudget
     * @return A Java Future containing the result of the DescribeNotificationsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default CompletableFuture<DescribeNotificationsForBudgetResponse> describeNotificationsForBudget(
            DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the notifications that are associated with a budget.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationsForBudgetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationsForBudgetRequest#builder()}
     * </p>
     *
     * @param describeNotificationsForBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest.Builder} to
     *        create a request. Request of DescribeNotificationsForBudget
     * @return A Java Future containing the result of the DescribeNotificationsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default CompletableFuture<DescribeNotificationsForBudgetResponse> describeNotificationsForBudget(
            Consumer<DescribeNotificationsForBudgetRequest.Builder> describeNotificationsForBudgetRequest) {
        return describeNotificationsForBudget(DescribeNotificationsForBudgetRequest.builder()
                .applyMutation(describeNotificationsForBudgetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationsForBudget(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeNotificationsForBudgetPublisher publisher = client.describeNotificationsForBudgetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeNotificationsForBudgetPublisher publisher = client.describeNotificationsForBudgetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationsForBudget(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNotificationsForBudgetRequest
     *        Request of DescribeNotificationsForBudget
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default DescribeNotificationsForBudgetPublisher describeNotificationsForBudgetPaginator(
            DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        return new DescribeNotificationsForBudgetPublisher(this, describeNotificationsForBudgetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeNotificationsForBudget(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeNotificationsForBudgetPublisher publisher = client.describeNotificationsForBudgetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeNotificationsForBudgetPublisher publisher = client.describeNotificationsForBudgetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNotificationsForBudget(software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationsForBudgetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationsForBudgetRequest#builder()}
     * </p>
     *
     * @param describeNotificationsForBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest.Builder} to
     *        create a request. Request of DescribeNotificationsForBudget
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default DescribeNotificationsForBudgetPublisher describeNotificationsForBudgetPaginator(
            Consumer<DescribeNotificationsForBudgetRequest.Builder> describeNotificationsForBudgetRequest) {
        return describeNotificationsForBudgetPaginator(DescribeNotificationsForBudgetRequest.builder()
                .applyMutation(describeNotificationsForBudgetRequest).build());
    }

    /**
     * <p>
     * Lists the subscribers that are associated with a notification.
     * </p>
     *
     * @param describeSubscribersForNotificationRequest
     *        Request of DescribeSubscribersForNotification
     * @return A Java Future containing the result of the DescribeSubscribersForNotification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default CompletableFuture<DescribeSubscribersForNotificationResponse> describeSubscribersForNotification(
            DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the subscribers that are associated with a notification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribersForNotificationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSubscribersForNotificationRequest#builder()}
     * </p>
     *
     * @param describeSubscribersForNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest.Builder} to
     *        create a request. Request of DescribeSubscribersForNotification
     * @return A Java Future containing the result of the DescribeSubscribersForNotification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default CompletableFuture<DescribeSubscribersForNotificationResponse> describeSubscribersForNotification(
            Consumer<DescribeSubscribersForNotificationRequest.Builder> describeSubscribersForNotificationRequest) {
        return describeSubscribersForNotification(DescribeSubscribersForNotificationRequest.builder()
                .applyMutation(describeSubscribersForNotificationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSubscribersForNotification(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeSubscribersForNotificationPublisher publisher = client.describeSubscribersForNotificationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeSubscribersForNotificationPublisher publisher = client.describeSubscribersForNotificationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubscribersForNotification(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSubscribersForNotificationRequest
     *        Request of DescribeSubscribersForNotification
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default DescribeSubscribersForNotificationPublisher describeSubscribersForNotificationPaginator(
            DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        return new DescribeSubscribersForNotificationPublisher(this, describeSubscribersForNotificationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSubscribersForNotification(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeSubscribersForNotificationPublisher publisher = client.describeSubscribersForNotificationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.budgets.paginators.DescribeSubscribersForNotificationPublisher publisher = client.describeSubscribersForNotificationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSubscribersForNotification(software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribersForNotificationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSubscribersForNotificationRequest#builder()}
     * </p>
     *
     * @param describeSubscribersForNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest.Builder} to
     *        create a request. Request of DescribeSubscribersForNotification
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidNextTokenException The pagination token is invalid.</li>
     *         <li>ExpiredNextTokenException The pagination token expired.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default DescribeSubscribersForNotificationPublisher describeSubscribersForNotificationPaginator(
            Consumer<DescribeSubscribersForNotificationRequest.Builder> describeSubscribersForNotificationRequest) {
        return describeSubscribersForNotificationPaginator(DescribeSubscribersForNotificationRequest.builder()
                .applyMutation(describeSubscribersForNotificationRequest).build());
    }

    /**
     * <p>
     * Executes a budget action.
     * </p>
     *
     * @param executeBudgetActionRequest
     * @return A Java Future containing the result of the ExecuteBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.ExecuteBudgetAction
     */
    default CompletableFuture<ExecuteBudgetActionResponse> executeBudgetAction(
            ExecuteBudgetActionRequest executeBudgetActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a budget action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteBudgetActionRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteBudgetActionRequest#builder()}
     * </p>
     *
     * @param executeBudgetActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.ExecuteBudgetActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExecuteBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.ExecuteBudgetAction
     */
    default CompletableFuture<ExecuteBudgetActionResponse> executeBudgetAction(
            Consumer<ExecuteBudgetActionRequest.Builder> executeBudgetActionRequest) {
        return executeBudgetAction(ExecuteBudgetActionRequest.builder().applyMutation(executeBudgetActionRequest).build());
    }

    /**
     * <p>
     * Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the
     * <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until
     * Amazon Web Services has new usage data to use for forecasting.
     * </p>
     * <important>
     * <p>
     * Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one
     * time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code>
     * syntax. For <code>PlannedBudgetLimits</code>, see the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important>
     *
     * @param updateBudgetRequest
     *        Request of UpdateBudget
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudget
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a budget. You can change every part of a budget except for the <code>budgetName</code> and the
     * <code>calculatedSpend</code>. When you modify a budget, the <code>calculatedSpend</code> drops to zero until
     * Amazon Web Services has new usage data to use for forecasting.
     * </p>
     * <important>
     * <p>
     * Only one of <code>BudgetLimit</code> or <code>PlannedBudgetLimits</code> can be present in the syntax at one
     * time. Use the syntax that matches your case. The Request Syntax section shows the <code>BudgetLimit</code>
     * syntax. For <code>PlannedBudgetLimits</code>, see the <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_UpdateBudget.html#API_UpdateBudget_Examples"
     * >Examples</a> section.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBudgetRequest#builder()}
     * </p>
     *
     * @param updateBudgetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest.Builder} to create a request.
     *        Request of UpdateBudget
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudget
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(Consumer<UpdateBudgetRequest.Builder> updateBudgetRequest) {
        return updateBudget(UpdateBudgetRequest.builder().applyMutation(updateBudgetRequest).build());
    }

    /**
     * <p>
     * Updates a budget action.
     * </p>
     *
     * @param updateBudgetActionRequest
     * @return A Java Future containing the result of the UpdateBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudgetAction
     */
    default CompletableFuture<UpdateBudgetActionResponse> updateBudgetAction(UpdateBudgetActionRequest updateBudgetActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a budget action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBudgetActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBudgetActionRequest#builder()}
     * </p>
     *
     * @param updateBudgetActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.UpdateBudgetActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBudgetAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ResourceLockedException The request was received and recognized by the server, but the server
     *         rejected that particular method for the requested resource.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudgetAction
     */
    default CompletableFuture<UpdateBudgetActionResponse> updateBudgetAction(
            Consumer<UpdateBudgetActionRequest.Builder> updateBudgetActionRequest) {
        return updateBudgetAction(UpdateBudgetActionRequest.builder().applyMutation(updateBudgetActionRequest).build());
    }

    /**
     * <p>
     * Updates a notification.
     * </p>
     *
     * @param updateNotificationRequest
     *        Request of UpdateNotification
     * @return A Java Future containing the result of the UpdateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateNotification
     */
    default CompletableFuture<UpdateNotificationResponse> updateNotification(UpdateNotificationRequest updateNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a notification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNotificationRequest#builder()}
     * </p>
     *
     * @param updateNotificationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest.Builder} to create a
     *        request. Request of UpdateNotification
     * @return A Java Future containing the result of the UpdateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateNotification
     */
    default CompletableFuture<UpdateNotificationResponse> updateNotification(
            Consumer<UpdateNotificationRequest.Builder> updateNotificationRequest) {
        return updateNotification(UpdateNotificationRequest.builder().applyMutation(updateNotificationRequest).build());
    }

    /**
     * <p>
     * Updates a subscriber.
     * </p>
     *
     * @param updateSubscriberRequest
     *        Request of UpdateSubscriber
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateSubscriber
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a subscriber.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubscriberRequest#builder()}
     * </p>
     *
     * @param updateSubscriberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest.Builder} to create a request.
     *        Request of UpdateSubscriber
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException An error on the server occurred during the processing of your request. Try
     *         again later.</li>
     *         <li>InvalidParameterException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>NotFoundException We can’t locate the resource that you specified.</li>
     *         <li>DuplicateRecordException The budget name already exists. Budget names must be unique within an
     *         account.</li>
     *         <li>AccessDeniedException You are not authorized to use this operation with the given parameters.</li>
     *         <li>ThrottlingException The number of API requests has exceeded the maximum allowed API request
     *         throttling limit for the account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateSubscriber
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(
            Consumer<UpdateSubscriberRequest.Builder> updateSubscriberRequest) {
        return updateSubscriber(UpdateSubscriberRequest.builder().applyMutation(updateSubscriberRequest).build());
    }

    @Override
    default BudgetsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BudgetsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BudgetsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BudgetsAsyncClient}.
     */
    static BudgetsAsyncClientBuilder builder() {
        return new DefaultBudgetsAsyncClientBuilder();
    }
}
