/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request of UpdateBudget
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBudgetRequest extends BudgetsRequest implements
        ToCopyableBuilder<UpdateBudgetRequest.Builder, UpdateBudgetRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBudgetRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<Budget> NEW_BUDGET_FIELD = SdkField.<Budget> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateBudgetRequest::newBudget)).setter(setter(Builder::newBudget)).constructor(Budget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewBudget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            NEW_BUDGET_FIELD));

    private final String accountId;

    private final Budget newBudget;

    private UpdateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.newBudget = builder.newBudget;
    }

    /**
     * <p>
     * The <code>accountId</code> that is associated with the budget that you want to update.
     * </p>
     * 
     * @return The <code>accountId</code> that is associated with the budget that you want to update.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The budget that you want to update your budget to.
     * </p>
     * 
     * @return The budget that you want to update your budget to.
     */
    public Budget newBudget() {
        return newBudget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(newBudget());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(newBudget(), other.newBudget());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateBudgetRequest").add("AccountId", accountId()).add("NewBudget", newBudget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "NewBudget":
            return Optional.ofNullable(clazz.cast(newBudget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetRequest, T> g) {
        return obj -> g.apply((UpdateBudgetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBudgetRequest> {
        /**
         * <p>
         * The <code>accountId</code> that is associated with the budget that you want to update.
         * </p>
         * 
         * @param accountId
         *        The <code>accountId</code> that is associated with the budget that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The budget that you want to update your budget to.
         * </p>
         * 
         * @param newBudget
         *        The budget that you want to update your budget to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newBudget(Budget newBudget);

        /**
         * <p>
         * The budget that you want to update your budget to.
         * </p>
         * This is a convenience that creates an instance of the {@link Budget.Builder} avoiding the need to create one
         * manually via {@link Budget#builder()}.
         *
         * When the {@link Consumer} completes, {@link Budget.Builder#build()} is called immediately and its result is
         * passed to {@link #newBudget(Budget)}.
         * 
         * @param newBudget
         *        a consumer that will call methods on {@link Budget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newBudget(Budget)
         */
        default Builder newBudget(Consumer<Budget.Builder> newBudget) {
            return newBudget(Budget.builder().applyMutation(newBudget).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private Budget newBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            super(model);
            accountId(model.accountId);
            newBudget(model.newBudget);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget.Builder getNewBudget() {
            return newBudget != null ? newBudget.toBuilder() : null;
        }

        @Override
        public final Builder newBudget(Budget newBudget) {
            this.newBudget = newBudget;
            return this;
        }

        public final void setNewBudget(Budget.BuilderImpl newBudget) {
            this.newBudget = newBudget != null ? newBudget.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
