/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBudgetPerformanceHistoryResponse extends BudgetsResponse implements
        ToCopyableBuilder<DescribeBudgetPerformanceHistoryResponse.Builder, DescribeBudgetPerformanceHistoryResponse> {
    private static final SdkField<BudgetPerformanceHistory> BUDGET_PERFORMANCE_HISTORY_FIELD = SdkField
            .<BudgetPerformanceHistory> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeBudgetPerformanceHistoryResponse::budgetPerformanceHistory))
            .setter(setter(Builder::budgetPerformanceHistory)).constructor(BudgetPerformanceHistory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetPerformanceHistory").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBudgetPerformanceHistoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUDGET_PERFORMANCE_HISTORY_FIELD, NEXT_TOKEN_FIELD));

    private final BudgetPerformanceHistory budgetPerformanceHistory;

    private final String nextToken;

    private DescribeBudgetPerformanceHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.budgetPerformanceHistory = builder.budgetPerformanceHistory;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The history of how often the budget has gone into an <code>ALARM</code> state.
     * </p>
     * <p>
     * For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For
     * <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last 12
     * months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four quarters.
     * </p>
     * 
     * @return The history of how often the budget has gone into an <code>ALARM</code> state.</p>
     *         <p>
     *         For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For
     *         <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the
     *         last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the
     *         last four quarters.
     */
    public BudgetPerformanceHistory budgetPerformanceHistory() {
        return budgetPerformanceHistory;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(budgetPerformanceHistory());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetPerformanceHistoryResponse)) {
            return false;
        }
        DescribeBudgetPerformanceHistoryResponse other = (DescribeBudgetPerformanceHistoryResponse) obj;
        return Objects.equals(budgetPerformanceHistory(), other.budgetPerformanceHistory())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeBudgetPerformanceHistoryResponse")
                .add("BudgetPerformanceHistory", budgetPerformanceHistory()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BudgetPerformanceHistory":
            return Optional.ofNullable(clazz.cast(budgetPerformanceHistory()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBudgetPerformanceHistoryResponse, T> g) {
        return obj -> g.apply((DescribeBudgetPerformanceHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBudgetPerformanceHistoryResponse> {
        /**
         * <p>
         * The history of how often the budget has gone into an <code>ALARM</code> state.
         * </p>
         * <p>
         * For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For
         * <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last
         * 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four
         * quarters.
         * </p>
         * 
         * @param budgetPerformanceHistory
         *        The history of how often the budget has gone into an <code>ALARM</code> state.</p>
         *        <p>
         *        For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For
         *        <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the
         *        last 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the
         *        last four quarters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetPerformanceHistory(BudgetPerformanceHistory budgetPerformanceHistory);

        /**
         * <p>
         * The history of how often the budget has gone into an <code>ALARM</code> state.
         * </p>
         * <p>
         * For <code>DAILY</code> budgets, the history saves the state of the budget for the last 60 days. For
         * <code>MONTHLY</code> budgets, the history saves the state of the budget for the current month plus the last
         * 12 months. For <code>QUARTERLY</code> budgets, the history saves the state of the budget for the last four
         * quarters.
         * </p>
         * This is a convenience that creates an instance of the {@link BudgetPerformanceHistory.Builder} avoiding the
         * need to create one manually via {@link BudgetPerformanceHistory#builder()}.
         *
         * When the {@link Consumer} completes, {@link BudgetPerformanceHistory.Builder#build()} is called immediately
         * and its result is passed to {@link #budgetPerformanceHistory(BudgetPerformanceHistory)}.
         * 
         * @param budgetPerformanceHistory
         *        a consumer that will call methods on {@link BudgetPerformanceHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #budgetPerformanceHistory(BudgetPerformanceHistory)
         */
        default Builder budgetPerformanceHistory(Consumer<BudgetPerformanceHistory.Builder> budgetPerformanceHistory) {
            return budgetPerformanceHistory(BudgetPerformanceHistory.builder().applyMutation(budgetPerformanceHistory).build());
        }

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BudgetsResponse.BuilderImpl implements Builder {
        private BudgetPerformanceHistory budgetPerformanceHistory;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetPerformanceHistoryResponse model) {
            super(model);
            budgetPerformanceHistory(model.budgetPerformanceHistory);
            nextToken(model.nextToken);
        }

        public final BudgetPerformanceHistory.Builder getBudgetPerformanceHistory() {
            return budgetPerformanceHistory != null ? budgetPerformanceHistory.toBuilder() : null;
        }

        @Override
        public final Builder budgetPerformanceHistory(BudgetPerformanceHistory budgetPerformanceHistory) {
            this.budgetPerformanceHistory = budgetPerformanceHistory;
            return this;
        }

        public final void setBudgetPerformanceHistory(BudgetPerformanceHistory.BuilderImpl budgetPerformanceHistory) {
            this.budgetPerformanceHistory = budgetPerformanceHistory != null ? budgetPerformanceHistory.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBudgetPerformanceHistoryResponse build() {
            return new DescribeBudgetPerformanceHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
