/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Identity and Access Management (IAM) action definition details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<IamActionDefinition.Builder, IamActionDefinition> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(IamActionDefinition::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<List<String>> ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Roles")
            .getter(getter(IamActionDefinition::roles))
            .setter(setter(Builder::roles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(IamActionDefinition::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(IamActionDefinition::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, ROLES_FIELD,
            GROUPS_FIELD, USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyArn;

    private final List<String> roles;

    private final List<String> groups;

    private final List<String> users;

    private IamActionDefinition(BuilderImpl builder) {
        this.policyArn = builder.policyArn;
        this.roles = builder.roles;
        this.groups = builder.groups;
        this.users = builder.users;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy to be attached.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy to be attached.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of roles to be attached. There must be at least one role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return A list of roles to be attached. There must be at least one role.
     */
    public final List<String> roles() {
        return roles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of groups to be attached. There must be at least one group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return A list of groups to be attached. There must be at least one group.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users to be attached. There must be at least one user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return A list of users to be attached. There must be at least one user.
     */
    public final List<String> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamActionDefinition)) {
            return false;
        }
        IamActionDefinition other = (IamActionDefinition) obj;
        return Objects.equals(policyArn(), other.policyArn()) && hasRoles() == other.hasRoles()
                && Objects.equals(roles(), other.roles()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamActionDefinition").add("PolicyArn", policyArn()).add("Roles", hasRoles() ? roles() : null)
                .add("Groups", hasGroups() ? groups() : null).add("Users", hasUsers() ? users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "Roles":
            return Optional.ofNullable(clazz.cast(roles()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyArn", POLICY_ARN_FIELD);
        map.put("Roles", ROLES_FIELD);
        map.put("Groups", GROUPS_FIELD);
        map.put("Users", USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamActionDefinition, T> g) {
        return obj -> g.apply((IamActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamActionDefinition> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy to be attached.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the policy to be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * A list of roles to be attached. There must be at least one role.
         * </p>
         * 
         * @param roles
         *        A list of roles to be attached. There must be at least one role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Collection<String> roles);

        /**
         * <p>
         * A list of roles to be attached. There must be at least one role.
         * </p>
         * 
         * @param roles
         *        A list of roles to be attached. There must be at least one role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(String... roles);

        /**
         * <p>
         * A list of groups to be attached. There must be at least one group.
         * </p>
         * 
         * @param groups
         *        A list of groups to be attached. There must be at least one group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * A list of groups to be attached. There must be at least one group.
         * </p>
         * 
         * @param groups
         *        A list of groups to be attached. There must be at least one group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * A list of users to be attached. There must be at least one user.
         * </p>
         * 
         * @param users
         *        A list of users to be attached. There must be at least one user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<String> users);

        /**
         * <p>
         * A list of users to be attached. There must be at least one user.
         * </p>
         * 
         * @param users
         *        A list of users to be attached. There must be at least one user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(String... users);
    }

    static final class BuilderImpl implements Builder {
        private String policyArn;

        private List<String> roles = DefaultSdkAutoConstructList.getInstance();

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private List<String> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IamActionDefinition model) {
            policyArn(model.policyArn);
            roles(model.roles);
            groups(model.groups);
            users(model.users);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Collection<String> getRoles() {
            if (roles instanceof SdkAutoConstructList) {
                return null;
            }
            return roles;
        }

        public final void setRoles(Collection<String> roles) {
            this.roles = RolesCopier.copy(roles);
        }

        @Override
        public final Builder roles(Collection<String> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(String... roles) {
            roles(Arrays.asList(roles));
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final Collection<String> getUsers() {
            if (users instanceof SdkAutoConstructList) {
                return null;
            }
            return users;
        }

        public final void setUsers(Collection<String> users) {
            this.users = UsersCopier.copy(users);
        }

        @Override
        public final Builder users(Collection<String> users) {
            this.users = UsersCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(String... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        public IamActionDefinition build() {
            return new IamActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
