/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use Expression to filter in various Budgets APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<List<Expression>> OR_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("Or")
            .getter(getter(Expression::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Expression>> AND_FIELD = SdkField
            .<List<Expression>> builder(MarshallingType.LIST)
            .memberName("And")
            .getter(getter(Expression::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Expression> builder(MarshallingType.SDK_POJO)
                                            .constructor(Expression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Expression> NOT_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Not").getter(getter(Expression::not)).setter(setter(Builder::not)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Not").build()).build();

    private static final SdkField<ExpressionDimensionValues> DIMENSIONS_FIELD = SdkField
            .<ExpressionDimensionValues> builder(MarshallingType.SDK_POJO).memberName("Dimensions")
            .getter(getter(Expression::dimensions)).setter(setter(Builder::dimensions))
            .constructor(ExpressionDimensionValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<TagValues> TAGS_FIELD = SdkField.<TagValues> builder(MarshallingType.SDK_POJO)
            .memberName("Tags").getter(getter(Expression::tags)).setter(setter(Builder::tags)).constructor(TagValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build()).build();

    private static final SdkField<CostCategoryValues> COST_CATEGORIES_FIELD = SdkField
            .<CostCategoryValues> builder(MarshallingType.SDK_POJO).memberName("CostCategories")
            .getter(getter(Expression::costCategories)).setter(setter(Builder::costCategories))
            .constructor(CostCategoryValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategories").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_FIELD, AND_FIELD,
            NOT_FIELD, DIMENSIONS_FIELD, TAGS_FIELD, COST_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Expression> or;

    private final List<Expression> and;

    private final Expression not;

    private final ExpressionDimensionValues dimensions;

    private final TagValues tags;

    private final CostCategoryValues costCategories;

    private Expression(BuilderImpl builder) {
        this.or = builder.or;
        this.and = builder.and;
        this.not = builder.not;
        this.dimensions = builder.dimensions;
        this.tags = builder.tags;
        this.costCategories = builder.costCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return results that match either Dimension object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return Return results that match either Dimension object.
     */
    public final List<Expression> or() {
        return or;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Return results that match both Dimension objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return Return results that match both Dimension objects.
     */
    public final List<Expression> and() {
        return and;
    }

    /**
     * <p>
     * Return results that don't match a Dimension object.
     * </p>
     * 
     * @return Return results that don't match a Dimension object.
     */
    public final Expression not() {
        return not;
    }

    /**
     * <p>
     * The specific Dimension to use for Expression.
     * </p>
     * 
     * @return The specific Dimension to use for Expression.
     */
    public final ExpressionDimensionValues dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The specific Tag to use for Expression.
     * </p>
     * 
     * @return The specific Tag to use for Expression.
     */
    public final TagValues tags() {
        return tags;
    }

    /**
     * <p>
     * The filter that's based on CostCategoryValues.
     * </p>
     * 
     * @return The filter that's based on CostCategoryValues.
     */
    public final CostCategoryValues costCategories() {
        return costCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(not());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(costCategories());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return hasOr() == other.hasOr() && Objects.equals(or(), other.or()) && hasAnd() == other.hasAnd()
                && Objects.equals(and(), other.and()) && Objects.equals(not(), other.not())
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(tags(), other.tags())
                && Objects.equals(costCategories(), other.costCategories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("Or", hasOr() ? or() : null).add("And", hasAnd() ? and() : null)
                .add("Not", not()).add("Dimensions", dimensions()).add("Tags", tags()).add("CostCategories", costCategories())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Or":
            return Optional.ofNullable(clazz.cast(or()));
        case "And":
            return Optional.ofNullable(clazz.cast(and()));
        case "Not":
            return Optional.ofNullable(clazz.cast(not()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CostCategories":
            return Optional.ofNullable(clazz.cast(costCategories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Or", OR_FIELD);
        map.put("And", AND_FIELD);
        map.put("Not", NOT_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CostCategories", COST_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * <p>
         * Return results that match either Dimension object.
         * </p>
         * 
         * @param or
         *        Return results that match either Dimension object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<Expression> or);

        /**
         * <p>
         * Return results that match either Dimension object.
         * </p>
         * 
         * @param or
         *        Return results that match either Dimension object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Expression... or);

        /**
         * <p>
         * Return results that match either Dimension object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.budgets.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.budgets.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.budgets.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #or(List<Expression>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.budgets.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<Expression>)
         */
        Builder or(Consumer<Builder>... or);

        /**
         * <p>
         * Return results that match both Dimension objects.
         * </p>
         * 
         * @param and
         *        Return results that match both Dimension objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<Expression> and);

        /**
         * <p>
         * Return results that match both Dimension objects.
         * </p>
         * 
         * @param and
         *        Return results that match both Dimension objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Expression... and);

        /**
         * <p>
         * Return results that match both Dimension objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.budgets.model.Expression.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.budgets.model.Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.budgets.model.Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #and(List<Expression>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.budgets.model.Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<Expression>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * Return results that don't match a Dimension object.
         * </p>
         * 
         * @param not
         *        Return results that don't match a Dimension object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder not(Expression not);

        /**
         * <p>
         * Return results that don't match a Dimension object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #not(Expression)}.
         * 
         * @param not
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #not(Expression)
         */
        default Builder not(Consumer<Builder> not) {
            return not(Expression.builder().applyMutation(not).build());
        }

        /**
         * <p>
         * The specific Dimension to use for Expression.
         * </p>
         * 
         * @param dimensions
         *        The specific Dimension to use for Expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(ExpressionDimensionValues dimensions);

        /**
         * <p>
         * The specific Dimension to use for Expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressionDimensionValues.Builder}
         * avoiding the need to create one manually via {@link ExpressionDimensionValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressionDimensionValues.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensions(ExpressionDimensionValues)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link ExpressionDimensionValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(ExpressionDimensionValues)
         */
        default Builder dimensions(Consumer<ExpressionDimensionValues.Builder> dimensions) {
            return dimensions(ExpressionDimensionValues.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The specific Tag to use for Expression.
         * </p>
         * 
         * @param tags
         *        The specific Tag to use for Expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagValues tags);

        /**
         * <p>
         * The specific Tag to use for Expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagValues.Builder} avoiding the need to
         * create one manually via {@link TagValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagValues.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(TagValues)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link TagValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(TagValues)
         */
        default Builder tags(Consumer<TagValues.Builder> tags) {
            return tags(TagValues.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * The filter that's based on CostCategoryValues.
         * </p>
         * 
         * @param costCategories
         *        The filter that's based on CostCategoryValues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategories(CostCategoryValues costCategories);

        /**
         * <p>
         * The filter that's based on CostCategoryValues.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostCategoryValues.Builder} avoiding the
         * need to create one manually via {@link CostCategoryValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostCategoryValues.Builder#build()} is called immediately and its
         * result is passed to {@link #costCategories(CostCategoryValues)}.
         * 
         * @param costCategories
         *        a consumer that will call methods on {@link CostCategoryValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCategories(CostCategoryValues)
         */
        default Builder costCategories(Consumer<CostCategoryValues.Builder> costCategories) {
            return costCategories(CostCategoryValues.builder().applyMutation(costCategories).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();

        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();

        private Expression not;

        private ExpressionDimensionValues dimensions;

        private TagValues tags;

        private CostCategoryValues costCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            or(model.or);
            and(model.and);
            not(model.not);
            dimensions(model.dimensions);
            tags(model.tags);
            costCategories(model.costCategories);
        }

        public final List<Builder> getOr() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionsCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionsCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAnd() {
            List<Builder> result = ExpressionsCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionsCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionsCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> Expression.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Builder getNot() {
            return not != null ? not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final ExpressionDimensionValues.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(ExpressionDimensionValues.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(ExpressionDimensionValues dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final TagValues.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(TagValues.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(TagValues tags) {
            this.tags = tags;
            return this;
        }

        public final CostCategoryValues.Builder getCostCategories() {
            return costCategories != null ? costCategories.toBuilder() : null;
        }

        public final void setCostCategories(CostCategoryValues.BuilderImpl costCategories) {
            this.costCategories = costCategories != null ? costCategories.build() : null;
        }

        @Override
        public final Builder costCategories(CostCategoryValues costCategories) {
            this.costCategories = costCategories;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
