/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthStatusReason {
    BILLING_VIEW_NO_ACCESS("BILLING_VIEW_NO_ACCESS"),
    BILLING_VIEW_UNHEALTHY("BILLING_VIEW_UNHEALTHY"),
    FILTER_INVALID("FILTER_INVALID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthStatusReason> VALUE_MAP;
    private final String value;

    private HealthStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthStatusReason> knownValues() {
        EnumSet<HealthStatusReason> knownValues = EnumSet.allOf(HealthStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthStatusReason.class, HealthStatusReason::toString);
    }
}

