/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies all of the type-specific parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Definition implements SdkPojo, Serializable, ToCopyableBuilder<Definition.Builder, Definition> {
    private static final SdkField<IamActionDefinition> IAM_ACTION_DEFINITION_FIELD = SdkField
            .<IamActionDefinition> builder(MarshallingType.SDK_POJO).memberName("IamActionDefinition")
            .getter(getter(Definition::iamActionDefinition)).setter(setter(Builder::iamActionDefinition))
            .constructor(IamActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamActionDefinition").build())
            .build();

    private static final SdkField<ScpActionDefinition> SCP_ACTION_DEFINITION_FIELD = SdkField
            .<ScpActionDefinition> builder(MarshallingType.SDK_POJO).memberName("ScpActionDefinition")
            .getter(getter(Definition::scpActionDefinition)).setter(setter(Builder::scpActionDefinition))
            .constructor(ScpActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScpActionDefinition").build())
            .build();

    private static final SdkField<SsmActionDefinition> SSM_ACTION_DEFINITION_FIELD = SdkField
            .<SsmActionDefinition> builder(MarshallingType.SDK_POJO).memberName("SsmActionDefinition")
            .getter(getter(Definition::ssmActionDefinition)).setter(setter(Builder::ssmActionDefinition))
            .constructor(SsmActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmActionDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ACTION_DEFINITION_FIELD,
            SCP_ACTION_DEFINITION_FIELD, SSM_ACTION_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IamActionDefinition iamActionDefinition;

    private final ScpActionDefinition scpActionDefinition;

    private final SsmActionDefinition ssmActionDefinition;

    private Definition(BuilderImpl builder) {
        this.iamActionDefinition = builder.iamActionDefinition;
        this.scpActionDefinition = builder.scpActionDefinition;
        this.ssmActionDefinition = builder.ssmActionDefinition;
    }

    /**
     * <p>
     * The Identity and Access Management (IAM) action definition details.
     * </p>
     * 
     * @return The Identity and Access Management (IAM) action definition details.
     */
    public final IamActionDefinition iamActionDefinition() {
        return iamActionDefinition;
    }

    /**
     * <p>
     * The service control policies (SCPs) action definition details.
     * </p>
     * 
     * @return The service control policies (SCPs) action definition details.
     */
    public final ScpActionDefinition scpActionDefinition() {
        return scpActionDefinition;
    }

    /**
     * <p>
     * The Amazon Web Services Systems Manager (SSM) action definition details.
     * </p>
     * 
     * @return The Amazon Web Services Systems Manager (SSM) action definition details.
     */
    public final SsmActionDefinition ssmActionDefinition() {
        return ssmActionDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamActionDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(scpActionDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(ssmActionDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition other = (Definition) obj;
        return Objects.equals(iamActionDefinition(), other.iamActionDefinition())
                && Objects.equals(scpActionDefinition(), other.scpActionDefinition())
                && Objects.equals(ssmActionDefinition(), other.ssmActionDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Definition").add("IamActionDefinition", iamActionDefinition())
                .add("ScpActionDefinition", scpActionDefinition()).add("SsmActionDefinition", ssmActionDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamActionDefinition":
            return Optional.ofNullable(clazz.cast(iamActionDefinition()));
        case "ScpActionDefinition":
            return Optional.ofNullable(clazz.cast(scpActionDefinition()));
        case "SsmActionDefinition":
            return Optional.ofNullable(clazz.cast(ssmActionDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IamActionDefinition", IAM_ACTION_DEFINITION_FIELD);
        map.put("ScpActionDefinition", SCP_ACTION_DEFINITION_FIELD);
        map.put("SsmActionDefinition", SSM_ACTION_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Definition, T> g) {
        return obj -> g.apply((Definition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Definition> {
        /**
         * <p>
         * The Identity and Access Management (IAM) action definition details.
         * </p>
         * 
         * @param iamActionDefinition
         *        The Identity and Access Management (IAM) action definition details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamActionDefinition(IamActionDefinition iamActionDefinition);

        /**
         * <p>
         * The Identity and Access Management (IAM) action definition details.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamActionDefinition.Builder} avoiding the
         * need to create one manually via {@link IamActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamActionDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #iamActionDefinition(IamActionDefinition)}.
         * 
         * @param iamActionDefinition
         *        a consumer that will call methods on {@link IamActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamActionDefinition(IamActionDefinition)
         */
        default Builder iamActionDefinition(Consumer<IamActionDefinition.Builder> iamActionDefinition) {
            return iamActionDefinition(IamActionDefinition.builder().applyMutation(iamActionDefinition).build());
        }

        /**
         * <p>
         * The service control policies (SCPs) action definition details.
         * </p>
         * 
         * @param scpActionDefinition
         *        The service control policies (SCPs) action definition details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scpActionDefinition(ScpActionDefinition scpActionDefinition);

        /**
         * <p>
         * The service control policies (SCPs) action definition details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScpActionDefinition.Builder} avoiding the
         * need to create one manually via {@link ScpActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScpActionDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #scpActionDefinition(ScpActionDefinition)}.
         * 
         * @param scpActionDefinition
         *        a consumer that will call methods on {@link ScpActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scpActionDefinition(ScpActionDefinition)
         */
        default Builder scpActionDefinition(Consumer<ScpActionDefinition.Builder> scpActionDefinition) {
            return scpActionDefinition(ScpActionDefinition.builder().applyMutation(scpActionDefinition).build());
        }

        /**
         * <p>
         * The Amazon Web Services Systems Manager (SSM) action definition details.
         * </p>
         * 
         * @param ssmActionDefinition
         *        The Amazon Web Services Systems Manager (SSM) action definition details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmActionDefinition(SsmActionDefinition ssmActionDefinition);

        /**
         * <p>
         * The Amazon Web Services Systems Manager (SSM) action definition details.
         * </p>
         * This is a convenience method that creates an instance of the {@link SsmActionDefinition.Builder} avoiding the
         * need to create one manually via {@link SsmActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SsmActionDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #ssmActionDefinition(SsmActionDefinition)}.
         * 
         * @param ssmActionDefinition
         *        a consumer that will call methods on {@link SsmActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmActionDefinition(SsmActionDefinition)
         */
        default Builder ssmActionDefinition(Consumer<SsmActionDefinition.Builder> ssmActionDefinition) {
            return ssmActionDefinition(SsmActionDefinition.builder().applyMutation(ssmActionDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IamActionDefinition iamActionDefinition;

        private ScpActionDefinition scpActionDefinition;

        private SsmActionDefinition ssmActionDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(Definition model) {
            iamActionDefinition(model.iamActionDefinition);
            scpActionDefinition(model.scpActionDefinition);
            ssmActionDefinition(model.ssmActionDefinition);
        }

        public final IamActionDefinition.Builder getIamActionDefinition() {
            return iamActionDefinition != null ? iamActionDefinition.toBuilder() : null;
        }

        public final void setIamActionDefinition(IamActionDefinition.BuilderImpl iamActionDefinition) {
            this.iamActionDefinition = iamActionDefinition != null ? iamActionDefinition.build() : null;
        }

        @Override
        public final Builder iamActionDefinition(IamActionDefinition iamActionDefinition) {
            this.iamActionDefinition = iamActionDefinition;
            return this;
        }

        public final ScpActionDefinition.Builder getScpActionDefinition() {
            return scpActionDefinition != null ? scpActionDefinition.toBuilder() : null;
        }

        public final void setScpActionDefinition(ScpActionDefinition.BuilderImpl scpActionDefinition) {
            this.scpActionDefinition = scpActionDefinition != null ? scpActionDefinition.build() : null;
        }

        @Override
        public final Builder scpActionDefinition(ScpActionDefinition scpActionDefinition) {
            this.scpActionDefinition = scpActionDefinition;
            return this;
        }

        public final SsmActionDefinition.Builder getSsmActionDefinition() {
            return ssmActionDefinition != null ? ssmActionDefinition.toBuilder() : null;
        }

        public final void setSsmActionDefinition(SsmActionDefinition.BuilderImpl ssmActionDefinition) {
            this.ssmActionDefinition = ssmActionDefinition != null ? ssmActionDefinition.build() : null;
        }

        @Override
        public final Builder ssmActionDefinition(SsmActionDefinition ssmActionDefinition) {
            this.ssmActionDefinition = ssmActionDefinition;
            return this;
        }

        @Override
        public Definition build() {
            return new Definition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
