/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the current operational state of a billing view resource, including its ability to access
 * and update based on its associated billing view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthStatus implements SdkPojo, Serializable, ToCopyableBuilder<HealthStatus.Builder, HealthStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HealthStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(HealthStatus::statusReasonAsString)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(HealthStatus::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusReason;

    private final Instant lastUpdatedTime;

    private HealthStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The current status of the billing view resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HealthStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the billing view resource.
     * @see HealthStatusValue
     */
    public final HealthStatusValue status() {
        return HealthStatusValue.fromValue(status);
    }

    /**
     * <p>
     * The current status of the billing view resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HealthStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the billing view resource.
     * @see HealthStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
     * <code>billing:GetBillingViewData</code> permission to this account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year historical
     * data in your Cost Management preferences.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link HealthStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the current status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
     *         <code>billing:GetBillingViewData</code> permission to this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
     *         historical data in your Cost Management preferences.
     *         </p>
     *         </li>
     * @see HealthStatusReason
     */
    public final HealthStatusReason statusReason() {
        return HealthStatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * The reason for the current status.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
     * <code>billing:GetBillingViewData</code> permission to this account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year historical
     * data in your Cost Management preferences.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link HealthStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the current status.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
     *         <code>billing:GetBillingViewData</code> permission to this account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
     *         historical data in your Cost Management preferences.
     *         </p>
     *         </li>
     * @see HealthStatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * Returns the value of the LastUpdatedTime property for this object.
     * 
     * @return The value of the LastUpdatedTime property for this object.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthStatus)) {
            return false;
        }
        HealthStatus other = (HealthStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthStatus").add("Status", statusAsString()).add("StatusReason", statusReasonAsString())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthStatus, T> g) {
        return obj -> g.apply((HealthStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthStatus> {
        /**
         * <p>
         * The current status of the billing view resource.
         * </p>
         * 
         * @param status
         *        The current status of the billing view resource.
         * @see HealthStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the billing view resource.
         * </p>
         * 
         * @param status
         *        The current status of the billing view resource.
         * @see HealthStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusValue
         */
        Builder status(HealthStatusValue status);

        /**
         * <p>
         * The reason for the current status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
         * <code>billing:GetBillingViewData</code> permission to this account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
         * historical data in your Cost Management preferences.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        The reason for the current status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
         *        <code>billing:GetBillingViewData</code> permission to this account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
         *        historical data in your Cost Management preferences.
         *        </p>
         *        </li>
         * @see HealthStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The reason for the current status.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
         * <code>billing:GetBillingViewData</code> permission to this account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
         * historical data in your Cost Management preferences.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        The reason for the current status.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BILLING_VIEW_NO_ACCESS</code>: The billing view resource does not grant
         *        <code>billing:GetBillingViewData</code> permission to this account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BILLING_VIEW_UNHEALTHY</code>: The billing view associated with the budget is unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FILTER_INVALID</code>: The filter contains reference to an account you do not have access to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_YEAR_HISTORICAL_DATA_DISABLED</code>: The budget is not being updated. Enable multi-year
         *        historical data in your Cost Management preferences.
         *        </p>
         *        </li>
         * @see HealthStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusReason
         */
        Builder statusReason(HealthStatusReason statusReason);

        /**
         * Sets the value of the LastUpdatedTime property for this object.
         *
         * @param lastUpdatedTime
         *        The new value for the LastUpdatedTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthStatus model) {
            status(model.status);
            statusReason(model.statusReason);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HealthStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(HealthStatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public HealthStatus build() {
            return new HealthStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
