/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service control policies (SCP) action definition details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScpActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ScpActionDefinition.Builder, ScpActionDefinition> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(ScpActionDefinition::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<List<String>> TARGET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetIds")
            .getter(getter(ScpActionDefinition::targetIds))
            .setter(setter(Builder::targetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            TARGET_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyId;

    private final List<String> targetIds;

    private ScpActionDefinition(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.targetIds = builder.targetIds;
    }

    /**
     * <p>
     * The policy ID attached.
     * </p>
     * 
     * @return The policy ID attached.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetIds() {
        return targetIds != null && !(targetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of target IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetIds} method.
     * </p>
     * 
     * @return A list of target IDs.
     */
    public final List<String> targetIds() {
        return targetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetIds() ? targetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScpActionDefinition)) {
            return false;
        }
        ScpActionDefinition other = (ScpActionDefinition) obj;
        return Objects.equals(policyId(), other.policyId()) && hasTargetIds() == other.hasTargetIds()
                && Objects.equals(targetIds(), other.targetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScpActionDefinition").add("PolicyId", policyId())
                .add("TargetIds", hasTargetIds() ? targetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "TargetIds":
            return Optional.ofNullable(clazz.cast(targetIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("TargetIds", TARGET_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScpActionDefinition, T> g) {
        return obj -> g.apply((ScpActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScpActionDefinition> {
        /**
         * <p>
         * The policy ID attached.
         * </p>
         * 
         * @param policyId
         *        The policy ID attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * A list of target IDs.
         * </p>
         * 
         * @param targetIds
         *        A list of target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(Collection<String> targetIds);

        /**
         * <p>
         * A list of target IDs.
         * </p>
         * 
         * @param targetIds
         *        A list of target IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIds(String... targetIds);
    }

    static final class BuilderImpl implements Builder {
        private String policyId;

        private List<String> targetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScpActionDefinition model) {
            policyId(model.policyId);
            targetIds(model.targetIds);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final Collection<String> getTargetIds() {
            if (targetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return targetIds;
        }

        public final void setTargetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
        }

        @Override
        public final Builder targetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdsCopier.copy(targetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIds(String... targetIds) {
            targetIds(Arrays.asList(targetIds));
            return this;
        }

        @Override
        public ScpActionDefinition build() {
            return new ScpActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
