/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.budgets.model.BudgetType;
import software.amazon.awssdk.services.budgets.model.CalculatedSpend;
import software.amazon.awssdk.services.budgets.model.CostFiltersCopier;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.services.budgets.model.PlannedBudgetLimitsCopier;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.services.budgets.model.TimeUnit;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Budget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Budget> {
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Budget.getter(Budget::budgetName)).setter(Budget.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<Spend> BUDGET_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Budget.getter(Budget::budgetLimit)).setter(Budget.setter(Builder::budgetLimit)).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetLimit").build()}).build();
    private static final SdkField<Map<String, Spend>> PLANNED_BUDGET_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Budget.getter(Budget::plannedBudgetLimits)).setter(Budget.setter(Builder::plannedBudgetLimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlannedBudgetLimits").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Spend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> COST_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Budget.getter(Budget::costFilters)).setter(Budget.setter(Builder::costFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostFilters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<CostTypes> COST_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Budget.getter(Budget::costTypes)).setter(Budget.setter(Builder::costTypes)).constructor(CostTypes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostTypes").build()}).build();
    private static final SdkField<String> TIME_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Budget.getter(Budget::timeUnitAsString)).setter(Budget.setter(Builder::timeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeUnit").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Budget.getter(Budget::timePeriod)).setter(Budget.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<CalculatedSpend> CALCULATED_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Budget.getter(Budget::calculatedSpend)).setter(Budget.setter(Builder::calculatedSpend)).constructor(CalculatedSpend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedSpend").build()}).build();
    private static final SdkField<String> BUDGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Budget.getter(Budget::budgetTypeAsString)).setter(Budget.setter(Builder::budgetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Budget.getter(Budget::lastUpdatedTime)).setter(Budget.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_NAME_FIELD, BUDGET_LIMIT_FIELD, PLANNED_BUDGET_LIMITS_FIELD, COST_FILTERS_FIELD, COST_TYPES_FIELD, TIME_UNIT_FIELD, TIME_PERIOD_FIELD, CALCULATED_SPEND_FIELD, BUDGET_TYPE_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String budgetName;
    private final Spend budgetLimit;
    private final Map<String, Spend> plannedBudgetLimits;
    private final Map<String, List<String>> costFilters;
    private final CostTypes costTypes;
    private final String timeUnit;
    private final TimePeriod timePeriod;
    private final CalculatedSpend calculatedSpend;
    private final String budgetType;
    private final Instant lastUpdatedTime;

    private Budget(BuilderImpl builder) {
        this.budgetName = builder.budgetName;
        this.budgetLimit = builder.budgetLimit;
        this.plannedBudgetLimits = builder.plannedBudgetLimits;
        this.costFilters = builder.costFilters;
        this.costTypes = builder.costTypes;
        this.timeUnit = builder.timeUnit;
        this.timePeriod = builder.timePeriod;
        this.calculatedSpend = builder.calculatedSpend;
        this.budgetType = builder.budgetType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Spend budgetLimit() {
        return this.budgetLimit;
    }

    public Map<String, Spend> plannedBudgetLimits() {
        return this.plannedBudgetLimits;
    }

    public Map<String, List<String>> costFilters() {
        return this.costFilters;
    }

    public CostTypes costTypes() {
        return this.costTypes;
    }

    public TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public String timeUnitAsString() {
        return this.timeUnit;
    }

    public TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public CalculatedSpend calculatedSpend() {
        return this.calculatedSpend;
    }

    public BudgetType budgetType() {
        return BudgetType.fromValue(this.budgetType);
    }

    public String budgetTypeAsString() {
        return this.budgetType;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.plannedBudgetLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.costFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.costTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Budget)) {
            return false;
        }
        Budget other = (Budget)obj;
        return Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.budgetLimit(), other.budgetLimit()) && Objects.equals(this.plannedBudgetLimits(), other.plannedBudgetLimits()) && Objects.equals(this.costFilters(), other.costFilters()) && Objects.equals(this.costTypes(), other.costTypes()) && Objects.equals(this.timeUnitAsString(), other.timeUnitAsString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.calculatedSpend(), other.calculatedSpend()) && Objects.equals(this.budgetTypeAsString(), other.budgetTypeAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"Budget").add("BudgetName", (Object)this.budgetName()).add("BudgetLimit", (Object)this.budgetLimit()).add("PlannedBudgetLimits", this.plannedBudgetLimits()).add("CostFilters", this.costFilters()).add("CostTypes", (Object)this.costTypes()).add("TimeUnit", (Object)this.timeUnitAsString()).add("TimePeriod", (Object)this.timePeriod()).add("CalculatedSpend", (Object)this.calculatedSpend()).add("BudgetType", (Object)this.budgetTypeAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "BudgetLimit": {
                return Optional.ofNullable(clazz.cast(this.budgetLimit()));
            }
            case "PlannedBudgetLimits": {
                return Optional.ofNullable(clazz.cast(this.plannedBudgetLimits()));
            }
            case "CostFilters": {
                return Optional.ofNullable(clazz.cast(this.costFilters()));
            }
            case "CostTypes": {
                return Optional.ofNullable(clazz.cast(this.costTypes()));
            }
            case "TimeUnit": {
                return Optional.ofNullable(clazz.cast(this.timeUnitAsString()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "CalculatedSpend": {
                return Optional.ofNullable(clazz.cast(this.calculatedSpend()));
            }
            case "BudgetType": {
                return Optional.ofNullable(clazz.cast(this.budgetTypeAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Budget, T> g) {
        return obj -> g.apply((Budget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String budgetName;
        private Spend budgetLimit;
        private Map<String, Spend> plannedBudgetLimits = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> costFilters = DefaultSdkAutoConstructMap.getInstance();
        private CostTypes costTypes;
        private String timeUnit;
        private TimePeriod timePeriod;
        private CalculatedSpend calculatedSpend;
        private String budgetType;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Budget model) {
            this.budgetName(model.budgetName);
            this.budgetLimit(model.budgetLimit);
            this.plannedBudgetLimits(model.plannedBudgetLimits);
            this.costFilters(model.costFilters);
            this.costTypes(model.costTypes);
            this.timeUnit(model.timeUnit);
            this.timePeriod(model.timePeriod);
            this.calculatedSpend(model.calculatedSpend);
            this.budgetType(model.budgetType);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Spend.Builder getBudgetLimit() {
            return this.budgetLimit != null ? this.budgetLimit.toBuilder() : null;
        }

        @Override
        public final Builder budgetLimit(Spend budgetLimit) {
            this.budgetLimit = budgetLimit;
            return this;
        }

        public final void setBudgetLimit(Spend.BuilderImpl budgetLimit) {
            this.budgetLimit = budgetLimit != null ? budgetLimit.build() : null;
        }

        public final Map<String, Spend.Builder> getPlannedBudgetLimits() {
            return this.plannedBudgetLimits != null ? CollectionUtils.mapValues(this.plannedBudgetLimits, Spend::toBuilder) : null;
        }

        @Override
        public final Builder plannedBudgetLimits(Map<String, Spend> plannedBudgetLimits) {
            this.plannedBudgetLimits = PlannedBudgetLimitsCopier.copy(plannedBudgetLimits);
            return this;
        }

        public final void setPlannedBudgetLimits(Map<String, Spend.BuilderImpl> plannedBudgetLimits) {
            this.plannedBudgetLimits = PlannedBudgetLimitsCopier.copyFromBuilder(plannedBudgetLimits);
        }

        public final Map<String, ? extends Collection<String>> getCostFilters() {
            return this.costFilters;
        }

        @Override
        public final Builder costFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
            return this;
        }

        public final void setCostFilters(Map<String, ? extends Collection<String>> costFilters) {
            this.costFilters = CostFiltersCopier.copy(costFilters);
        }

        public final CostTypes.Builder getCostTypes() {
            return this.costTypes != null ? this.costTypes.toBuilder() : null;
        }

        @Override
        public final Builder costTypes(CostTypes costTypes) {
            this.costTypes = costTypes;
            return this;
        }

        public final void setCostTypes(CostTypes.BuilderImpl costTypes) {
            this.costTypes = costTypes != null ? costTypes.build() : null;
        }

        public final String getTimeUnitAsString() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final CalculatedSpend.Builder getCalculatedSpend() {
            return this.calculatedSpend != null ? this.calculatedSpend.toBuilder() : null;
        }

        @Override
        public final Builder calculatedSpend(CalculatedSpend calculatedSpend) {
            this.calculatedSpend = calculatedSpend;
            return this;
        }

        public final void setCalculatedSpend(CalculatedSpend.BuilderImpl calculatedSpend) {
            this.calculatedSpend = calculatedSpend != null ? calculatedSpend.build() : null;
        }

        public final String getBudgetTypeAsString() {
            return this.budgetType;
        }

        @Override
        public final Builder budgetType(String budgetType) {
            this.budgetType = budgetType;
            return this;
        }

        @Override
        public final Builder budgetType(BudgetType budgetType) {
            this.budgetType(budgetType.toString());
            return this;
        }

        public final void setBudgetType(String budgetType) {
            this.budgetType = budgetType;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public Budget build() {
            return new Budget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Budget> {
        public Builder budgetName(String var1);

        public Builder budgetLimit(Spend var1);

        default public Builder budgetLimit(Consumer<Spend.Builder> budgetLimit) {
            return this.budgetLimit((Spend)((Spend.Builder)Spend.builder().applyMutation(budgetLimit)).build());
        }

        public Builder plannedBudgetLimits(Map<String, Spend> var1);

        public Builder costFilters(Map<String, ? extends Collection<String>> var1);

        public Builder costTypes(CostTypes var1);

        default public Builder costTypes(Consumer<CostTypes.Builder> costTypes) {
            return this.costTypes((CostTypes)((CostTypes.Builder)CostTypes.builder().applyMutation(costTypes)).build());
        }

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }

        public Builder calculatedSpend(CalculatedSpend var1);

        default public Builder calculatedSpend(Consumer<CalculatedSpend.Builder> calculatedSpend) {
            return this.calculatedSpend((CalculatedSpend)((CalculatedSpend.Builder)CalculatedSpend.builder().applyMutation(calculatedSpend)).build());
        }

        public Builder budgetType(String var1);

        public Builder budgetType(BudgetType var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

