/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An AWS Chatbot configuration for Amazon Chime.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChimeWebhookConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChimeWebhookConfiguration.Builder, ChimeWebhookConfiguration> {
    private static final SdkField<String> WEBHOOK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebhookDescription").getter(getter(ChimeWebhookConfiguration::webhookDescription))
            .setter(setter(Builder::webhookDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookDescription").build())
            .build();

    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(ChimeWebhookConfiguration::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(ChimeWebhookConfiguration::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnsTopicArns")
            .getter(getter(ChimeWebhookConfiguration::snsTopicArns))
            .setter(setter(Builder::snsTopicArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(ChimeWebhookConfiguration::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(ChimeWebhookConfiguration::loggingLevel))
            .setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WEBHOOK_DESCRIPTION_FIELD, CHAT_CONFIGURATION_ARN_FIELD, IAM_ROLE_ARN_FIELD, SNS_TOPIC_ARNS_FIELD,
                    CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String webhookDescription;

    private final String chatConfigurationArn;

    private final String iamRoleArn;

    private final List<String> snsTopicArns;

    private final String configurationName;

    private final String loggingLevel;

    private ChimeWebhookConfiguration(BuilderImpl builder) {
        this.webhookDescription = builder.webhookDescription;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.snsTopicArns = builder.snsTopicArns;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
    }

    /**
     * Description of the webhook. Recommend using the convention `RoomName/WebhookName`. See Chime setup tutorial for
     * more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
     * 
     * @return Description of the webhook. Recommend using the convention `RoomName/WebhookName`. See Chime setup
     *         tutorial for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
     */
    public final String webhookDescription() {
        return webhookDescription;
    }

    /**
     * The ARN of the ChimeWebhookConfiguration.
     * 
     * @return The ARN of the ChimeWebhookConfiguration.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
     * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS Chatbot.
     * 
     * @return The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
     *         AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for
     *         AWS Chatbot.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnsTopicArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnsTopicArns() {
        return snsTopicArns != null && !(snsTopicArns instanceof SdkAutoConstructList);
    }

    /**
     * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnsTopicArns} method.
     * </p>
     * 
     * @return The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    public final List<String> snsTopicArns() {
        return snsTopicArns;
    }

    /**
     * The name of the configuration.
     * 
     * @return The name of the configuration.
     */
    public final String configurationName() {
        return configurationName;
    }

    /**
     * Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon
     * CloudWatch Logs.Logging levels include ERROR, INFO, or NONE.
     * 
     * @return Specifies the logging level for this configuration. This property affects the log entries pushed to
     *         Amazon CloudWatch Logs.Logging levels include ERROR, INFO, or NONE.
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(webhookDescription());
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnsTopicArns() ? snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChimeWebhookConfiguration)) {
            return false;
        }
        ChimeWebhookConfiguration other = (ChimeWebhookConfiguration) obj;
        return Objects.equals(webhookDescription(), other.webhookDescription())
                && Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && hasSnsTopicArns() == other.hasSnsTopicArns()
                && Objects.equals(snsTopicArns(), other.snsTopicArns())
                && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(loggingLevel(), other.loggingLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChimeWebhookConfiguration").add("WebhookDescription", webhookDescription())
                .add("ChatConfigurationArn", chatConfigurationArn()).add("IamRoleArn", iamRoleArn())
                .add("SnsTopicArns", hasSnsTopicArns() ? snsTopicArns() : null).add("ConfigurationName", configurationName())
                .add("LoggingLevel", loggingLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebhookDescription":
            return Optional.ofNullable(clazz.cast(webhookDescription()));
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "SnsTopicArns":
            return Optional.ofNullable(clazz.cast(snsTopicArns()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChimeWebhookConfiguration, T> g) {
        return obj -> g.apply((ChimeWebhookConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChimeWebhookConfiguration> {
        /**
         * Description of the webhook. Recommend using the convention `RoomName/WebhookName`. See Chime setup tutorial
         * for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
         * 
         * @param webhookDescription
         *        Description of the webhook. Recommend using the convention `RoomName/WebhookName`. See Chime setup
         *        tutorial for more details: https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookDescription(String webhookDescription);

        /**
         * The ARN of the ChimeWebhookConfiguration.
         * 
         * @param chatConfigurationArn
         *        The ARN of the ChimeWebhookConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
         * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS
         * Chatbot.
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
         *        AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies
         *        for AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(Collection<String> snsTopicArns);

        /**
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(String... snsTopicArns);

        /**
         * The name of the configuration.
         * 
         * @param configurationName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon
         * CloudWatch Logs.Logging levels include ERROR, INFO, or NONE.
         * 
         * @param loggingLevel
         *        Specifies the logging level for this configuration. This property affects the log entries pushed to
         *        Amazon CloudWatch Logs.Logging levels include ERROR, INFO, or NONE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);
    }

    static final class BuilderImpl implements Builder {
        private String webhookDescription;

        private String chatConfigurationArn;

        private String iamRoleArn;

        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();

        private String configurationName;

        private String loggingLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ChimeWebhookConfiguration model) {
            webhookDescription(model.webhookDescription);
            chatConfigurationArn(model.chatConfigurationArn);
            iamRoleArn(model.iamRoleArn);
            snsTopicArns(model.snsTopicArns);
            configurationName(model.configurationName);
            loggingLevel(model.loggingLevel);
        }

        public final String getWebhookDescription() {
            return webhookDescription;
        }

        public final void setWebhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
        }

        @Override
        public final Builder webhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
            return this;
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String... snsTopicArns) {
            snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @Override
        public ChimeWebhookConfiguration build() {
            return new ChimeWebhookConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
