/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Microsoft Teams team that has been authorized with AWS Chatbot.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTeam implements SdkPojo, Serializable, ToCopyableBuilder<ConfiguredTeam.Builder, ConfiguredTeam> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(ConfiguredTeam::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(ConfiguredTeam::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamName").getter(getter(ConfiguredTeam::teamName)).setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD,
            TEAM_ID_FIELD, TEAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tenantId;

    private final String teamId;

    private final String teamName;

    private ConfiguredTeam(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
    }

    /**
     * The ID of the Microsoft Teams tenant.
     * 
     * @return The ID of the Microsoft Teams tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
     * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from
     * the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator
     * Guide.
     * 
     * @return The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
     *         initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
     *         the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the
     *         AWS Chatbot Administrator Guide.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * The name of the Microsoft Teams Team.
     * 
     * @return The name of the Microsoft Teams Team.
     */
    public final String teamName() {
        return teamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTeam)) {
            return false;
        }
        ConfiguredTeam other = (ConfiguredTeam) obj;
        return Objects.equals(tenantId(), other.tenantId()) && Objects.equals(teamId(), other.teamId())
                && Objects.equals(teamName(), other.teamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTeam").add("TenantId", tenantId()).add("TeamId", teamId()).add("TeamName", teamName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "TeamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTeam, T> g) {
        return obj -> g.apply((ConfiguredTeam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTeam> {
        /**
         * The ID of the Microsoft Teams tenant.
         * 
         * @param tenantId
         *        The ID of the Microsoft Teams tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
         * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID
         * from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot
         * Administrator Guide.
         * 
         * @param teamId
         *        The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
         *        initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and
         *        paste the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft
         *        Teams in the AWS Chatbot Administrator Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * The name of the Microsoft Teams Team.
         * 
         * @param teamName
         *        The name of the Microsoft Teams Team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);
    }

    static final class BuilderImpl implements Builder {
        private String tenantId;

        private String teamId;

        private String teamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTeam model) {
            tenantId(model.tenantId);
            teamId(model.teamId);
            teamName(model.teamName);
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        @Override
        public ConfiguredTeam build() {
            return new ConfiguredTeam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
