/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountPreferencesResponse extends ChatbotResponse implements
        ToCopyableBuilder<GetAccountPreferencesResponse.Builder, GetAccountPreferencesResponse> {
    private static final SdkField<AccountPreferences> ACCOUNT_PREFERENCES_FIELD = SdkField
            .<AccountPreferences> builder(MarshallingType.SDK_POJO).memberName("AccountPreferences")
            .getter(getter(GetAccountPreferencesResponse::accountPreferences)).setter(setter(Builder::accountPreferences))
            .constructor(AccountPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountPreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_PREFERENCES_FIELD));

    private final AccountPreferences accountPreferences;

    private GetAccountPreferencesResponse(BuilderImpl builder) {
        super(builder);
        this.accountPreferences = builder.accountPreferences;
    }

    /**
     * Preferences which apply for AWS Chatbot usage in the calling AWS account.
     * 
     * @return Preferences which apply for AWS Chatbot usage in the calling AWS account.
     */
    public final AccountPreferences accountPreferences() {
        return accountPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountPreferencesResponse)) {
            return false;
        }
        GetAccountPreferencesResponse other = (GetAccountPreferencesResponse) obj;
        return Objects.equals(accountPreferences(), other.accountPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountPreferencesResponse").add("AccountPreferences", accountPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountPreferences":
            return Optional.ofNullable(clazz.cast(accountPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountPreferencesResponse, T> g) {
        return obj -> g.apply((GetAccountPreferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountPreferencesResponse> {
        /**
         * Preferences which apply for AWS Chatbot usage in the calling AWS account.
         * 
         * @param accountPreferences
         *        Preferences which apply for AWS Chatbot usage in the calling AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPreferences(AccountPreferences accountPreferences);

        /**
         * Preferences which apply for AWS Chatbot usage in the calling AWS account. This is a convenience method that
         * creates an instance of the {@link AccountPreferences.Builder} avoiding the need to create one manually via
         * {@link AccountPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountPreferences.Builder#build()} is called immediately and its
         * result is passed to {@link #accountPreferences(AccountPreferences)}.
         * 
         * @param accountPreferences
         *        a consumer that will call methods on {@link AccountPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountPreferences(AccountPreferences)
         */
        default Builder accountPreferences(Consumer<AccountPreferences.Builder> accountPreferences) {
            return accountPreferences(AccountPreferences.builder().applyMutation(accountPreferences).build());
        }
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private AccountPreferences accountPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountPreferencesResponse model) {
            super(model);
            accountPreferences(model.accountPreferences);
        }

        public final AccountPreferences.Builder getAccountPreferences() {
            return accountPreferences != null ? accountPreferences.toBuilder() : null;
        }

        public final void setAccountPreferences(AccountPreferences.BuilderImpl accountPreferences) {
            this.accountPreferences = accountPreferences != null ? accountPreferences.build() : null;
        }

        @Override
        public final Builder accountPreferences(AccountPreferences accountPreferences) {
            this.accountPreferences = accountPreferences;
            return this;
        }

        @Override
        public GetAccountPreferencesResponse build() {
            return new GetAccountPreferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
