/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;

public class DescribeSlackWorkspacesIterable
implements SdkIterable<DescribeSlackWorkspacesResponse> {
    private final ChatbotClient client;
    private final DescribeSlackWorkspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSlackWorkspacesIterable(ChatbotClient client, DescribeSlackWorkspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSlackWorkspacesResponseFetcher();
    }

    public Iterator<DescribeSlackWorkspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeSlackWorkspacesResponseFetcher
    implements SyncPageFetcher<DescribeSlackWorkspacesResponse> {
        private DescribeSlackWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSlackWorkspacesResponse nextPage(DescribeSlackWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackWorkspacesIterable.this.client.describeSlackWorkspaces(DescribeSlackWorkspacesIterable.this.firstRequest);
            }
            return DescribeSlackWorkspacesIterable.this.client.describeSlackWorkspaces((DescribeSlackWorkspacesRequest)((Object)DescribeSlackWorkspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

