/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSlackWorkspacesResponse extends ChatbotResponse implements
        ToCopyableBuilder<DescribeSlackWorkspacesResponse.Builder, DescribeSlackWorkspacesResponse> {
    private static final SdkField<List<SlackWorkspace>> SLACK_WORKSPACES_FIELD = SdkField
            .<List<SlackWorkspace>> builder(MarshallingType.LIST)
            .memberName("SlackWorkspaces")
            .getter(getter(DescribeSlackWorkspacesResponse::slackWorkspaces))
            .setter(setter(Builder::slackWorkspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackWorkspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlackWorkspace> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlackWorkspace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSlackWorkspacesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_WORKSPACES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SlackWorkspace> slackWorkspaces;

    private final String nextToken;

    private DescribeSlackWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.slackWorkspaces = builder.slackWorkspaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlackWorkspaces property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSlackWorkspaces() {
        return slackWorkspaces != null && !(slackWorkspaces instanceof SdkAutoConstructList);
    }

    /**
     * A list of Slack Workspaces registered with AWS Chatbot.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlackWorkspaces} method.
     * </p>
     * 
     * @return A list of Slack Workspaces registered with AWS Chatbot.
     */
    public final List<SlackWorkspace> slackWorkspaces() {
        return slackWorkspaces;
    }

    /**
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSlackWorkspaces() ? slackWorkspaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSlackWorkspacesResponse)) {
            return false;
        }
        DescribeSlackWorkspacesResponse other = (DescribeSlackWorkspacesResponse) obj;
        return hasSlackWorkspaces() == other.hasSlackWorkspaces() && Objects.equals(slackWorkspaces(), other.slackWorkspaces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSlackWorkspacesResponse")
                .add("SlackWorkspaces", hasSlackWorkspaces() ? slackWorkspaces() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlackWorkspaces":
            return Optional.ofNullable(clazz.cast(slackWorkspaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSlackWorkspacesResponse, T> g) {
        return obj -> g.apply((DescribeSlackWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSlackWorkspacesResponse> {
        /**
         * A list of Slack Workspaces registered with AWS Chatbot.
         * 
         * @param slackWorkspaces
         *        A list of Slack Workspaces registered with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackWorkspaces(Collection<SlackWorkspace> slackWorkspaces);

        /**
         * A list of Slack Workspaces registered with AWS Chatbot.
         * 
         * @param slackWorkspaces
         *        A list of Slack Workspaces registered with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackWorkspaces(SlackWorkspace... slackWorkspaces);

        /**
         * A list of Slack Workspaces registered with AWS Chatbot. This is a convenience method that creates an instance
         * of the {@link software.amazon.awssdk.services.chatbot.model.SlackWorkspace.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.chatbot.model.SlackWorkspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.SlackWorkspace.Builder#build()} is called immediately
         * and its result is passed to {@link #slackWorkspaces(List<SlackWorkspace>)}.
         * 
         * @param slackWorkspaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.SlackWorkspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slackWorkspaces(java.util.Collection<SlackWorkspace>)
         */
        Builder slackWorkspaces(Consumer<SlackWorkspace.Builder>... slackWorkspaces);

        /**
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private List<SlackWorkspace> slackWorkspaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSlackWorkspacesResponse model) {
            super(model);
            slackWorkspaces(model.slackWorkspaces);
            nextToken(model.nextToken);
        }

        public final List<SlackWorkspace.Builder> getSlackWorkspaces() {
            List<SlackWorkspace.Builder> result = SlackWorkspacesListCopier.copyToBuilder(this.slackWorkspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackWorkspaces(Collection<SlackWorkspace.BuilderImpl> slackWorkspaces) {
            this.slackWorkspaces = SlackWorkspacesListCopier.copyFromBuilder(slackWorkspaces);
        }

        @Override
        public final Builder slackWorkspaces(Collection<SlackWorkspace> slackWorkspaces) {
            this.slackWorkspaces = SlackWorkspacesListCopier.copy(slackWorkspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaces(SlackWorkspace... slackWorkspaces) {
            slackWorkspaces(Arrays.asList(slackWorkspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaces(Consumer<SlackWorkspace.Builder>... slackWorkspaces) {
            slackWorkspaces(Stream.of(slackWorkspaces).map(c -> SlackWorkspace.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSlackWorkspacesResponse build() {
            return new DescribeSlackWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
