/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Preferences which apply for AWS Chatbot usage in the calling AWS account.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountPreferences.Builder, AccountPreferences> {
    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired")
            .getter(getter(AccountPreferences::userAuthorizationRequired)).setter(setter(Builder::userAuthorizationRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build())
            .build();

    private static final SdkField<Boolean> TRAINING_DATA_COLLECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrainingDataCollectionEnabled")
            .getter(getter(AccountPreferences::trainingDataCollectionEnabled))
            .setter(setter(Builder::trainingDataCollectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataCollectionEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            USER_AUTHORIZATION_REQUIRED_FIELD, TRAINING_DATA_COLLECTION_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean userAuthorizationRequired;

    private final Boolean trainingDataCollectionEnabled;

    private AccountPreferences(BuilderImpl builder) {
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
        this.trainingDataCollectionEnabled = builder.trainingDataCollectionEnabled;
    }

    /**
     * Enables use of a user role requirement in your chat configuration.
     * 
     * @return Enables use of a user role requirement in your chat configuration.
     */
    public final Boolean userAuthorizationRequired() {
        return userAuthorizationRequired;
    }

    /**
     * Turns on training data collection. This helps improve the AWS Chatbot experience by allowing AWS Chatbot to store
     * and use your customer information, such as AWS Chatbot configurations, notifications, user inputs, AWS Chatbot
     * generated responses, and interaction data. This data helps us to continuously improve and develop Artificial
     * Intelligence (AI) technologies. Your data is not shared with any third parties and is protected using
     * sophisticated controls to prevent unauthorized access and misuse. AWS Chatbot does not store or use interactions
     * in chat channels with Amazon Q for training AWS Chatbot’s AI technologies.
     * 
     * @return Turns on training data collection. This helps improve the AWS Chatbot experience by allowing AWS Chatbot
     *         to store and use your customer information, such as AWS Chatbot configurations, notifications, user
     *         inputs, AWS Chatbot generated responses, and interaction data. This data helps us to continuously improve
     *         and develop Artificial Intelligence (AI) technologies. Your data is not shared with any third parties and
     *         is protected using sophisticated controls to prevent unauthorized access and misuse. AWS Chatbot does not
     *         store or use interactions in chat channels with Amazon Q for training AWS Chatbot’s AI technologies.
     */
    public final Boolean trainingDataCollectionEnabled() {
        return trainingDataCollectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAuthorizationRequired());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataCollectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPreferences)) {
            return false;
        }
        AccountPreferences other = (AccountPreferences) obj;
        return Objects.equals(userAuthorizationRequired(), other.userAuthorizationRequired())
                && Objects.equals(trainingDataCollectionEnabled(), other.trainingDataCollectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountPreferences").add("UserAuthorizationRequired", userAuthorizationRequired())
                .add("TrainingDataCollectionEnabled", trainingDataCollectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserAuthorizationRequired":
            return Optional.ofNullable(clazz.cast(userAuthorizationRequired()));
        case "TrainingDataCollectionEnabled":
            return Optional.ofNullable(clazz.cast(trainingDataCollectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountPreferences, T> g) {
        return obj -> g.apply((AccountPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountPreferences> {
        /**
         * Enables use of a user role requirement in your chat configuration.
         * 
         * @param userAuthorizationRequired
         *        Enables use of a user role requirement in your chat configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAuthorizationRequired(Boolean userAuthorizationRequired);

        /**
         * Turns on training data collection. This helps improve the AWS Chatbot experience by allowing AWS Chatbot to
         * store and use your customer information, such as AWS Chatbot configurations, notifications, user inputs, AWS
         * Chatbot generated responses, and interaction data. This data helps us to continuously improve and develop
         * Artificial Intelligence (AI) technologies. Your data is not shared with any third parties and is protected
         * using sophisticated controls to prevent unauthorized access and misuse. AWS Chatbot does not store or use
         * interactions in chat channels with Amazon Q for training AWS Chatbot’s AI technologies.
         * 
         * @param trainingDataCollectionEnabled
         *        Turns on training data collection. This helps improve the AWS Chatbot experience by allowing AWS
         *        Chatbot to store and use your customer information, such as AWS Chatbot configurations, notifications,
         *        user inputs, AWS Chatbot generated responses, and interaction data. This data helps us to continuously
         *        improve and develop Artificial Intelligence (AI) technologies. Your data is not shared with any third
         *        parties and is protected using sophisticated controls to prevent unauthorized access and misuse. AWS
         *        Chatbot does not store or use interactions in chat channels with Amazon Q for training AWS Chatbot’s
         *        AI technologies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataCollectionEnabled(Boolean trainingDataCollectionEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean userAuthorizationRequired;

        private Boolean trainingDataCollectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountPreferences model) {
            userAuthorizationRequired(model.userAuthorizationRequired);
            trainingDataCollectionEnabled(model.trainingDataCollectionEnabled);
        }

        public final Boolean getUserAuthorizationRequired() {
            return userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        public final Boolean getTrainingDataCollectionEnabled() {
            return trainingDataCollectionEnabled;
        }

        public final void setTrainingDataCollectionEnabled(Boolean trainingDataCollectionEnabled) {
            this.trainingDataCollectionEnabled = trainingDataCollectionEnabled;
        }

        @Override
        public final Builder trainingDataCollectionEnabled(Boolean trainingDataCollectionEnabled) {
            this.trainingDataCollectionEnabled = trainingDataCollectionEnabled;
            return this;
        }

        @Override
        public AccountPreferences build() {
            return new AccountPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
