/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSlackUserIdentityRequest extends ChatbotRequest implements
        ToCopyableBuilder<DeleteSlackUserIdentityRequest.Builder, DeleteSlackUserIdentityRequest> {
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(DeleteSlackUserIdentityRequest::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> SLACK_TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamId").getter(getter(DeleteSlackUserIdentityRequest::slackTeamId))
            .setter(setter(Builder::slackTeamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamId").build()).build();

    private static final SdkField<String> SLACK_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackUserId").getter(getter(DeleteSlackUserIdentityRequest::slackUserId))
            .setter(setter(Builder::slackUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackUserId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONFIGURATION_ARN_FIELD,
            SLACK_TEAM_ID_FIELD, SLACK_USER_ID_FIELD));

    private final String chatConfigurationArn;

    private final String slackTeamId;

    private final String slackUserId;

    private DeleteSlackUserIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.slackTeamId = builder.slackTeamId;
        this.slackUserId = builder.slackUserId;
    }

    /**
     * The ARN of the SlackChannelConfiguration associated with the user identity to delete.
     * 
     * @return The ARN of the SlackChannelConfiguration associated with the user identity to delete.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * The ID of the Slack workspace authorized with AWS Chatbot.
     * 
     * @return The ID of the Slack workspace authorized with AWS Chatbot.
     */
    public final String slackTeamId() {
        return slackTeamId;
    }

    /**
     * The ID of the user in Slack.
     * 
     * @return The ID of the user in Slack.
     */
    public final String slackUserId() {
        return slackUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamId());
        hashCode = 31 * hashCode + Objects.hashCode(slackUserId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSlackUserIdentityRequest)) {
            return false;
        }
        DeleteSlackUserIdentityRequest other = (DeleteSlackUserIdentityRequest) obj;
        return Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(slackTeamId(), other.slackTeamId()) && Objects.equals(slackUserId(), other.slackUserId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSlackUserIdentityRequest").add("ChatConfigurationArn", chatConfigurationArn())
                .add("SlackTeamId", slackTeamId()).add("SlackUserId", slackUserId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "SlackTeamId":
            return Optional.ofNullable(clazz.cast(slackTeamId()));
        case "SlackUserId":
            return Optional.ofNullable(clazz.cast(slackUserId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSlackUserIdentityRequest, T> g) {
        return obj -> g.apply((DeleteSlackUserIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSlackUserIdentityRequest> {
        /**
         * The ARN of the SlackChannelConfiguration associated with the user identity to delete.
         * 
         * @param chatConfigurationArn
         *        The ARN of the SlackChannelConfiguration associated with the user identity to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * The ID of the Slack workspace authorized with AWS Chatbot.
         * 
         * @param slackTeamId
         *        The ID of the Slack workspace authorized with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamId(String slackTeamId);

        /**
         * The ID of the user in Slack.
         * 
         * @param slackUserId
         *        The ID of the user in Slack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackUserId(String slackUserId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChatbotRequest.BuilderImpl implements Builder {
        private String chatConfigurationArn;

        private String slackTeamId;

        private String slackUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSlackUserIdentityRequest model) {
            super(model);
            chatConfigurationArn(model.chatConfigurationArn);
            slackTeamId(model.slackTeamId);
            slackUserId(model.slackUserId);
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getSlackTeamId() {
            return slackTeamId;
        }

        public final void setSlackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
        }

        @Override
        public final Builder slackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
            return this;
        }

        public final String getSlackUserId() {
            return slackUserId;
        }

        public final void setSlackUserId(String slackUserId) {
            this.slackUserId = slackUserId;
        }

        @Override
        public final Builder slackUserId(String slackUserId) {
            this.slackUserId = slackUserId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSlackUserIdentityRequest build() {
            return new DeleteSlackUserIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
