/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.chatbot.model.ChatbotException;
import software.amazon.awssdk.services.chatbot.model.ConflictException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsConfiguredTeamException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.GetTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.InternalServiceErrorException;
import software.amazon.awssdk.services.chatbot.model.InvalidParameterException;
import software.amazon.awssdk.services.chatbot.model.InvalidRequestException;
import software.amazon.awssdk.services.chatbot.model.LimitExceededException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chatbot.model.ListTeamsChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.chatbot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chatbot.model.TagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.TagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.TooManyTagsException;
import software.amazon.awssdk.services.chatbot.model.UntagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.UntagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable;

/**
 * Service client for accessing AWS Chatbot. This can be created using the static {@link #builder()} method.
 *
 * AWS Chatbot API
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ChatbotClient extends AwsClient {
    String SERVICE_NAME = "chatbot";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "chatbot";

    /**
     * Creates Chime Webhook Configuration
     *
     * @param createChimeWebhookConfigurationRequest
     * @return Result of the CreateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChimeWebhookConfigurationResponse createChimeWebhookConfiguration(
            CreateChimeWebhookConfigurationRequest createChimeWebhookConfigurationRequest) throws InvalidParameterException,
            LimitExceededException, InvalidRequestException, CreateChimeWebhookConfigurationException, ConflictException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates Chime Webhook Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChimeWebhookConfigurationResponse createChimeWebhookConfiguration(
            Consumer<CreateChimeWebhookConfigurationRequest.Builder> createChimeWebhookConfigurationRequest)
            throws InvalidParameterException, LimitExceededException, InvalidRequestException,
            CreateChimeWebhookConfigurationException, ConflictException, AwsServiceException, SdkClientException,
            ChatbotException {
        return createChimeWebhookConfiguration(CreateChimeWebhookConfigurationRequest.builder()
                .applyMutation(createChimeWebhookConfigurationRequest).build());
    }

    /**
     * Creates MS Teams Channel Configuration
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the CreateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMicrosoftTeamsChannelConfigurationResponse createMicrosoftTeamsChannelConfiguration(
            CreateMicrosoftTeamsChannelConfigurationRequest createMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, LimitExceededException, InvalidRequestException,
            CreateTeamsChannelConfigurationException, ConflictException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates MS Teams Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMicrosoftTeamsChannelConfigurationResponse createMicrosoftTeamsChannelConfiguration(
            Consumer<CreateMicrosoftTeamsChannelConfigurationRequest.Builder> createMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, LimitExceededException, InvalidRequestException,
            CreateTeamsChannelConfigurationException, ConflictException, AwsServiceException, SdkClientException,
            ChatbotException {
        return createMicrosoftTeamsChannelConfiguration(CreateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(createMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * Creates Slack Channel Configuration
     *
     * @param createSlackChannelConfigurationRequest
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) throws InvalidParameterException,
            LimitExceededException, InvalidRequestException, CreateSlackChannelConfigurationException, ConflictException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates Slack Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws CreateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            Consumer<CreateSlackChannelConfigurationRequest.Builder> createSlackChannelConfigurationRequest)
            throws InvalidParameterException, LimitExceededException, InvalidRequestException,
            CreateSlackChannelConfigurationException, ConflictException, AwsServiceException, SdkClientException,
            ChatbotException {
        return createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.builder()
                .applyMutation(createSlackChannelConfigurationRequest).build());
    }

    /**
     * Deletes a Chime Webhook Configuration
     *
     * @param deleteChimeWebhookConfigurationRequest
     * @return Result of the DeleteChimeWebhookConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChimeWebhookConfigurationResponse deleteChimeWebhookConfiguration(
            DeleteChimeWebhookConfigurationRequest deleteChimeWebhookConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, DeleteChimeWebhookConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a Chime Webhook Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteChimeWebhookConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChimeWebhookConfigurationResponse deleteChimeWebhookConfiguration(
            Consumer<DeleteChimeWebhookConfigurationRequest.Builder> deleteChimeWebhookConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            DeleteChimeWebhookConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteChimeWebhookConfiguration(DeleteChimeWebhookConfigurationRequest.builder()
                .applyMutation(deleteChimeWebhookConfigurationRequest).build());
    }

    /**
     * Deletes MS Teams Channel Configuration
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsChannelConfigurationResponse deleteMicrosoftTeamsChannelConfiguration(
            DeleteMicrosoftTeamsChannelConfigurationRequest deleteMicrosoftTeamsChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            DeleteTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes MS Teams Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsChannelConfigurationResponse deleteMicrosoftTeamsChannelConfiguration(
            Consumer<DeleteMicrosoftTeamsChannelConfigurationRequest.Builder> deleteMicrosoftTeamsChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            DeleteTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteMicrosoftTeamsChannelConfiguration(DeleteMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(deleteMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     * @return Result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteTeamsConfiguredTeamException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsConfiguredTeamResponse deleteMicrosoftTeamsConfiguredTeam(
            DeleteMicrosoftTeamsConfiguredTeamRequest deleteMicrosoftTeamsConfiguredTeamRequest)
            throws InvalidParameterException, DeleteTeamsConfiguredTeamException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsConfiguredTeamRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsConfiguredTeamRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteTeamsConfiguredTeamException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsConfiguredTeamResponse deleteMicrosoftTeamsConfiguredTeam(
            Consumer<DeleteMicrosoftTeamsConfiguredTeamRequest.Builder> deleteMicrosoftTeamsConfiguredTeamRequest)
            throws InvalidParameterException, DeleteTeamsConfiguredTeamException, AwsServiceException, SdkClientException,
            ChatbotException {
        return deleteMicrosoftTeamsConfiguredTeam(DeleteMicrosoftTeamsConfiguredTeamRequest.builder()
                .applyMutation(deleteMicrosoftTeamsConfiguredTeamRequest).build());
    }

    /**
     * Deletes a Teams user identity
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     * @return Result of the DeleteMicrosoftTeamsUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws DeleteMicrosoftTeamsUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsUserIdentityResponse deleteMicrosoftTeamsUserIdentity(
            DeleteMicrosoftTeamsUserIdentityRequest deleteMicrosoftTeamsUserIdentityRequest) throws InvalidParameterException,
            ResourceNotFoundException, DeleteMicrosoftTeamsUserIdentityException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a Teams user identity<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsUserIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMicrosoftTeamsUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws DeleteMicrosoftTeamsUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsUserIdentityResponse deleteMicrosoftTeamsUserIdentity(
            Consumer<DeleteMicrosoftTeamsUserIdentityRequest.Builder> deleteMicrosoftTeamsUserIdentityRequest)
            throws InvalidParameterException, ResourceNotFoundException, DeleteMicrosoftTeamsUserIdentityException,
            AwsServiceException, SdkClientException, ChatbotException {
        return deleteMicrosoftTeamsUserIdentity(DeleteMicrosoftTeamsUserIdentityRequest.builder()
                .applyMutation(deleteMicrosoftTeamsUserIdentityRequest).build());
    }

    /**
     * Deletes Slack Channel Configuration
     *
     * @param deleteSlackChannelConfigurationRequest
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, DeleteSlackChannelConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes Slack Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            Consumer<DeleteSlackChannelConfigurationRequest.Builder> deleteSlackChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            DeleteSlackChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.builder()
                .applyMutation(deleteSlackChannelConfigurationRequest).build());
    }

    /**
     * Deletes a Slack user identity
     *
     * @param deleteSlackUserIdentityRequest
     * @return Result of the DeleteSlackUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws DeleteSlackUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackUserIdentityResponse deleteSlackUserIdentity(DeleteSlackUserIdentityRequest deleteSlackUserIdentityRequest)
            throws InvalidParameterException, ResourceNotFoundException, DeleteSlackUserIdentityException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes a Slack user identity<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackUserIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSlackUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSlackUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws DeleteSlackUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackUserIdentityResponse deleteSlackUserIdentity(
            Consumer<DeleteSlackUserIdentityRequest.Builder> deleteSlackUserIdentityRequest) throws InvalidParameterException,
            ResourceNotFoundException, DeleteSlackUserIdentityException, AwsServiceException, SdkClientException,
            ChatbotException {
        return deleteSlackUserIdentity(DeleteSlackUserIdentityRequest.builder().applyMutation(deleteSlackUserIdentityRequest)
                .build());
    }

    /**
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     * @return Result of the DeleteSlackWorkspaceAuthorization operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteSlackWorkspaceAuthorizationException
     *         There was an issue deleting your Slack workspace.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceAuthorizationResponse deleteSlackWorkspaceAuthorization(
            DeleteSlackWorkspaceAuthorizationRequest deleteSlackWorkspaceAuthorizationRequest) throws InvalidParameterException,
            DeleteSlackWorkspaceAuthorizationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackWorkspaceAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackWorkspaceAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSlackWorkspaceAuthorization operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DeleteSlackWorkspaceAuthorizationException
     *         There was an issue deleting your Slack workspace.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceAuthorizationResponse deleteSlackWorkspaceAuthorization(
            Consumer<DeleteSlackWorkspaceAuthorizationRequest.Builder> deleteSlackWorkspaceAuthorizationRequest)
            throws InvalidParameterException, DeleteSlackWorkspaceAuthorizationException, AwsServiceException,
            SdkClientException, ChatbotException {
        return deleteSlackWorkspaceAuthorization(DeleteSlackWorkspaceAuthorizationRequest.builder()
                .applyMutation(deleteSlackWorkspaceAuthorizationRequest).build());
    }

    /**
     * Lists Chime Webhook Configurations optionally filtered by ChatConfigurationArn
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return Result of the DescribeChimeWebhookConfigurations operation returned by the service.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsResponse describeChimeWebhookConfigurations(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest)
            throws DescribeChimeWebhookConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists Chime Webhook Configurations optionally filtered by ChatConfigurationArn<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeChimeWebhookConfigurations operation returned by the service.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsResponse describeChimeWebhookConfigurations(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest)
            throws DescribeChimeWebhookConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeChimeWebhookConfigurations(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client
     *             .describeChimeWebhookConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsIterable describeChimeWebhookConfigurationsPaginator(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest)
            throws DescribeChimeWebhookConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeChimeWebhookConfigurationsIterable(this, describeChimeWebhookConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client
     *             .describeChimeWebhookConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsIterable describeChimeWebhookConfigurationsPaginator(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest)
            throws DescribeChimeWebhookConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeChimeWebhookConfigurationsPaginator(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * Lists Slack Channel Configurations optionally filtered by ChatConfigurationArn
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return Result of the DescribeSlackChannelConfigurations operation returned by the service.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsResponse describeSlackChannelConfigurations(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest)
            throws DescribeSlackChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists Slack Channel Configurations optionally filtered by ChatConfigurationArn<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSlackChannelConfigurations operation returned by the service.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsResponse describeSlackChannelConfigurations(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest)
            throws DescribeSlackChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackChannelConfigurations(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client
     *             .describeSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsIterable describeSlackChannelConfigurationsPaginator(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest)
            throws DescribeSlackChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeSlackChannelConfigurationsIterable(this, describeSlackChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client
     *             .describeSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsIterable describeSlackChannelConfigurationsPaginator(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest)
            throws DescribeSlackChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackChannelConfigurationsPaginator(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * Lists all Slack user identities with a mapped role.
     *
     * @param describeSlackUserIdentitiesRequest
     * @return Result of the DescribeSlackUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesResponse describeSlackUserIdentities(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists all Slack user identities with a mapped role.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeSlackUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesResponse describeSlackUserIdentities(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackUserIdentities(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client
     *             .describeSlackUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesIterable describeSlackUserIdentitiesPaginator(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        return new DescribeSlackUserIdentitiesIterable(this, describeSlackUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client
     *             .describeSlackUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesIterable describeSlackUserIdentitiesPaginator(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackUserIdentitiesPaginator(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * Lists all authorized Slack Workspaces for AWS Account
     *
     * @param describeSlackWorkspacesRequest
     * @return Result of the DescribeSlackWorkspaces operation returned by the service.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesResponse describeSlackWorkspaces(DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest)
            throws DescribeSlackWorkspacesException, InvalidRequestException, InvalidParameterException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists all authorized Slack Workspaces for AWS Account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSlackWorkspaces operation returned by the service.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesResponse describeSlackWorkspaces(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest)
            throws DescribeSlackWorkspacesException, InvalidRequestException, InvalidParameterException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackWorkspaces(DescribeSlackWorkspacesRequest.builder().applyMutation(describeSlackWorkspacesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client
     *             .describeSlackWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesIterable describeSlackWorkspacesPaginator(
            DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest) throws DescribeSlackWorkspacesException,
            InvalidRequestException, InvalidParameterException, AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeSlackWorkspacesIterable(this, describeSlackWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client
     *             .describeSlackWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesIterable describeSlackWorkspacesPaginator(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest)
            throws DescribeSlackWorkspacesException, InvalidRequestException, InvalidParameterException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackWorkspacesPaginator(DescribeSlackWorkspacesRequest.builder()
                .applyMutation(describeSlackWorkspacesRequest).build());
    }

    /**
     * Get Chatbot account level preferences
     *
     * @param getAccountPreferencesRequest
     * @return Result of the GetAccountPreferences operation returned by the service.
     * @throws GetAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPreferencesResponse getAccountPreferences(GetAccountPreferencesRequest getAccountPreferencesRequest)
            throws GetAccountPreferencesException, InvalidRequestException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get Chatbot account level preferences<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPreferencesRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param getAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountPreferences operation returned by the service.
     * @throws GetAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPreferencesResponse getAccountPreferences(
            Consumer<GetAccountPreferencesRequest.Builder> getAccountPreferencesRequest) throws GetAccountPreferencesException,
            InvalidRequestException, AwsServiceException, SdkClientException, ChatbotException {
        return getAccountPreferences(GetAccountPreferencesRequest.builder().applyMutation(getAccountPreferencesRequest).build());
    }

    /**
     * Get a single MS Teams Channel Configurations
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the GetMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws GetTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMicrosoftTeamsChannelConfigurationResponse getMicrosoftTeamsChannelConfiguration(
            GetMicrosoftTeamsChannelConfigurationRequest getMicrosoftTeamsChannelConfigurationRequest)
            throws GetTeamsChannelConfigurationException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a single MS Teams Channel Configurations<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws GetTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMicrosoftTeamsChannelConfigurationResponse getMicrosoftTeamsChannelConfiguration(
            Consumer<GetMicrosoftTeamsChannelConfigurationRequest.Builder> getMicrosoftTeamsChannelConfigurationRequest)
            throws GetTeamsChannelConfigurationException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return getMicrosoftTeamsChannelConfiguration(GetMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(getMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * Lists MS Teams Channel Configurations optionally filtered by TeamId
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return Result of the ListMicrosoftTeamsChannelConfigurations operation returned by the service.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsResponse listMicrosoftTeamsChannelConfigurations(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest)
            throws ListTeamsChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists MS Teams Channel Configurations optionally filtered by TeamId<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListMicrosoftTeamsChannelConfigurations operation returned by the service.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsResponse listMicrosoftTeamsChannelConfigurations(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest)
            throws ListTeamsChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsChannelConfigurations(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client
     *             .listMicrosoftTeamsChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsIterable listMicrosoftTeamsChannelConfigurationsPaginator(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest)
            throws ListTeamsChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new ListMicrosoftTeamsChannelConfigurationsIterable(this, listMicrosoftTeamsChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client
     *             .listMicrosoftTeamsChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsIterable listMicrosoftTeamsChannelConfigurationsPaginator(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest)
            throws ListTeamsChannelConfigurationsException, InvalidParameterException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsChannelConfigurationsPaginator(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * Lists all authorized MS teams for AWS Account
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return Result of the ListMicrosoftTeamsConfiguredTeams operation returned by the service.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsResponse listMicrosoftTeamsConfiguredTeams(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest)
            throws ListMicrosoftTeamsConfiguredTeamsException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists all authorized MS teams for AWS Account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return Result of the ListMicrosoftTeamsConfiguredTeams operation returned by the service.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsResponse listMicrosoftTeamsConfiguredTeams(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest)
            throws ListMicrosoftTeamsConfiguredTeamsException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsConfiguredTeams(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client
     *             .listMicrosoftTeamsConfiguredTeamsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsIterable listMicrosoftTeamsConfiguredTeamsPaginator(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest)
            throws ListMicrosoftTeamsConfiguredTeamsException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new ListMicrosoftTeamsConfiguredTeamsIterable(this, listMicrosoftTeamsConfiguredTeamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client
     *             .listMicrosoftTeamsConfiguredTeamsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsIterable listMicrosoftTeamsConfiguredTeamsPaginator(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest)
            throws ListMicrosoftTeamsConfiguredTeamsException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsConfiguredTeamsPaginator(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * Lists all Microsoft Teams user identities with a mapped role.
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return Result of the ListMicrosoftTeamsUserIdentities operation returned by the service.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesResponse listMicrosoftTeamsUserIdentities(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest)
            throws ListMicrosoftTeamsUserIdentitiesException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists all Microsoft Teams user identities with a mapped role.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListMicrosoftTeamsUserIdentities operation returned by the service.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesResponse listMicrosoftTeamsUserIdentities(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest)
            throws ListMicrosoftTeamsUserIdentitiesException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsUserIdentities(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client
     *             .listMicrosoftTeamsUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesIterable listMicrosoftTeamsUserIdentitiesPaginator(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest)
            throws ListMicrosoftTeamsUserIdentitiesException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new ListMicrosoftTeamsUserIdentitiesIterable(this, listMicrosoftTeamsUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client
     *             .listMicrosoftTeamsUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesIterable listMicrosoftTeamsUserIdentitiesPaginator(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest)
            throws ListMicrosoftTeamsUserIdentitiesException, InvalidRequestException, InvalidParameterException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsUserIdentitiesPaginator(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * Retrieves the list of tags applied to a configuration.
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServiceErrorException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieves the list of tags applied to a configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServiceErrorException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, ChatbotException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Applies the supplied tags to a configuration.
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws TooManyTagsException
     *         The supplied list of tags contains too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServiceErrorException,
            ServiceUnavailableException, ResourceNotFoundException, TooManyTagsException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Applies the supplied tags to a configuration.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws TooManyTagsException
     *         The supplied list of tags contains too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServiceErrorException, ServiceUnavailableException, ResourceNotFoundException, TooManyTagsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * Removes the supplied tags from a configuration
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServiceErrorException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes the supplied tags from a configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServiceErrorException
     *         Customer/consumer-facing internal service exception.
     *         https://w.amazon.com/index.php/AWS/API_Standards/Exceptions#InternalServiceError
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServiceErrorException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Update Chatbot account level preferences
     *
     * @param updateAccountPreferencesRequest
     * @return Result of the UpdateAccountPreferences operation returned by the service.
     * @throws UpdateAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountPreferencesResponse updateAccountPreferences(
            UpdateAccountPreferencesRequest updateAccountPreferencesRequest) throws UpdateAccountPreferencesException,
            InvalidParameterException, InvalidRequestException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update Chatbot account level preferences<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param updateAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccountPreferences operation returned by the service.
     * @throws UpdateAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountPreferencesResponse updateAccountPreferences(
            Consumer<UpdateAccountPreferencesRequest.Builder> updateAccountPreferencesRequest)
            throws UpdateAccountPreferencesException, InvalidParameterException, InvalidRequestException, AwsServiceException,
            SdkClientException, ChatbotException {
        return updateAccountPreferences(UpdateAccountPreferencesRequest.builder().applyMutation(updateAccountPreferencesRequest)
                .build());
    }

    /**
     * Updates a Chime Webhook Configuration
     *
     * @param updateChimeWebhookConfigurationRequest
     * @return Result of the UpdateChimeWebhookConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChimeWebhookConfigurationResponse updateChimeWebhookConfiguration(
            UpdateChimeWebhookConfigurationRequest updateChimeWebhookConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, UpdateChimeWebhookConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a Chime Webhook Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateChimeWebhookConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChimeWebhookConfigurationResponse updateChimeWebhookConfiguration(
            Consumer<UpdateChimeWebhookConfigurationRequest.Builder> updateChimeWebhookConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            UpdateChimeWebhookConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return updateChimeWebhookConfiguration(UpdateChimeWebhookConfigurationRequest.builder()
                .applyMutation(updateChimeWebhookConfigurationRequest).build());
    }

    /**
     * Updates MS Teams Channel Configuration
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMicrosoftTeamsChannelConfigurationResponse updateMicrosoftTeamsChannelConfiguration(
            UpdateMicrosoftTeamsChannelConfigurationRequest updateMicrosoftTeamsChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            UpdateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates MS Teams Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMicrosoftTeamsChannelConfigurationResponse updateMicrosoftTeamsChannelConfiguration(
            Consumer<UpdateMicrosoftTeamsChannelConfigurationRequest.Builder> updateMicrosoftTeamsChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            UpdateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return updateMicrosoftTeamsChannelConfiguration(UpdateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(updateMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * Updates Slack Channel Configuration
     *
     * @param updateSlackChannelConfigurationRequest
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, InvalidRequestException, UpdateSlackChannelConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates Slack Channel Configuration<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         We were not able to find the resource for your request.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints that AWS Chatbot requires.
     * @throws UpdateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            Consumer<UpdateSlackChannelConfigurationRequest.Builder> updateSlackChannelConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            UpdateSlackChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.builder()
                .applyMutation(updateSlackChannelConfigurationRequest).build());
    }

    /**
     * Create a {@link ChatbotClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChatbotClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChatbotClient}.
     */
    static ChatbotClientBuilder builder() {
        return new DefaultChatbotClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ChatbotServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
