/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Slack Workspace.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackWorkspace implements SdkPojo, Serializable, ToCopyableBuilder<SlackWorkspace.Builder, SlackWorkspace> {
    private static final SdkField<String> SLACK_TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamId").getter(getter(SlackWorkspace::slackTeamId)).setter(setter(Builder::slackTeamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamId").build()).build();

    private static final SdkField<String> SLACK_TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamName").getter(getter(SlackWorkspace::slackTeamName)).setter(setter(Builder::slackTeamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_TEAM_ID_FIELD,
            SLACK_TEAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String slackTeamId;

    private final String slackTeamName;

    private SlackWorkspace(BuilderImpl builder) {
        this.slackTeamId = builder.slackTeamId;
        this.slackTeamName = builder.slackTeamName;
    }

    /**
     * The ID of the Slack workspace authorized with AWS Chatbot.
     * 
     * @return The ID of the Slack workspace authorized with AWS Chatbot.
     */
    public final String slackTeamId() {
        return slackTeamId;
    }

    /**
     * Name of the Slack Workspace.
     * 
     * @return Name of the Slack Workspace.
     */
    public final String slackTeamName() {
        return slackTeamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamId());
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackWorkspace)) {
            return false;
        }
        SlackWorkspace other = (SlackWorkspace) obj;
        return Objects.equals(slackTeamId(), other.slackTeamId()) && Objects.equals(slackTeamName(), other.slackTeamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackWorkspace").add("SlackTeamId", slackTeamId()).add("SlackTeamName", slackTeamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlackTeamId":
            return Optional.ofNullable(clazz.cast(slackTeamId()));
        case "SlackTeamName":
            return Optional.ofNullable(clazz.cast(slackTeamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlackWorkspace, T> g) {
        return obj -> g.apply((SlackWorkspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackWorkspace> {
        /**
         * The ID of the Slack workspace authorized with AWS Chatbot.
         * 
         * @param slackTeamId
         *        The ID of the Slack workspace authorized with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamId(String slackTeamId);

        /**
         * Name of the Slack Workspace.
         * 
         * @param slackTeamName
         *        Name of the Slack Workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamName(String slackTeamName);
    }

    static final class BuilderImpl implements Builder {
        private String slackTeamId;

        private String slackTeamName;

        private BuilderImpl() {
        }

        private BuilderImpl(SlackWorkspace model) {
            slackTeamId(model.slackTeamId);
            slackTeamName(model.slackTeamName);
        }

        public final String getSlackTeamId() {
            return slackTeamId;
        }

        public final void setSlackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
        }

        @Override
        public final Builder slackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
            return this;
        }

        public final String getSlackTeamName() {
            return slackTeamName;
        }

        public final void setSlackTeamName(String slackTeamName) {
            this.slackTeamName = slackTeamName;
        }

        @Override
        public final Builder slackTeamName(String slackTeamName) {
            this.slackTeamName = slackTeamName;
            return this;
        }

        @Override
        public SlackWorkspace build() {
            return new SlackWorkspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
