/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChimeWebhookConfigurationResponse extends ChatbotResponse implements
        ToCopyableBuilder<CreateChimeWebhookConfigurationResponse.Builder, CreateChimeWebhookConfigurationResponse> {
    private static final SdkField<ChimeWebhookConfiguration> WEBHOOK_CONFIGURATION_FIELD = SdkField
            .<ChimeWebhookConfiguration> builder(MarshallingType.SDK_POJO).memberName("WebhookConfiguration")
            .getter(getter(CreateChimeWebhookConfigurationResponse::webhookConfiguration))
            .setter(setter(Builder::webhookConfiguration)).constructor(ChimeWebhookConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_CONFIGURATION_FIELD));

    private final ChimeWebhookConfiguration webhookConfiguration;

    private CreateChimeWebhookConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.webhookConfiguration = builder.webhookConfiguration;
    }

    /**
     * <p>
     * An Amazon Chime webhook configuration.
     * </p>
     * 
     * @return An Amazon Chime webhook configuration.
     */
    public final ChimeWebhookConfiguration webhookConfiguration() {
        return webhookConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webhookConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChimeWebhookConfigurationResponse)) {
            return false;
        }
        CreateChimeWebhookConfigurationResponse other = (CreateChimeWebhookConfigurationResponse) obj;
        return Objects.equals(webhookConfiguration(), other.webhookConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChimeWebhookConfigurationResponse").add("WebhookConfiguration", webhookConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebhookConfiguration":
            return Optional.ofNullable(clazz.cast(webhookConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChimeWebhookConfigurationResponse, T> g) {
        return obj -> g.apply((CreateChimeWebhookConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateChimeWebhookConfigurationResponse> {
        /**
         * <p>
         * An Amazon Chime webhook configuration.
         * </p>
         * 
         * @param webhookConfiguration
         *        An Amazon Chime webhook configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookConfiguration(ChimeWebhookConfiguration webhookConfiguration);

        /**
         * <p>
         * An Amazon Chime webhook configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChimeWebhookConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChimeWebhookConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChimeWebhookConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #webhookConfiguration(ChimeWebhookConfiguration)}.
         * 
         * @param webhookConfiguration
         *        a consumer that will call methods on {@link ChimeWebhookConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webhookConfiguration(ChimeWebhookConfiguration)
         */
        default Builder webhookConfiguration(Consumer<ChimeWebhookConfiguration.Builder> webhookConfiguration) {
            return webhookConfiguration(ChimeWebhookConfiguration.builder().applyMutation(webhookConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private ChimeWebhookConfiguration webhookConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChimeWebhookConfigurationResponse model) {
            super(model);
            webhookConfiguration(model.webhookConfiguration);
        }

        public final ChimeWebhookConfiguration.Builder getWebhookConfiguration() {
            return webhookConfiguration != null ? webhookConfiguration.toBuilder() : null;
        }

        public final void setWebhookConfiguration(ChimeWebhookConfiguration.BuilderImpl webhookConfiguration) {
            this.webhookConfiguration = webhookConfiguration != null ? webhookConfiguration.build() : null;
        }

        @Override
        public final Builder webhookConfiguration(ChimeWebhookConfiguration webhookConfiguration) {
            this.webhookConfiguration = webhookConfiguration;
            return this;
        }

        @Override
        public CreateChimeWebhookConfigurationResponse build() {
            return new CreateChimeWebhookConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
