/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Slack workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlackWorkspace implements SdkPojo, Serializable, ToCopyableBuilder<SlackWorkspace.Builder, SlackWorkspace> {
    private static final SdkField<String> SLACK_TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamId").getter(getter(SlackWorkspace::slackTeamId)).setter(setter(Builder::slackTeamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamId").build()).build();

    private static final SdkField<String> SLACK_TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlackTeamName").getter(getter(SlackWorkspace::slackTeamName)).setter(setter(Builder::slackTeamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlackTeamName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(SlackWorkspace::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(SlackWorkspace::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLACK_TEAM_ID_FIELD,
            SLACK_TEAM_NAME_FIELD, STATE_FIELD, STATE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String slackTeamId;

    private final String slackTeamName;

    private final String state;

    private final String stateReason;

    private SlackWorkspace(BuilderImpl builder) {
        this.slackTeamId = builder.slackTeamId;
        this.slackTeamName = builder.slackTeamName;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    /**
     * <p>
     * The ID of the Slack workspace authorized with AWS Chatbot.
     * </p>
     * 
     * @return The ID of the Slack workspace authorized with AWS Chatbot.
     */
    public final String slackTeamId() {
        return slackTeamId;
    }

    /**
     * <p>
     * The name of the Slack workspace.
     * </p>
     * 
     * @return The name of the Slack workspace.
     */
    public final String slackTeamName() {
        return slackTeamName;
    }

    /**
     * <p>
     * Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
     * organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime is
     * disabled.
     * </p>
     * 
     * @return Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
     *         organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime
     *         is disabled.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
     * </p>
     * 
     * @return Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
     */
    public final String stateReason() {
        return stateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamId());
        hashCode = 31 * hashCode + Objects.hashCode(slackTeamName());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlackWorkspace)) {
            return false;
        }
        SlackWorkspace other = (SlackWorkspace) obj;
        return Objects.equals(slackTeamId(), other.slackTeamId()) && Objects.equals(slackTeamName(), other.slackTeamName())
                && Objects.equals(state(), other.state()) && Objects.equals(stateReason(), other.stateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlackWorkspace").add("SlackTeamId", slackTeamId()).add("SlackTeamName", slackTeamName())
                .add("State", state()).add("StateReason", stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SlackTeamId":
            return Optional.ofNullable(clazz.cast(slackTeamId()));
        case "SlackTeamName":
            return Optional.ofNullable(clazz.cast(slackTeamName()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlackWorkspace, T> g) {
        return obj -> g.apply((SlackWorkspace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlackWorkspace> {
        /**
         * <p>
         * The ID of the Slack workspace authorized with AWS Chatbot.
         * </p>
         * 
         * @param slackTeamId
         *        The ID of the Slack workspace authorized with AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamId(String slackTeamId);

        /**
         * <p>
         * The name of the Slack workspace.
         * </p>
         * 
         * @param slackTeamName
         *        The name of the Slack workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slackTeamName(String slackTeamName);

        /**
         * <p>
         * Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
         * organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime is
         * disabled.
         * </p>
         * 
         * @param state
         *        Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if
         *        the organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon
         *        Chime is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
         * </p>
         * 
         * @param stateReason
         *        Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);
    }

    static final class BuilderImpl implements Builder {
        private String slackTeamId;

        private String slackTeamName;

        private String state;

        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SlackWorkspace model) {
            slackTeamId(model.slackTeamId);
            slackTeamName(model.slackTeamName);
            state(model.state);
            stateReason(model.stateReason);
        }

        public final String getSlackTeamId() {
            return slackTeamId;
        }

        public final void setSlackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
        }

        @Override
        public final Builder slackTeamId(String slackTeamId) {
            this.slackTeamId = slackTeamId;
            return this;
        }

        public final String getSlackTeamName() {
            return slackTeamName;
        }

        public final void setSlackTeamName(String slackTeamName) {
            this.slackTeamName = slackTeamName;
        }

        @Override
        public final Builder slackTeamName(String slackTeamName) {
            this.slackTeamName = slackTeamName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public SlackWorkspace build() {
            return new SlackWorkspace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
