/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChimeWebhookConfigurationRequest extends ChatbotRequest implements
        ToCopyableBuilder<UpdateChimeWebhookConfigurationRequest.Builder, UpdateChimeWebhookConfigurationRequest> {
    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(UpdateChimeWebhookConfigurationRequest::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> WEBHOOK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebhookDescription").getter(getter(UpdateChimeWebhookConfigurationRequest::webhookDescription))
            .setter(setter(Builder::webhookDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookDescription").build())
            .build();

    private static final SdkField<String> WEBHOOK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebhookUrl").getter(getter(UpdateChimeWebhookConfigurationRequest::webhookUrl))
            .setter(setter(Builder::webhookUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookUrl").build()).build();

    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnsTopicArns")
            .getter(getter(UpdateChimeWebhookConfigurationRequest::snsTopicArns))
            .setter(setter(Builder::snsTopicArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(UpdateChimeWebhookConfigurationRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(UpdateChimeWebhookConfigurationRequest::loggingLevel))
            .setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_CONFIGURATION_ARN_FIELD,
            WEBHOOK_DESCRIPTION_FIELD, WEBHOOK_URL_FIELD, SNS_TOPIC_ARNS_FIELD, IAM_ROLE_ARN_FIELD, LOGGING_LEVEL_FIELD));

    private final String chatConfigurationArn;

    private final String webhookDescription;

    private final String webhookUrl;

    private final List<String> snsTopicArns;

    private final String iamRoleArn;

    private final String loggingLevel;

    private UpdateChimeWebhookConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.webhookDescription = builder.webhookDescription;
        this.webhookUrl = builder.webhookUrl;
        this.snsTopicArns = builder.snsTopicArns;
        this.iamRoleArn = builder.iamRoleArn;
        this.loggingLevel = builder.loggingLevel;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration to update.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration to update.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * <p>
     * A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with Amazon
     * Chime</a> in the <i> AWS Chatbot Administrator Guide</i>.
     * </p>
     * 
     * @return A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with
     *         Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>.
     */
    public final String webhookDescription() {
        return webhookDescription;
    }

    /**
     * <p>
     * The URL for the Amazon Chime webhook.
     * </p>
     * 
     * @return The URL for the Amazon Chime webhook.
     */
    public final String webhookUrl() {
        return webhookUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnsTopicArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnsTopicArns() {
        return snsTopicArns != null && !(snsTopicArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnsTopicArns} method.
     * </p>
     * 
     * @return The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    public final List<String> snsTopicArns() {
        return snsTopicArns;
    }

    /**
     * <p>
     * A user-defined role that AWS Chatbot assumes. This is not the service-linked role.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS
     * Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
     * </p>
     * 
     * @return A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for
     *         AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.
     * </p>
     * 
     * @return Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(webhookDescription());
        hashCode = 31 * hashCode + Objects.hashCode(webhookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnsTopicArns() ? snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChimeWebhookConfigurationRequest)) {
            return false;
        }
        UpdateChimeWebhookConfigurationRequest other = (UpdateChimeWebhookConfigurationRequest) obj;
        return Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(webhookDescription(), other.webhookDescription())
                && Objects.equals(webhookUrl(), other.webhookUrl()) && hasSnsTopicArns() == other.hasSnsTopicArns()
                && Objects.equals(snsTopicArns(), other.snsTopicArns()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(loggingLevel(), other.loggingLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChimeWebhookConfigurationRequest").add("ChatConfigurationArn", chatConfigurationArn())
                .add("WebhookDescription", webhookDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebhookUrl", webhookUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnsTopicArns", hasSnsTopicArns() ? snsTopicArns() : null).add("IamRoleArn", iamRoleArn())
                .add("LoggingLevel", loggingLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "WebhookDescription":
            return Optional.ofNullable(clazz.cast(webhookDescription()));
        case "WebhookUrl":
            return Optional.ofNullable(clazz.cast(webhookUrl()));
        case "SnsTopicArns":
            return Optional.ofNullable(clazz.cast(snsTopicArns()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChimeWebhookConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateChimeWebhookConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChimeWebhookConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration to update.
         * </p>
         * 
         * @param chatConfigurationArn
         *        The Amazon Resource Number (ARN) of the ChimeWebhookConfiguration to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * <p>
         * A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started with
         * Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * </p>
         * 
         * @param webhookDescription
         *        A description of the webhook. We recommend using the convention <code>RoomName/WebhookName</code>.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html">Tutorial: Get started
         *        with Amazon Chime</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookDescription(String webhookDescription);

        /**
         * <p>
         * The URL for the Amazon Chime webhook.
         * </p>
         * 
         * @param webhookUrl
         *        The URL for the Amazon Chime webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhookUrl(String webhookUrl);

        /**
         * <p>
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * </p>
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(Collection<String> snsTopicArns);

        /**
         * <p>
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * </p>
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(String... snsTopicArns);

        /**
         * <p>
         * A user-defined role that AWS Chatbot assumes. This is not the service-linked role.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies for AWS
         * Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        A user-defined role that AWS Chatbot assumes. This is not the service-linked role.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM policies
         *        for AWS Chatbot</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.
         * </p>
         * 
         * @param loggingLevel
         *        Logging levels include <code>ERROR</code>, <code>INFO</code>, or <code>NONE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChatbotRequest.BuilderImpl implements Builder {
        private String chatConfigurationArn;

        private String webhookDescription;

        private String webhookUrl;

        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();

        private String iamRoleArn;

        private String loggingLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChimeWebhookConfigurationRequest model) {
            super(model);
            chatConfigurationArn(model.chatConfigurationArn);
            webhookDescription(model.webhookDescription);
            webhookUrl(model.webhookUrl);
            snsTopicArns(model.snsTopicArns);
            iamRoleArn(model.iamRoleArn);
            loggingLevel(model.loggingLevel);
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getWebhookDescription() {
            return webhookDescription;
        }

        public final void setWebhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
        }

        @Override
        public final Builder webhookDescription(String webhookDescription) {
            this.webhookDescription = webhookDescription;
            return this;
        }

        public final String getWebhookUrl() {
            return webhookUrl;
        }

        public final void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        @Override
        public final Builder webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String... snsTopicArns) {
            snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChimeWebhookConfigurationRequest build() {
            return new UpdateChimeWebhookConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
