/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.chatbot.model.ChatbotException;
import software.amazon.awssdk.services.chatbot.model.ConflictException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsConfiguredTeamException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.GetTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.InternalServiceErrorException;
import software.amazon.awssdk.services.chatbot.model.InvalidParameterException;
import software.amazon.awssdk.services.chatbot.model.InvalidRequestException;
import software.amazon.awssdk.services.chatbot.model.LimitExceededException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chatbot.model.ListTeamsChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.chatbot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chatbot.model.TagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.TagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.TooManyTagsException;
import software.amazon.awssdk.services.chatbot.model.UntagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.UntagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable;

/**
 * Service client for accessing AWS Chatbot. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The <i>AWS Chatbot API Reference</i> provides descriptions, API request parameters, and the XML response for each of
 * the AWS Chatbot API actions.
 * </p>
 * <p>
 * AWS Chatbot APIs are currently available in the following Regions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * US East (Ohio) - <code>us-east-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * US West (Oregon) - <code>us-west-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Asia Pacific (Singapore) - <code>ap-southeast-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Europe (Ireland) - <code>eu-west-1</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * The AWS Chatbot console can only be used in US East (Ohio). Your configuration data however, is stored in each of the
 * relevant available Regions.
 * </p>
 * <note>
 * <p>
 * Your AWS CloudTrail events are logged in whatever Region you call from, not US East (N. Virginia) by default.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ChatbotClient extends AwsClient {
    String SERVICE_NAME = "chatbot";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "chatbot";

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Amazon Chime.
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     * @return Result of the CreateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChimeWebhookConfigurationResponse createChimeWebhookConfiguration(
            CreateChimeWebhookConfigurationRequest createChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ConflictException, LimitExceededException, CreateChimeWebhookConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Amazon Chime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateChimeWebhookConfigurationResponse createChimeWebhookConfiguration(
            Consumer<CreateChimeWebhookConfigurationRequest.Builder> createChimeWebhookConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ConflictException, LimitExceededException,
            CreateChimeWebhookConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return createChimeWebhookConfiguration(CreateChimeWebhookConfigurationRequest.builder()
                .applyMutation(createChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Microsoft Teams.
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the CreateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMicrosoftTeamsChannelConfigurationResponse createMicrosoftTeamsChannelConfiguration(
            CreateMicrosoftTeamsChannelConfigurationRequest createMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ConflictException, LimitExceededException,
            CreateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Microsoft Teams.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMicrosoftTeamsChannelConfigurationResponse createMicrosoftTeamsChannelConfiguration(
            Consumer<CreateMicrosoftTeamsChannelConfigurationRequest.Builder> createMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ConflictException, LimitExceededException,
            CreateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return createMicrosoftTeamsChannelConfiguration(CreateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(createMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Chatbot confugration for Slack.
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ConflictException, LimitExceededException, CreateSlackChannelConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot confugration for Slack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            Consumer<CreateSlackChannelConfigurationRequest.Builder> createSlackChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ConflictException, LimitExceededException,
            CreateSlackChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.builder()
                .applyMutation(createSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a Amazon Chime webhook configuration for AWS Chatbot.
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     * @return Result of the DeleteChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChimeWebhookConfigurationResponse deleteChimeWebhookConfiguration(
            DeleteChimeWebhookConfigurationRequest deleteChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, DeleteChimeWebhookConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Amazon Chime webhook configuration for AWS Chatbot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteChimeWebhookConfigurationResponse deleteChimeWebhookConfiguration(
            Consumer<DeleteChimeWebhookConfigurationRequest.Builder> deleteChimeWebhookConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            DeleteChimeWebhookConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteChimeWebhookConfiguration(DeleteChimeWebhookConfigurationRequest.builder()
                .applyMutation(deleteChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a Microsoft Teams channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsChannelConfigurationResponse deleteMicrosoftTeamsChannelConfiguration(
            DeleteMicrosoftTeamsChannelConfigurationRequest deleteMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            DeleteTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Microsoft Teams channel configuration for AWS Chatbot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsChannelConfigurationResponse deleteMicrosoftTeamsChannelConfiguration(
            Consumer<DeleteMicrosoftTeamsChannelConfigurationRequest.Builder> deleteMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            DeleteTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteMicrosoftTeamsChannelConfiguration(DeleteMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(deleteMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     * @return Result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteTeamsConfiguredTeamException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsConfiguredTeamResponse deleteMicrosoftTeamsConfiguredTeam(
            DeleteMicrosoftTeamsConfiguredTeamRequest deleteMicrosoftTeamsConfiguredTeamRequest)
            throws InvalidParameterException, DeleteTeamsConfiguredTeamException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsConfiguredTeamRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsConfiguredTeamRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteTeamsConfiguredTeamException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsConfiguredTeamResponse deleteMicrosoftTeamsConfiguredTeam(
            Consumer<DeleteMicrosoftTeamsConfiguredTeamRequest.Builder> deleteMicrosoftTeamsConfiguredTeamRequest)
            throws InvalidParameterException, DeleteTeamsConfiguredTeamException, AwsServiceException, SdkClientException,
            ChatbotException {
        return deleteMicrosoftTeamsConfiguredTeam(DeleteMicrosoftTeamsConfiguredTeamRequest.builder()
                .applyMutation(deleteMicrosoftTeamsConfiguredTeamRequest).build());
    }

    /**
     * <p>
     * Identifes a user level permission for a channel configuration.
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     * @return Result of the DeleteMicrosoftTeamsUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteMicrosoftTeamsUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsUserIdentityResponse deleteMicrosoftTeamsUserIdentity(
            DeleteMicrosoftTeamsUserIdentityRequest deleteMicrosoftTeamsUserIdentityRequest) throws InvalidParameterException,
            ResourceNotFoundException, DeleteMicrosoftTeamsUserIdentityException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Identifes a user level permission for a channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsUserIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMicrosoftTeamsUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteMicrosoftTeamsUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMicrosoftTeamsUserIdentityResponse deleteMicrosoftTeamsUserIdentity(
            Consumer<DeleteMicrosoftTeamsUserIdentityRequest.Builder> deleteMicrosoftTeamsUserIdentityRequest)
            throws InvalidParameterException, ResourceNotFoundException, DeleteMicrosoftTeamsUserIdentityException,
            AwsServiceException, SdkClientException, ChatbotException {
        return deleteMicrosoftTeamsUserIdentity(DeleteMicrosoftTeamsUserIdentityRequest.builder()
                .applyMutation(deleteMicrosoftTeamsUserIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes a Slack channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, DeleteSlackChannelConfigurationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Slack channel configuration for AWS Chatbot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            Consumer<DeleteSlackChannelConfigurationRequest.Builder> deleteSlackChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, DeleteSlackChannelConfigurationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ChatbotException {
        return deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.builder()
                .applyMutation(deleteSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a user level permission for a Slack channel configuration.
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     * @return Result of the DeleteSlackUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackUserIdentityResponse deleteSlackUserIdentity(DeleteSlackUserIdentityRequest deleteSlackUserIdentityRequest)
            throws InvalidParameterException, DeleteSlackUserIdentityException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user level permission for a Slack channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackUserIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSlackUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSlackUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackUserIdentityResponse deleteSlackUserIdentity(
            Consumer<DeleteSlackUserIdentityRequest.Builder> deleteSlackUserIdentityRequest) throws InvalidParameterException,
            DeleteSlackUserIdentityException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            ChatbotException {
        return deleteSlackUserIdentity(DeleteSlackUserIdentityRequest.builder().applyMutation(deleteSlackUserIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     * @return Result of the DeleteSlackWorkspaceAuthorization operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackWorkspaceAuthorizationException
     *         There was an issue deleting your Slack workspace.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceAuthorizationResponse deleteSlackWorkspaceAuthorization(
            DeleteSlackWorkspaceAuthorizationRequest deleteSlackWorkspaceAuthorizationRequest) throws InvalidParameterException,
            DeleteSlackWorkspaceAuthorizationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackWorkspaceAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackWorkspaceAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSlackWorkspaceAuthorization operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackWorkspaceAuthorizationException
     *         There was an issue deleting your Slack workspace.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSlackWorkspaceAuthorizationResponse deleteSlackWorkspaceAuthorization(
            Consumer<DeleteSlackWorkspaceAuthorizationRequest.Builder> deleteSlackWorkspaceAuthorizationRequest)
            throws InvalidParameterException, DeleteSlackWorkspaceAuthorizationException, AwsServiceException,
            SdkClientException, ChatbotException {
        return deleteSlackWorkspaceAuthorization(DeleteSlackWorkspaceAuthorizationRequest.builder()
                .applyMutation(deleteSlackWorkspaceAuthorizationRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return Result of the DescribeChimeWebhookConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsResponse describeChimeWebhookConfigurations(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeChimeWebhookConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeChimeWebhookConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsResponse describeChimeWebhookConfigurations(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeChimeWebhookConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeChimeWebhookConfigurations(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client
     *             .describeChimeWebhookConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsIterable describeChimeWebhookConfigurationsPaginator(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeChimeWebhookConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeChimeWebhookConfigurationsIterable(this, describeChimeWebhookConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client
     *             .describeChimeWebhookConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsIterable responses = client.describeChimeWebhookConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsIterable describeChimeWebhookConfigurationsPaginator(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeChimeWebhookConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeChimeWebhookConfigurationsPaginator(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists Slack channel configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return Result of the DescribeSlackChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsResponse describeSlackChannelConfigurations(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackChannelConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Slack channel configurations optionally filtered by ChatConfigurationArn
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSlackChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsResponse describeSlackChannelConfigurations(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackChannelConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackChannelConfigurations(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client
     *             .describeSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsIterable describeSlackChannelConfigurationsPaginator(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackChannelConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeSlackChannelConfigurationsIterable(this, describeSlackChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client
     *             .describeSlackChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsIterable responses = client.describeSlackChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsIterable describeSlackChannelConfigurationsPaginator(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackChannelConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackChannelConfigurationsPaginator(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all Slack user identities with a mapped role.
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return Result of the DescribeSlackUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesResponse describeSlackUserIdentities(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Slack user identities with a mapped role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeSlackUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesResponse describeSlackUserIdentities(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackUserIdentities(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client
     *             .describeSlackUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesIterable describeSlackUserIdentitiesPaginator(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        return new DescribeSlackUserIdentitiesIterable(this, describeSlackUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client
     *             .describeSlackUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesIterable responses = client.describeSlackUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesIterable describeSlackUserIdentitiesPaginator(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException,
            SdkClientException, ChatbotException {
        return describeSlackUserIdentitiesPaginator(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return Result of the DescribeSlackWorkspaces operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesResponse describeSlackWorkspaces(DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest)
            throws InvalidParameterException, DescribeSlackWorkspacesException, InvalidRequestException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSlackWorkspaces operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesResponse describeSlackWorkspaces(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest) throws InvalidParameterException,
            DescribeSlackWorkspacesException, InvalidRequestException, AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackWorkspaces(DescribeSlackWorkspacesRequest.builder().applyMutation(describeSlackWorkspacesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client
     *             .describeSlackWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesIterable describeSlackWorkspacesPaginator(
            DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest) throws InvalidParameterException,
            DescribeSlackWorkspacesException, InvalidRequestException, AwsServiceException, SdkClientException, ChatbotException {
        return new DescribeSlackWorkspacesIterable(this, describeSlackWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client
     *             .describeSlackWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesIterable responses = client.describeSlackWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesIterable describeSlackWorkspacesPaginator(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest) throws InvalidParameterException,
            DescribeSlackWorkspacesException, InvalidRequestException, AwsServiceException, SdkClientException, ChatbotException {
        return describeSlackWorkspacesPaginator(DescribeSlackWorkspacesRequest.builder()
                .applyMutation(describeSlackWorkspacesRequest).build());
    }

    /**
     * <p>
     * Returns AWS Chatbot account preferences.
     * </p>
     *
     * @param getAccountPreferencesRequest
     * @return Result of the GetAccountPreferences operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPreferencesResponse getAccountPreferences(GetAccountPreferencesRequest getAccountPreferencesRequest)
            throws InvalidRequestException, GetAccountPreferencesException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS Chatbot account preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPreferencesRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param getAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountPreferences operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAccountPreferencesResponse getAccountPreferences(
            Consumer<GetAccountPreferencesRequest.Builder> getAccountPreferencesRequest) throws InvalidRequestException,
            GetAccountPreferencesException, AwsServiceException, SdkClientException, ChatbotException {
        return getAccountPreferences(GetAccountPreferencesRequest.builder().applyMutation(getAccountPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns a Microsoft Teams channel configuration in an AWS account.
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the GetMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMicrosoftTeamsChannelConfigurationResponse getMicrosoftTeamsChannelConfiguration(
            GetMicrosoftTeamsChannelConfigurationRequest getMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, GetTeamsChannelConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Microsoft Teams channel configuration in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMicrosoftTeamsChannelConfigurationResponse getMicrosoftTeamsChannelConfiguration(
            Consumer<GetMicrosoftTeamsChannelConfigurationRequest.Builder> getMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, GetTeamsChannelConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        return getMicrosoftTeamsChannelConfiguration(GetMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(getMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return Result of the ListMicrosoftTeamsChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsResponse listMicrosoftTeamsChannelConfigurations(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest)
            throws InvalidParameterException, ListTeamsChannelConfigurationsException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListMicrosoftTeamsChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsResponse listMicrosoftTeamsChannelConfigurations(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest)
            throws InvalidParameterException, ListTeamsChannelConfigurationsException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsChannelConfigurations(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client
     *             .listMicrosoftTeamsChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsIterable listMicrosoftTeamsChannelConfigurationsPaginator(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest)
            throws InvalidParameterException, ListTeamsChannelConfigurationsException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return new ListMicrosoftTeamsChannelConfigurationsIterable(this, listMicrosoftTeamsChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client
     *             .listMicrosoftTeamsChannelConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsIterable responses = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsIterable listMicrosoftTeamsChannelConfigurationsPaginator(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest)
            throws InvalidParameterException, ListTeamsChannelConfigurationsException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsChannelConfigurationsPaginator(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all authorized Microsoft Teams for an AWS Account
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return Result of the ListMicrosoftTeamsConfiguredTeams operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsResponse listMicrosoftTeamsConfiguredTeams(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsConfiguredTeamsException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all authorized Microsoft Teams for an AWS Account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return Result of the ListMicrosoftTeamsConfiguredTeams operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsResponse listMicrosoftTeamsConfiguredTeams(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest)
            throws InvalidParameterException, InvalidRequestException, ListMicrosoftTeamsConfiguredTeamsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsConfiguredTeams(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client
     *             .listMicrosoftTeamsConfiguredTeamsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsIterable listMicrosoftTeamsConfiguredTeamsPaginator(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsConfiguredTeamsException, AwsServiceException, SdkClientException,
            ChatbotException {
        return new ListMicrosoftTeamsConfiguredTeamsIterable(this, listMicrosoftTeamsConfiguredTeamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client
     *             .listMicrosoftTeamsConfiguredTeamsPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsIterable responses = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsIterable listMicrosoftTeamsConfiguredTeamsPaginator(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest)
            throws InvalidParameterException, InvalidRequestException, ListMicrosoftTeamsConfiguredTeamsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsConfiguredTeamsPaginator(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * <p>
     * A list all Microsoft Teams user identities with a mapped role.
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return Result of the ListMicrosoftTeamsUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesResponse listMicrosoftTeamsUserIdentities(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list all Microsoft Teams user identities with a mapped role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListMicrosoftTeamsUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesResponse listMicrosoftTeamsUserIdentities(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, ListMicrosoftTeamsUserIdentitiesException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsUserIdentities(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client
     *             .listMicrosoftTeamsUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesIterable listMicrosoftTeamsUserIdentitiesPaginator(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        return new ListMicrosoftTeamsUserIdentitiesIterable(this, listMicrosoftTeamsUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client
     *             .listMicrosoftTeamsUserIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesIterable responses = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesIterable listMicrosoftTeamsUserIdentitiesPaginator(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest)
            throws InvalidParameterException, InvalidRequestException, ListMicrosoftTeamsUserIdentitiesException,
            AwsServiceException, SdkClientException, ChatbotException {
        return listMicrosoftTeamsUserIdentitiesPaginator(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceUnavailableException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceUnavailableException,
            ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, ChatbotException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws TooManyTagsException
     *         The supplied list of tags contains too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceUnavailableException,
            ResourceNotFoundException, InternalServiceErrorException, TooManyTagsException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws TooManyTagsException
     *         The supplied list of tags contains too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceUnavailableException, ResourceNotFoundException, InternalServiceErrorException, TooManyTagsException,
            AwsServiceException, SdkClientException, ChatbotException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException,
            ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceUnavailableException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, ChatbotException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates AWS Chatbot account preferences.
     * </p>
     *
     * @param updateAccountPreferencesRequest
     * @return Result of the UpdateAccountPreferences operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountPreferencesResponse updateAccountPreferences(
            UpdateAccountPreferencesRequest updateAccountPreferencesRequest) throws InvalidParameterException,
            InvalidRequestException, UpdateAccountPreferencesException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates AWS Chatbot account preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param updateAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAccountPreferences operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountPreferencesResponse updateAccountPreferences(
            Consumer<UpdateAccountPreferencesRequest.Builder> updateAccountPreferencesRequest) throws InvalidParameterException,
            InvalidRequestException, UpdateAccountPreferencesException, AwsServiceException, SdkClientException, ChatbotException {
        return updateAccountPreferences(UpdateAccountPreferencesRequest.builder().applyMutation(updateAccountPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Amazon Chime webhook configuration.
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     * @return Result of the UpdateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChimeWebhookConfigurationResponse updateChimeWebhookConfiguration(
            UpdateChimeWebhookConfigurationRequest updateChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, UpdateChimeWebhookConfigurationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Amazon Chime webhook configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateChimeWebhookConfigurationResponse updateChimeWebhookConfiguration(
            Consumer<UpdateChimeWebhookConfigurationRequest.Builder> updateChimeWebhookConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, UpdateChimeWebhookConfigurationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ChatbotException {
        return updateChimeWebhookConfiguration(UpdateChimeWebhookConfigurationRequest.builder()
                .applyMutation(updateChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an Microsoft Teams channel configuration.
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMicrosoftTeamsChannelConfigurationResponse updateMicrosoftTeamsChannelConfiguration(
            UpdateMicrosoftTeamsChannelConfigurationRequest updateMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            UpdateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Microsoft Teams channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMicrosoftTeamsChannelConfigurationResponse updateMicrosoftTeamsChannelConfiguration(
            Consumer<UpdateMicrosoftTeamsChannelConfigurationRequest.Builder> updateMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            UpdateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return updateMicrosoftTeamsChannelConfiguration(UpdateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(updateMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Slack channel configuration.
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, UpdateSlackChannelConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Slack channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            Consumer<UpdateSlackChannelConfigurationRequest.Builder> updateSlackChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            UpdateSlackChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        return updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.builder()
                .applyMutation(updateSlackChannelConfigurationRequest).build());
    }

    /**
     * Create a {@link ChatbotClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChatbotClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChatbotClient}.
     */
    static ChatbotClientBuilder builder() {
        return new DefaultChatbotClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ChatbotServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
