/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMicrosoftTeamsChannelConfigurationsResponse extends ChatbotResponse
        implements
        ToCopyableBuilder<ListMicrosoftTeamsChannelConfigurationsResponse.Builder, ListMicrosoftTeamsChannelConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMicrosoftTeamsChannelConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<TeamsChannelConfiguration>> TEAM_CHANNEL_CONFIGURATIONS_FIELD = SdkField
            .<List<TeamsChannelConfiguration>> builder(MarshallingType.LIST)
            .memberName("TeamChannelConfigurations")
            .getter(getter(ListMicrosoftTeamsChannelConfigurationsResponse::teamChannelConfigurations))
            .setter(setter(Builder::teamChannelConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamChannelConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TeamsChannelConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TeamsChannelConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEAM_CHANNEL_CONFIGURATIONS_FIELD));

    private final String nextToken;

    private final List<TeamsChannelConfiguration> teamChannelConfigurations;

    private ListMicrosoftTeamsChannelConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.teamChannelConfigurations = builder.teamChannelConfigurations;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TeamChannelConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTeamChannelConfigurations() {
        return teamChannelConfigurations != null && !(teamChannelConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS Chatbot channel configurations for Microsoft Teams.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTeamChannelConfigurations} method.
     * </p>
     * 
     * @return A list of AWS Chatbot channel configurations for Microsoft Teams.
     */
    public final List<TeamsChannelConfiguration> teamChannelConfigurations() {
        return teamChannelConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTeamChannelConfigurations() ? teamChannelConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMicrosoftTeamsChannelConfigurationsResponse)) {
            return false;
        }
        ListMicrosoftTeamsChannelConfigurationsResponse other = (ListMicrosoftTeamsChannelConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasTeamChannelConfigurations() == other.hasTeamChannelConfigurations()
                && Objects.equals(teamChannelConfigurations(), other.teamChannelConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMicrosoftTeamsChannelConfigurationsResponse").add("NextToken", nextToken())
                .add("TeamChannelConfigurations", hasTeamChannelConfigurations() ? teamChannelConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TeamChannelConfigurations":
            return Optional.ofNullable(clazz.cast(teamChannelConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMicrosoftTeamsChannelConfigurationsResponse, T> g) {
        return obj -> g.apply((ListMicrosoftTeamsChannelConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMicrosoftTeamsChannelConfigurationsResponse> {
        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of AWS Chatbot channel configurations for Microsoft Teams.
         * </p>
         * 
         * @param teamChannelConfigurations
         *        A list of AWS Chatbot channel configurations for Microsoft Teams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamChannelConfigurations(Collection<TeamsChannelConfiguration> teamChannelConfigurations);

        /**
         * <p>
         * A list of AWS Chatbot channel configurations for Microsoft Teams.
         * </p>
         * 
         * @param teamChannelConfigurations
         *        A list of AWS Chatbot channel configurations for Microsoft Teams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamChannelConfigurations(TeamsChannelConfiguration... teamChannelConfigurations);

        /**
         * <p>
         * A list of AWS Chatbot channel configurations for Microsoft Teams.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.TeamsChannelConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chatbot.model.TeamsChannelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.TeamsChannelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #teamChannelConfigurations(List<TeamsChannelConfiguration>)}.
         * 
         * @param teamChannelConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.TeamsChannelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teamChannelConfigurations(java.util.Collection<TeamsChannelConfiguration>)
         */
        Builder teamChannelConfigurations(Consumer<TeamsChannelConfiguration.Builder>... teamChannelConfigurations);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TeamsChannelConfiguration> teamChannelConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMicrosoftTeamsChannelConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            teamChannelConfigurations(model.teamChannelConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TeamsChannelConfiguration.Builder> getTeamChannelConfigurations() {
            List<TeamsChannelConfiguration.Builder> result = TeamChannelConfigurationsListCopier
                    .copyToBuilder(this.teamChannelConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTeamChannelConfigurations(Collection<TeamsChannelConfiguration.BuilderImpl> teamChannelConfigurations) {
            this.teamChannelConfigurations = TeamChannelConfigurationsListCopier.copyFromBuilder(teamChannelConfigurations);
        }

        @Override
        public final Builder teamChannelConfigurations(Collection<TeamsChannelConfiguration> teamChannelConfigurations) {
            this.teamChannelConfigurations = TeamChannelConfigurationsListCopier.copy(teamChannelConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamChannelConfigurations(TeamsChannelConfiguration... teamChannelConfigurations) {
            teamChannelConfigurations(Arrays.asList(teamChannelConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder teamChannelConfigurations(Consumer<TeamsChannelConfiguration.Builder>... teamChannelConfigurations) {
            teamChannelConfigurations(Stream.of(teamChannelConfigurations)
                    .map(c -> TeamsChannelConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMicrosoftTeamsChannelConfigurationsResponse build() {
            return new ListMicrosoftTeamsChannelConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
