/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chatbot.model.TagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.TagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.UntagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.UntagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsPublisher;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsPublisher;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesPublisher;
import software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesPublisher;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsPublisher;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsPublisher;
import software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesPublisher;

/**
 * Service client for accessing AWS Chatbot asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * The <i>AWS Chatbot API Reference</i> provides descriptions, API request parameters, and the XML response for each of
 * the AWS Chatbot API actions.
 * </p>
 * <p>
 * AWS Chatbot APIs are currently available in the following Regions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * US East (Ohio) - <code>us-east-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * US West (Oregon) - <code>us-west-2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Asia Pacific (Singapore) - <code>ap-southeast-1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * Europe (Ireland) - <code>eu-west-1</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * The AWS Chatbot console can only be used in US East (Ohio). Your configuration data however, is stored in each of the
 * relevant available Regions.
 * </p>
 * <note>
 * <p>
 * Your AWS CloudTrail events are logged in whatever Region you call from, not US East (N. Virginia) by default.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ChatbotAsyncClient extends AwsClient {
    String SERVICE_NAME = "chatbot";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "chatbot";

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Amazon Chime.
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     * @return A Java Future containing the result of the CreateChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChimeWebhookConfigurationResponse> createChimeWebhookConfiguration(
            CreateChimeWebhookConfigurationRequest createChimeWebhookConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Amazon Chime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateChimeWebhookConfigurationResponse> createChimeWebhookConfiguration(
            Consumer<CreateChimeWebhookConfigurationRequest.Builder> createChimeWebhookConfigurationRequest) {
        return createChimeWebhookConfiguration(CreateChimeWebhookConfigurationRequest.builder()
                .applyMutation(createChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Microsoft Teams.
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     * @return A Java Future containing the result of the CreateMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMicrosoftTeamsChannelConfigurationResponse> createMicrosoftTeamsChannelConfiguration(
            CreateMicrosoftTeamsChannelConfigurationRequest createMicrosoftTeamsChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Microsoft Teams.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMicrosoftTeamsChannelConfigurationResponse> createMicrosoftTeamsChannelConfiguration(
            Consumer<CreateMicrosoftTeamsChannelConfigurationRequest.Builder> createMicrosoftTeamsChannelConfigurationRequest) {
        return createMicrosoftTeamsChannelConfiguration(CreateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(createMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an AWS Chatbot confugration for Slack.
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     * @return A Java Future containing the result of the CreateSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSlackChannelConfigurationResponse> createSlackChannelConfiguration(
            CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Chatbot confugration for Slack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ConflictException There was an issue processing your request.</li>
     *         <li>LimitExceededException You have exceeded a service limit for AWS Chatbot.</li>
     *         <li>CreateSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSlackChannelConfigurationResponse> createSlackChannelConfiguration(
            Consumer<CreateSlackChannelConfigurationRequest.Builder> createSlackChannelConfigurationRequest) {
        return createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.builder()
                .applyMutation(createSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a Amazon Chime webhook configuration for AWS Chatbot.
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     * @return A Java Future containing the result of the DeleteChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChimeWebhookConfigurationResponse> deleteChimeWebhookConfiguration(
            DeleteChimeWebhookConfigurationRequest deleteChimeWebhookConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Amazon Chime webhook configuration for AWS Chatbot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteChimeWebhookConfigurationResponse> deleteChimeWebhookConfiguration(
            Consumer<DeleteChimeWebhookConfigurationRequest.Builder> deleteChimeWebhookConfigurationRequest) {
        return deleteChimeWebhookConfiguration(DeleteChimeWebhookConfigurationRequest.builder()
                .applyMutation(deleteChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a Microsoft Teams channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsChannelConfigurationResponse> deleteMicrosoftTeamsChannelConfiguration(
            DeleteMicrosoftTeamsChannelConfigurationRequest deleteMicrosoftTeamsChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Microsoft Teams channel configuration for AWS Chatbot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsChannelConfigurationResponse> deleteMicrosoftTeamsChannelConfiguration(
            Consumer<DeleteMicrosoftTeamsChannelConfigurationRequest.Builder> deleteMicrosoftTeamsChannelConfigurationRequest) {
        return deleteMicrosoftTeamsChannelConfiguration(DeleteMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(deleteMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteTeamsConfiguredTeamException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsConfiguredTeamResponse> deleteMicrosoftTeamsConfiguredTeam(
            DeleteMicrosoftTeamsConfiguredTeamRequest deleteMicrosoftTeamsConfiguredTeamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsConfiguredTeamRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsConfiguredTeamRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteTeamsConfiguredTeamException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsConfiguredTeamResponse> deleteMicrosoftTeamsConfiguredTeam(
            Consumer<DeleteMicrosoftTeamsConfiguredTeamRequest.Builder> deleteMicrosoftTeamsConfiguredTeamRequest) {
        return deleteMicrosoftTeamsConfiguredTeam(DeleteMicrosoftTeamsConfiguredTeamRequest.builder()
                .applyMutation(deleteMicrosoftTeamsConfiguredTeamRequest).build());
    }

    /**
     * <p>
     * Identifes a user level permission for a channel configuration.
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsUserIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteMicrosoftTeamsUserIdentityException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsUserIdentityResponse> deleteMicrosoftTeamsUserIdentity(
            DeleteMicrosoftTeamsUserIdentityRequest deleteMicrosoftTeamsUserIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Identifes a user level permission for a channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMicrosoftTeamsUserIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMicrosoftTeamsUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMicrosoftTeamsUserIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>DeleteMicrosoftTeamsUserIdentityException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMicrosoftTeamsUserIdentityResponse> deleteMicrosoftTeamsUserIdentity(
            Consumer<DeleteMicrosoftTeamsUserIdentityRequest.Builder> deleteMicrosoftTeamsUserIdentityRequest) {
        return deleteMicrosoftTeamsUserIdentity(DeleteMicrosoftTeamsUserIdentityRequest.builder()
                .applyMutation(deleteMicrosoftTeamsUserIdentityRequest).build());
    }

    /**
     * <p>
     * Deletes a Slack channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     * @return A Java Future containing the result of the DeleteSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackChannelConfigurationResponse> deleteSlackChannelConfiguration(
            DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Slack channel configuration for AWS Chatbot
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackChannelConfigurationResponse> deleteSlackChannelConfiguration(
            Consumer<DeleteSlackChannelConfigurationRequest.Builder> deleteSlackChannelConfigurationRequest) {
        return deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.builder()
                .applyMutation(deleteSlackChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a user level permission for a Slack channel configuration.
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     * @return A Java Future containing the result of the DeleteSlackUserIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackUserIdentityException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackUserIdentityResponse> deleteSlackUserIdentity(
            DeleteSlackUserIdentityRequest deleteSlackUserIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user level permission for a Slack channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackUserIdentityRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSlackUserIdentityRequest#builder()}
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSlackUserIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackUserIdentityException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackUserIdentityResponse> deleteSlackUserIdentity(
            Consumer<DeleteSlackUserIdentityRequest.Builder> deleteSlackUserIdentityRequest) {
        return deleteSlackUserIdentity(DeleteSlackUserIdentityRequest.builder().applyMutation(deleteSlackUserIdentityRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     * @return A Java Future containing the result of the DeleteSlackWorkspaceAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackWorkspaceAuthorizationException There was an issue deleting your Slack workspace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackWorkspaceAuthorizationResponse> deleteSlackWorkspaceAuthorization(
            DeleteSlackWorkspaceAuthorizationRequest deleteSlackWorkspaceAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlackWorkspaceAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSlackWorkspaceAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSlackWorkspaceAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DeleteSlackWorkspaceAuthorizationException There was an issue deleting your Slack workspace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSlackWorkspaceAuthorizationResponse> deleteSlackWorkspaceAuthorization(
            Consumer<DeleteSlackWorkspaceAuthorizationRequest.Builder> deleteSlackWorkspaceAuthorizationRequest) {
        return deleteSlackWorkspaceAuthorization(DeleteSlackWorkspaceAuthorizationRequest.builder()
                .applyMutation(deleteSlackWorkspaceAuthorizationRequest).build());
    }

    /**
     * <p>
     * Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return A Java Future containing the result of the DescribeChimeWebhookConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeChimeWebhookConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChimeWebhookConfigurationsResponse> describeChimeWebhookConfigurations(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeChimeWebhookConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeChimeWebhookConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeChimeWebhookConfigurationsResponse> describeChimeWebhookConfigurations(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest) {
        return describeChimeWebhookConfigurations(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsPublisher publisher = client.describeChimeWebhookConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsPublisher publisher = client.describeChimeWebhookConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeChimeWebhookConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsPublisher describeChimeWebhookConfigurationsPaginator(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest) {
        return new DescribeChimeWebhookConfigurationsPublisher(this, describeChimeWebhookConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsPublisher publisher = client.describeChimeWebhookConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeChimeWebhookConfigurationsPublisher publisher = client.describeChimeWebhookConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeChimeWebhookConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChimeWebhookConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeChimeWebhookConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeChimeWebhookConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeChimeWebhookConfigurationsPublisher describeChimeWebhookConfigurationsPaginator(
            Consumer<DescribeChimeWebhookConfigurationsRequest.Builder> describeChimeWebhookConfigurationsRequest) {
        return describeChimeWebhookConfigurationsPaginator(DescribeChimeWebhookConfigurationsRequest.builder()
                .applyMutation(describeChimeWebhookConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists Slack channel configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return A Java Future containing the result of the DescribeSlackChannelConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackChannelConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackChannelConfigurationsResponse> describeSlackChannelConfigurations(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Slack channel configurations optionally filtered by ChatConfigurationArn
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSlackChannelConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackChannelConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackChannelConfigurationsResponse> describeSlackChannelConfigurations(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest) {
        return describeSlackChannelConfigurations(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsPublisher publisher = client.describeSlackChannelConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsPublisher publisher = client.describeSlackChannelConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackChannelConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsPublisher describeSlackChannelConfigurationsPaginator(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest) {
        return new DescribeSlackChannelConfigurationsPublisher(this, describeSlackChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsPublisher publisher = client.describeSlackChannelConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackChannelConfigurationsPublisher publisher = client.describeSlackChannelConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackChannelConfigurations(software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackChannelConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackChannelConfigurationsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackChannelConfigurationsPublisher describeSlackChannelConfigurationsPaginator(
            Consumer<DescribeSlackChannelConfigurationsRequest.Builder> describeSlackChannelConfigurationsRequest) {
        return describeSlackChannelConfigurationsPaginator(DescribeSlackChannelConfigurationsRequest.builder()
                .applyMutation(describeSlackChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all Slack user identities with a mapped role.
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return A Java Future containing the result of the DescribeSlackUserIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackUserIdentitiesResponse> describeSlackUserIdentities(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Slack user identities with a mapped role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeSlackUserIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackUserIdentitiesResponse> describeSlackUserIdentities(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest) {
        return describeSlackUserIdentities(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesPublisher publisher = client.describeSlackUserIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesPublisher publisher = client.describeSlackUserIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesPublisher describeSlackUserIdentitiesPaginator(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) {
        return new DescribeSlackUserIdentitiesPublisher(this, describeSlackUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesPublisher publisher = client.describeSlackUserIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackUserIdentitiesPublisher publisher = client.describeSlackUserIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackUserIdentities(software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSlackUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackUserIdentitiesPublisher describeSlackUserIdentitiesPaginator(
            Consumer<DescribeSlackUserIdentitiesRequest.Builder> describeSlackUserIdentitiesRequest) {
        return describeSlackUserIdentitiesPaginator(DescribeSlackUserIdentitiesRequest.builder()
                .applyMutation(describeSlackUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return A Java Future containing the result of the DescribeSlackWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackWorkspacesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackWorkspacesResponse> describeSlackWorkspaces(
            DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSlackWorkspaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackWorkspacesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSlackWorkspacesResponse> describeSlackWorkspaces(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest) {
        return describeSlackWorkspaces(DescribeSlackWorkspacesRequest.builder().applyMutation(describeSlackWorkspacesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesPublisher publisher = client.describeSlackWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesPublisher publisher = client.describeSlackWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackWorkspacesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesPublisher describeSlackWorkspacesPaginator(
            DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest) {
        return new DescribeSlackWorkspacesPublisher(this, describeSlackWorkspacesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesPublisher publisher = client.describeSlackWorkspacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.DescribeSlackWorkspacesPublisher publisher = client.describeSlackWorkspacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSlackWorkspaces(software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlackWorkspacesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSlackWorkspacesRequest#builder()}
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>DescribeSlackWorkspacesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlackWorkspacesPublisher describeSlackWorkspacesPaginator(
            Consumer<DescribeSlackWorkspacesRequest.Builder> describeSlackWorkspacesRequest) {
        return describeSlackWorkspacesPaginator(DescribeSlackWorkspacesRequest.builder()
                .applyMutation(describeSlackWorkspacesRequest).build());
    }

    /**
     * <p>
     * Returns AWS Chatbot account preferences.
     * </p>
     *
     * @param getAccountPreferencesRequest
     * @return A Java Future containing the result of the GetAccountPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>GetAccountPreferencesException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountPreferencesResponse> getAccountPreferences(
            GetAccountPreferencesRequest getAccountPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns AWS Chatbot account preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountPreferencesRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param getAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>GetAccountPreferencesException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAccountPreferencesResponse> getAccountPreferences(
            Consumer<GetAccountPreferencesRequest.Builder> getAccountPreferencesRequest) {
        return getAccountPreferences(GetAccountPreferencesRequest.builder().applyMutation(getAccountPreferencesRequest).build());
    }

    /**
     * <p>
     * Returns a Microsoft Teams channel configuration in an AWS account.
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     * @return A Java Future containing the result of the GetMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>GetTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMicrosoftTeamsChannelConfigurationResponse> getMicrosoftTeamsChannelConfiguration(
            GetMicrosoftTeamsChannelConfigurationRequest getMicrosoftTeamsChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Microsoft Teams channel configuration in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>GetTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMicrosoftTeamsChannelConfigurationResponse> getMicrosoftTeamsChannelConfiguration(
            Consumer<GetMicrosoftTeamsChannelConfigurationRequest.Builder> getMicrosoftTeamsChannelConfigurationRequest) {
        return getMicrosoftTeamsChannelConfiguration(GetMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(getMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return A Java Future containing the result of the ListMicrosoftTeamsChannelConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListTeamsChannelConfigurationsException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsChannelConfigurationsResponse> listMicrosoftTeamsChannelConfigurations(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListMicrosoftTeamsChannelConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListTeamsChannelConfigurationsException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsChannelConfigurationsResponse> listMicrosoftTeamsChannelConfigurations(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest) {
        return listMicrosoftTeamsChannelConfigurations(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsPublisher publisher = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsPublisher publisher = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListTeamsChannelConfigurationsException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsPublisher listMicrosoftTeamsChannelConfigurationsPaginator(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest) {
        return new ListMicrosoftTeamsChannelConfigurationsPublisher(this, listMicrosoftTeamsChannelConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsPublisher publisher = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsChannelConfigurationsPublisher publisher = client.listMicrosoftTeamsChannelConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsChannelConfigurations(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListMicrosoftTeamsChannelConfigurationsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListTeamsChannelConfigurationsException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsChannelConfigurationsPublisher listMicrosoftTeamsChannelConfigurationsPaginator(
            Consumer<ListMicrosoftTeamsChannelConfigurationsRequest.Builder> listMicrosoftTeamsChannelConfigurationsRequest) {
        return listMicrosoftTeamsChannelConfigurationsPaginator(ListMicrosoftTeamsChannelConfigurationsRequest.builder()
                .applyMutation(listMicrosoftTeamsChannelConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all authorized Microsoft Teams for an AWS Account
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return A Java Future containing the result of the ListMicrosoftTeamsConfiguredTeams operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsConfiguredTeamsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsConfiguredTeamsResponse> listMicrosoftTeamsConfiguredTeams(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all authorized Microsoft Teams for an AWS Account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMicrosoftTeamsConfiguredTeams operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsConfiguredTeamsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsConfiguredTeamsResponse> listMicrosoftTeamsConfiguredTeams(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest) {
        return listMicrosoftTeamsConfiguredTeams(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsPublisher publisher = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsPublisher publisher = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsConfiguredTeamsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsPublisher listMicrosoftTeamsConfiguredTeamsPaginator(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest) {
        return new ListMicrosoftTeamsConfiguredTeamsPublisher(this, listMicrosoftTeamsConfiguredTeamsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsPublisher publisher = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsConfiguredTeamsPublisher publisher = client.listMicrosoftTeamsConfiguredTeamsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsConfiguredTeams(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsConfiguredTeamsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsConfiguredTeamsRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsConfiguredTeamsException We can’t process your request right now because of a
     *         server issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsConfiguredTeamsPublisher listMicrosoftTeamsConfiguredTeamsPaginator(
            Consumer<ListMicrosoftTeamsConfiguredTeamsRequest.Builder> listMicrosoftTeamsConfiguredTeamsRequest) {
        return listMicrosoftTeamsConfiguredTeamsPaginator(ListMicrosoftTeamsConfiguredTeamsRequest.builder()
                .applyMutation(listMicrosoftTeamsConfiguredTeamsRequest).build());
    }

    /**
     * <p>
     * A list all Microsoft Teams user identities with a mapped role.
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return A Java Future containing the result of the ListMicrosoftTeamsUserIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsUserIdentitiesResponse> listMicrosoftTeamsUserIdentities(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list all Microsoft Teams user identities with a mapped role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListMicrosoftTeamsUserIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMicrosoftTeamsUserIdentitiesResponse> listMicrosoftTeamsUserIdentities(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest) {
        return listMicrosoftTeamsUserIdentities(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesPublisher publisher = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesPublisher publisher = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesPublisher listMicrosoftTeamsUserIdentitiesPaginator(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest) {
        return new ListMicrosoftTeamsUserIdentitiesPublisher(this, listMicrosoftTeamsUserIdentitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesPublisher publisher = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chatbot.paginators.ListMicrosoftTeamsUserIdentitiesPublisher publisher = client.listMicrosoftTeamsUserIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMicrosoftTeamsUserIdentities(software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMicrosoftTeamsUserIdentitiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMicrosoftTeamsUserIdentitiesRequest#builder()}
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ListMicrosoftTeamsUserIdentitiesException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMicrosoftTeamsUserIdentitiesPublisher listMicrosoftTeamsUserIdentitiesPaginator(
            Consumer<ListMicrosoftTeamsUserIdentitiesRequest.Builder> listMicrosoftTeamsUserIdentitiesRequest) {
        return listMicrosoftTeamsUserIdentitiesPaginator(ListMicrosoftTeamsUserIdentitiesRequest.builder()
                .applyMutation(listMicrosoftTeamsUserIdentitiesRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>TooManyTagsException The supplied list of tags contains too many tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>TooManyTagsException The supplied list of tags contains too many tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceUnavailableException We can’t process your request right now because of a server issue. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>InternalServiceErrorException Unexpected error during processing of request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates AWS Chatbot account preferences.
     * </p>
     *
     * @param updateAccountPreferencesRequest
     * @return A Java Future containing the result of the UpdateAccountPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>UpdateAccountPreferencesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountPreferencesResponse> updateAccountPreferences(
            UpdateAccountPreferencesRequest updateAccountPreferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates AWS Chatbot account preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountPreferencesRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAccountPreferencesRequest#builder()}
     * </p>
     *
     * @param updateAccountPreferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAccountPreferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>UpdateAccountPreferencesException We can’t process your request right now because of a server issue.
     *         Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountPreferencesResponse> updateAccountPreferences(
            Consumer<UpdateAccountPreferencesRequest.Builder> updateAccountPreferencesRequest) {
        return updateAccountPreferences(UpdateAccountPreferencesRequest.builder().applyMutation(updateAccountPreferencesRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Amazon Chime webhook configuration.
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     * @return A Java Future containing the result of the UpdateChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>UpdateChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChimeWebhookConfigurationResponse> updateChimeWebhookConfiguration(
            UpdateChimeWebhookConfigurationRequest updateChimeWebhookConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Amazon Chime webhook configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChimeWebhookConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateChimeWebhookConfigurationRequest#builder()}
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateChimeWebhookConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>UpdateChimeWebhookConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateChimeWebhookConfigurationResponse> updateChimeWebhookConfiguration(
            Consumer<UpdateChimeWebhookConfigurationRequest.Builder> updateChimeWebhookConfigurationRequest) {
        return updateChimeWebhookConfiguration(UpdateChimeWebhookConfigurationRequest.builder()
                .applyMutation(updateChimeWebhookConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an Microsoft Teams channel configuration.
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     * @return A Java Future containing the result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>UpdateTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMicrosoftTeamsChannelConfigurationResponse> updateMicrosoftTeamsChannelConfiguration(
            UpdateMicrosoftTeamsChannelConfigurationRequest updateMicrosoftTeamsChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Microsoft Teams channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateMicrosoftTeamsChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>UpdateTeamsChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMicrosoftTeamsChannelConfigurationResponse> updateMicrosoftTeamsChannelConfiguration(
            Consumer<UpdateMicrosoftTeamsChannelConfigurationRequest.Builder> updateMicrosoftTeamsChannelConfigurationRequest) {
        return updateMicrosoftTeamsChannelConfiguration(UpdateMicrosoftTeamsChannelConfigurationRequest.builder()
                .applyMutation(updateMicrosoftTeamsChannelConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Slack channel configuration.
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     * @return A Java Future containing the result of the UpdateSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>UpdateSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSlackChannelConfigurationResponse> updateSlackChannelConfiguration(
            UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Slack channel configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlackChannelConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSlackChannelConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSlackChannelConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>InvalidRequestException Your request input doesn't meet the constraints required by AWS Chatbot.</li>
     *         <li>ResourceNotFoundException We were unable to find the resource for your request</li>
     *         <li>UpdateSlackChannelConfigurationException We can’t process your request right now because of a server
     *         issue. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChatbotException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChatbotAsyncClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSlackChannelConfigurationResponse> updateSlackChannelConfiguration(
            Consumer<UpdateSlackChannelConfigurationRequest.Builder> updateSlackChannelConfigurationRequest) {
        return updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.builder()
                .applyMutation(updateSlackChannelConfigurationRequest).build());
    }

    @Override
    default ChatbotServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ChatbotAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChatbotAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChatbotAsyncClient}.
     */
    static ChatbotAsyncClientBuilder builder() {
        return new DefaultChatbotAsyncClientBuilder();
    }
}
