/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines when a custom action button should be attached to a notification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionAttachment.Builder, CustomActionAttachment> {
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationType").getter(getter(CustomActionAttachment::notificationType))
            .setter(setter(Builder::notificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()).build();

    private static final SdkField<String> BUTTON_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ButtonText").getter(getter(CustomActionAttachment::buttonText)).setter(setter(Builder::buttonText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ButtonText").build()).build();

    private static final SdkField<List<CustomActionAttachmentCriteria>> CRITERIA_FIELD = SdkField
            .<List<CustomActionAttachmentCriteria>> builder(MarshallingType.LIST)
            .memberName("Criteria")
            .getter(getter(CustomActionAttachment::criteria))
            .setter(setter(Builder::criteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomActionAttachmentCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomActionAttachmentCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Variables")
            .getter(getter(CustomActionAttachment::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_TYPE_FIELD,
            BUTTON_TEXT_FIELD, CRITERIA_FIELD, VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NotificationType", NOTIFICATION_TYPE_FIELD);
                    put("ButtonText", BUTTON_TEXT_FIELD);
                    put("Criteria", CRITERIA_FIELD);
                    put("Variables", VARIABLES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String notificationType;

    private final String buttonText;

    private final List<CustomActionAttachmentCriteria> criteria;

    private final Map<String, String> variables;

    private CustomActionAttachment(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.buttonText = builder.buttonText;
        this.criteria = builder.criteria;
        this.variables = builder.variables;
    }

    /**
     * <p>
     * The type of notification that the custom action should be attached to.
     * </p>
     * 
     * @return The type of notification that the custom action should be attached to.
     */
    public final String notificationType() {
        return notificationType;
    }

    /**
     * <p>
     * The text of the button that appears on the notification.
     * </p>
     * 
     * @return The text of the button that appears on the notification.
     */
    public final String buttonText() {
        return buttonText;
    }

    /**
     * For responses, this returns true if the service returned a value for the Criteria property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCriteria() {
        return criteria != null && !(criteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria for when a button should be shown based on values in the notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCriteria} method.
     * </p>
     * 
     * @return The criteria for when a button should be shown based on values in the notification.
     */
    public final List<CustomActionAttachmentCriteria> criteria() {
        return criteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The variables to extract from the notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The variables to extract from the notification.
     */
    public final Map<String, String> variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationType());
        hashCode = 31 * hashCode + Objects.hashCode(buttonText());
        hashCode = 31 * hashCode + Objects.hashCode(hasCriteria() ? criteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionAttachment)) {
            return false;
        }
        CustomActionAttachment other = (CustomActionAttachment) obj;
        return Objects.equals(notificationType(), other.notificationType()) && Objects.equals(buttonText(), other.buttonText())
                && hasCriteria() == other.hasCriteria() && Objects.equals(criteria(), other.criteria())
                && hasVariables() == other.hasVariables() && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionAttachment").add("NotificationType", notificationType())
                .add("ButtonText", buttonText()).add("Criteria", hasCriteria() ? criteria() : null)
                .add("Variables", hasVariables() ? variables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationType":
            return Optional.ofNullable(clazz.cast(notificationType()));
        case "ButtonText":
            return Optional.ofNullable(clazz.cast(buttonText()));
        case "Criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "Variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomActionAttachment, T> g) {
        return obj -> g.apply((CustomActionAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionAttachment> {
        /**
         * <p>
         * The type of notification that the custom action should be attached to.
         * </p>
         * 
         * @param notificationType
         *        The type of notification that the custom action should be attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationType(String notificationType);

        /**
         * <p>
         * The text of the button that appears on the notification.
         * </p>
         * 
         * @param buttonText
         *        The text of the button that appears on the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buttonText(String buttonText);

        /**
         * <p>
         * The criteria for when a button should be shown based on values in the notification.
         * </p>
         * 
         * @param criteria
         *        The criteria for when a button should be shown based on values in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(Collection<CustomActionAttachmentCriteria> criteria);

        /**
         * <p>
         * The criteria for when a button should be shown based on values in the notification.
         * </p>
         * 
         * @param criteria
         *        The criteria for when a button should be shown based on values in the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(CustomActionAttachmentCriteria... criteria);

        /**
         * <p>
         * The criteria for when a button should be shown based on values in the notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentCriteria.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentCriteria.Builder#build()} is
         * called immediately and its result is passed to {@link #criteria(List<CustomActionAttachmentCriteria>)}.
         * 
         * @param criteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachmentCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(java.util.Collection<CustomActionAttachmentCriteria>)
         */
        Builder criteria(Consumer<CustomActionAttachmentCriteria.Builder>... criteria);

        /**
         * <p>
         * The variables to extract from the notification.
         * </p>
         * 
         * @param variables
         *        The variables to extract from the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Map<String, String> variables);
    }

    static final class BuilderImpl implements Builder {
        private String notificationType;

        private String buttonText;

        private List<CustomActionAttachmentCriteria> criteria = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionAttachment model) {
            notificationType(model.notificationType);
            buttonText(model.buttonText);
            criteria(model.criteria);
            variables(model.variables);
        }

        public final String getNotificationType() {
            return notificationType;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public final String getButtonText() {
            return buttonText;
        }

        public final void setButtonText(String buttonText) {
            this.buttonText = buttonText;
        }

        @Override
        public final Builder buttonText(String buttonText) {
            this.buttonText = buttonText;
            return this;
        }

        public final List<CustomActionAttachmentCriteria.Builder> getCriteria() {
            List<CustomActionAttachmentCriteria.Builder> result = CustomActionAttachmentCriteriaListCopier
                    .copyToBuilder(this.criteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCriteria(Collection<CustomActionAttachmentCriteria.BuilderImpl> criteria) {
            this.criteria = CustomActionAttachmentCriteriaListCopier.copyFromBuilder(criteria);
        }

        @Override
        public final Builder criteria(Collection<CustomActionAttachmentCriteria> criteria) {
            this.criteria = CustomActionAttachmentCriteriaListCopier.copy(criteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(CustomActionAttachmentCriteria... criteria) {
            criteria(Arrays.asList(criteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(Consumer<CustomActionAttachmentCriteria.Builder>... criteria) {
            criteria(Stream.of(criteria).map(c -> CustomActionAttachmentCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getVariables() {
            if (variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = CustomActionAttachmentVariablesCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = CustomActionAttachmentVariablesCopier.copy(variables);
            return this;
        }

        @Override
        public CustomActionAttachment build() {
            return new CustomActionAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
