/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomActionResponse extends ChatbotResponse implements
        ToCopyableBuilder<GetCustomActionResponse.Builder, GetCustomActionResponse> {
    private static final SdkField<CustomAction> CUSTOM_ACTION_FIELD = SdkField.<CustomAction> builder(MarshallingType.SDK_POJO)
            .memberName("CustomAction").getter(getter(GetCustomActionResponse::customAction))
            .setter(setter(Builder::customAction)).constructor(CustomAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CustomAction", CUSTOM_ACTION_FIELD);
                }
            });

    private final CustomAction customAction;

    private GetCustomActionResponse(BuilderImpl builder) {
        super(builder);
        this.customAction = builder.customAction;
    }

    /**
     * <p>
     * Returns the custom action.
     * </p>
     * 
     * @return Returns the custom action.
     */
    public final CustomAction customAction() {
        return customAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomActionResponse)) {
            return false;
        }
        GetCustomActionResponse other = (GetCustomActionResponse) obj;
        return Objects.equals(customAction(), other.customAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomActionResponse").add("CustomAction", customAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAction":
            return Optional.ofNullable(clazz.cast(customAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomActionResponse, T> g) {
        return obj -> g.apply((GetCustomActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomActionResponse> {
        /**
         * <p>
         * Returns the custom action.
         * </p>
         * 
         * @param customAction
         *        Returns the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAction(CustomAction customAction);

        /**
         * <p>
         * Returns the custom action.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomAction.Builder} avoiding the need
         * to create one manually via {@link CustomAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomAction.Builder#build()} is called immediately and its
         * result is passed to {@link #customAction(CustomAction)}.
         * 
         * @param customAction
         *        a consumer that will call methods on {@link CustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAction(CustomAction)
         */
        default Builder customAction(Consumer<CustomAction.Builder> customAction) {
            return customAction(CustomAction.builder().applyMutation(customAction).build());
        }
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private CustomAction customAction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomActionResponse model) {
            super(model);
            customAction(model.customAction);
        }

        public final CustomAction.Builder getCustomAction() {
            return customAction != null ? customAction.toBuilder() : null;
        }

        public final void setCustomAction(CustomAction.BuilderImpl customAction) {
            this.customAction = customAction != null ? customAction.build() : null;
        }

        @Override
        public final Builder customAction(CustomAction customAction) {
            this.customAction = customAction;
            return this;
        }

        @Override
        public GetCustomActionResponse build() {
            return new GetCustomActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
