/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomActionsResponse extends ChatbotResponse implements
        ToCopyableBuilder<ListCustomActionsResponse.Builder, ListCustomActionsResponse> {
    private static final SdkField<List<String>> CUSTOM_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomActions")
            .getter(getter(ListCustomActionsResponse::customActions))
            .setter(setter(Builder::customActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomActionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CustomActions", CUSTOM_ACTIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> customActions;

    private final String nextToken;

    private ListCustomActionsResponse(BuilderImpl builder) {
        super(builder);
        this.customActions = builder.customActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomActions() {
        return customActions != null && !(customActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomActions} method.
     * </p>
     * 
     * @return A list of custom actions.
     */
    public final List<String> customActions() {
        return customActions;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomActions() ? customActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomActionsResponse)) {
            return false;
        }
        ListCustomActionsResponse other = (ListCustomActionsResponse) obj;
        return hasCustomActions() == other.hasCustomActions() && Objects.equals(customActions(), other.customActions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomActionsResponse").add("CustomActions", hasCustomActions() ? customActions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomActions":
            return Optional.ofNullable(clazz.cast(customActions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomActionsResponse, T> g) {
        return obj -> g.apply((ListCustomActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCustomActionsResponse> {
        /**
         * <p>
         * A list of custom actions.
         * </p>
         * 
         * @param customActions
         *        A list of custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(Collection<String> customActions);

        /**
         * <p>
         * A list of custom actions.
         * </p>
         * 
         * @param customActions
         *        A list of custom actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActions(String... customActions);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChatbotResponse.BuilderImpl implements Builder {
        private List<String> customActions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomActionsResponse model) {
            super(model);
            customActions(model.customActions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getCustomActions() {
            if (customActions instanceof SdkAutoConstructList) {
                return null;
            }
            return customActions;
        }

        public final void setCustomActions(Collection<String> customActions) {
            this.customActions = CustomActionArnListCopier.copy(customActions);
        }

        @Override
        public final Builder customActions(Collection<String> customActions) {
            this.customActions = CustomActionArnListCopier.copy(customActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customActions(String... customActions) {
            customActions(Arrays.asList(customActions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomActionsResponse build() {
            return new ListCustomActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
