/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateToConfigurationRequest extends ChatbotRequest implements
        ToCopyableBuilder<AssociateToConfigurationRequest.Builder, AssociateToConfigurationRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resource").getter(getter(AssociateToConfigurationRequest::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<String> CHAT_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfiguration").getter(getter(AssociateToConfigurationRequest::chatConfiguration))
            .setter(setter(Builder::chatConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            CHAT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resource;

    private final String chatConfiguration;

    private AssociateToConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.chatConfiguration = builder.chatConfiguration;
    }

    /**
     * <p>
     * The resource Amazon Resource Name (ARN) to link.
     * </p>
     * 
     * @return The resource Amazon Resource Name (ARN) to link.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The channel configuration to associate with the resource.
     * </p>
     * 
     * @return The channel configuration to associate with the resource.
     */
    public final String chatConfiguration() {
        return chatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(chatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateToConfigurationRequest)) {
            return false;
        }
        AssociateToConfigurationRequest other = (AssociateToConfigurationRequest) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(chatConfiguration(), other.chatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateToConfigurationRequest").add("Resource", resource())
                .add("ChatConfiguration", chatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "ChatConfiguration":
            return Optional.ofNullable(clazz.cast(chatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Resource", RESOURCE_FIELD);
        map.put("ChatConfiguration", CHAT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateToConfigurationRequest, T> g) {
        return obj -> g.apply((AssociateToConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateToConfigurationRequest> {
        /**
         * <p>
         * The resource Amazon Resource Name (ARN) to link.
         * </p>
         * 
         * @param resource
         *        The resource Amazon Resource Name (ARN) to link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The channel configuration to associate with the resource.
         * </p>
         * 
         * @param chatConfiguration
         *        The channel configuration to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfiguration(String chatConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChatbotRequest.BuilderImpl implements Builder {
        private String resource;

        private String chatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateToConfigurationRequest model) {
            super(model);
            resource(model.resource);
            chatConfiguration(model.chatConfiguration);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getChatConfiguration() {
            return chatConfiguration;
        }

        public final void setChatConfiguration(String chatConfiguration) {
            this.chatConfiguration = chatConfiguration;
        }

        @Override
        public final Builder chatConfiguration(String chatConfiguration) {
            this.chatConfiguration = chatConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateToConfigurationRequest build() {
            return new AssociateToConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
