/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the command to run when invoked as an alias or as an action button.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionDefinition.Builder, CustomActionDefinition> {
    private static final SdkField<String> COMMAND_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommandText").getter(getter(CustomActionDefinition::commandText)).setter(setter(Builder::commandText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commandText;

    private CustomActionDefinition(BuilderImpl builder) {
        this.commandText = builder.commandText;
    }

    /**
     * <p>
     * The command string to run which may include variables by prefixing with a dollar sign ($).
     * </p>
     * 
     * @return The command string to run which may include variables by prefixing with a dollar sign ($).
     */
    public final String commandText() {
        return commandText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionDefinition)) {
            return false;
        }
        CustomActionDefinition other = (CustomActionDefinition) obj;
        return Objects.equals(commandText(), other.commandText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionDefinition").add("CommandText", commandText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandText":
            return Optional.ofNullable(clazz.cast(commandText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CommandText", COMMAND_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomActionDefinition, T> g) {
        return obj -> g.apply((CustomActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionDefinition> {
        /**
         * <p>
         * The command string to run which may include variables by prefixing with a dollar sign ($).
         * </p>
         * 
         * @param commandText
         *        The command string to run which may include variables by prefixing with a dollar sign ($).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandText(String commandText);
    }

    static final class BuilderImpl implements Builder {
        private String commandText;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionDefinition model) {
            commandText(model.commandText);
        }

        public final String getCommandText() {
            return commandText;
        }

        public final void setCommandText(String commandText) {
            this.commandText = commandText;
        }

        @Override
        public final Builder commandText(String commandText) {
            this.commandText = commandText;
            return this;
        }

        @Override
        public CustomActionDefinition build() {
            return new CustomActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
