/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMicrosoftTeamsConfiguredTeamRequest extends ChatbotRequest implements
        ToCopyableBuilder<DeleteMicrosoftTeamsConfiguredTeamRequest.Builder, DeleteMicrosoftTeamsConfiguredTeamRequest> {
    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(DeleteMicrosoftTeamsConfiguredTeamRequest::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String teamId;

    private DeleteMicrosoftTeamsConfiguredTeamRequest(BuilderImpl builder) {
        super(builder);
        this.teamId = builder.teamId;
    }

    /**
     * <p>
     * The ID of the Microsoft Teams team authorized with AWS Chatbot.
     * </p>
     * <p>
     * To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
     * console. Then you can copy and paste the team ID from the console. For more information, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
     * Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
     * </p>
     * 
     * @return The ID of the Microsoft Teams team authorized with AWS Chatbot.</p>
     *         <p>
     *         To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS
     *         Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
     *         Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
     */
    public final String teamId() {
        return teamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMicrosoftTeamsConfiguredTeamRequest)) {
            return false;
        }
        DeleteMicrosoftTeamsConfiguredTeamRequest other = (DeleteMicrosoftTeamsConfiguredTeamRequest) obj;
        return Objects.equals(teamId(), other.teamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMicrosoftTeamsConfiguredTeamRequest").add("TeamId", teamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TeamId", TEAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMicrosoftTeamsConfiguredTeamRequest, T> g) {
        return obj -> g.apply((DeleteMicrosoftTeamsConfiguredTeamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChatbotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteMicrosoftTeamsConfiguredTeamRequest> {
        /**
         * <p>
         * The ID of the Microsoft Teams team authorized with AWS Chatbot.
         * </p>
         * <p>
         * To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
         * console. Then you can copy and paste the team ID from the console. For more information, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
         * Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * </p>
         * 
         * @param teamId
         *        The ID of the Microsoft Teams team authorized with AWS Chatbot.</p>
         *        <p>
         *        To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS
         *        Chatbot console. Then you can copy and paste the team ID from the console. For more information, see
         *        <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">
         *        Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChatbotRequest.BuilderImpl implements Builder {
        private String teamId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMicrosoftTeamsConfiguredTeamRequest model) {
            super(model);
            teamId(model.teamId);
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMicrosoftTeamsConfiguredTeamRequest build() {
            return new DeleteMicrosoftTeamsConfiguredTeamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
