/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.ConstructorCache;
import software.amazon.awssdk.checksums.internal.CrcCloneOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.CrcCombineOnMarkChecksum;
import software.amazon.awssdk.checksums.internal.SdkCrc32CChecksum;
import software.amazon.awssdk.crt.checksums.CRC32C;

@SdkInternalApi
public final class Crc32cProvider {
    private static final String CRT_CRC32C_CLASS_PATH = "software.amazon.awssdk.crt.checksums.CRC32C";
    private static final String JAVA_CRC32C_CLASS_PATH = "java.util.zip.CRC32C";
    private static final ConstructorCache CONSTRUCTOR_CACHE = new ConstructorCache();

    private Crc32cProvider() {
    }

    static SdkChecksum createSdkBasedCrc32C() {
        SdkCrc32CChecksum sdkChecksum = SdkCrc32CChecksum.create();
        return new CrcCloneOnMarkChecksum(sdkChecksum, checksumToClone -> ((SdkCrc32CChecksum)checksumToClone).clone());
    }

    public static SdkChecksum create() {
        SdkChecksum checksum = Crc32cProvider.createJavaCrc32C();
        if (checksum == null) {
            checksum = Crc32cProvider.createCrtCrc32C();
        }
        return checksum != null ? checksum : Crc32cProvider.createSdkBasedCrc32C();
    }

    static SdkChecksum createCrtCrc32C() {
        return CONSTRUCTOR_CACHE.getConstructor(CRT_CRC32C_CLASS_PATH).map(constructor -> {
            try {
                return new CrcCloneOnMarkChecksum((Checksum)constructor.newInstance(new Object[0]), checksumToClone -> (Checksum)((CRC32C)checksumToClone).clone());
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate java.util.zip.CRC32C", e);
            }
        }).orElse(null);
    }

    static SdkChecksum createJavaCrc32C() {
        return CONSTRUCTOR_CACHE.getConstructor(JAVA_CRC32C_CLASS_PATH).map(constructor -> {
            try {
                return new CrcCombineOnMarkChecksum((Checksum)constructor.newInstance(new Object[0]), SdkCrc32CChecksum::combine);
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate java.util.zip.CRC32C", e);
            }
        }).orElse(null);
    }
}

