/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings related to the Amazon Chime account. This includes settings that start or stop remote control of shared
 * screens, or start or stop the dial-out option in the Amazon Chime web application. For more information about these
 * settings, see <a href="https://docs.aws.amazon.com/chime/latest/ag/policies.html">Use the Policies Page</a> in the
 * <i>Amazon Chime Administration Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<Boolean> DISABLE_REMOTE_CONTROL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableRemoteControl").getter(getter(AccountSettings::disableRemoteControl))
            .setter(setter(Builder::disableRemoteControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRemoteControl").build())
            .build();

    private static final SdkField<Boolean> ENABLE_DIAL_OUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDialOut").getter(getter(AccountSettings::enableDialOut)).setter(setter(Builder::enableDialOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDialOut").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_REMOTE_CONTROL_FIELD,
            ENABLE_DIAL_OUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disableRemoteControl;

    private final Boolean enableDialOut;

    private AccountSettings(BuilderImpl builder) {
        this.disableRemoteControl = builder.disableRemoteControl;
        this.enableDialOut = builder.enableDialOut;
    }

    /**
     * <p>
     * Setting that stops or starts remote control of shared screens during meetings.
     * </p>
     * 
     * @return Setting that stops or starts remote control of shared screens during meetings.
     */
    public final Boolean disableRemoteControl() {
        return disableRemoteControl;
    }

    /**
     * <p>
     * Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more
     * information, see <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting
     * without the Amazon Chime App</a>.
     * </p>
     * 
     * @return Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more
     *         information, see <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a
     *         Meeting without the Amazon Chime App</a>.
     */
    public final Boolean enableDialOut() {
        return enableDialOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableRemoteControl());
        hashCode = 31 * hashCode + Objects.hashCode(enableDialOut());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(disableRemoteControl(), other.disableRemoteControl())
                && Objects.equals(enableDialOut(), other.enableDialOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettings").add("DisableRemoteControl", disableRemoteControl())
                .add("EnableDialOut", enableDialOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableRemoteControl":
            return Optional.ofNullable(clazz.cast(disableRemoteControl()));
        case "EnableDialOut":
            return Optional.ofNullable(clazz.cast(enableDialOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * Setting that stops or starts remote control of shared screens during meetings.
         * </p>
         * 
         * @param disableRemoteControl
         *        Setting that stops or starts remote control of shared screens during meetings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRemoteControl(Boolean disableRemoteControl);

        /**
         * <p>
         * Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For more
         * information, see <a href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting
         * without the Amazon Chime App</a>.
         * </p>
         * 
         * @param enableDialOut
         *        Setting that allows meeting participants to choose the <b>Call me at a phone number</b> option. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html">Join a Meeting without the
         *        Amazon Chime App</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDialOut(Boolean enableDialOut);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableRemoteControl;

        private Boolean enableDialOut;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            disableRemoteControl(model.disableRemoteControl);
            enableDialOut(model.enableDialOut);
        }

        public final Boolean getDisableRemoteControl() {
            return disableRemoteControl;
        }

        @Override
        public final Builder disableRemoteControl(Boolean disableRemoteControl) {
            this.disableRemoteControl = disableRemoteControl;
            return this;
        }

        public final void setDisableRemoteControl(Boolean disableRemoteControl) {
            this.disableRemoteControl = disableRemoteControl;
        }

        public final Boolean getEnableDialOut() {
            return enableDialOut;
        }

        @Override
        public final Builder enableDialOut(Boolean enableDialOut) {
            this.enableDialOut = enableDialOut;
            return this;
        }

        public final void setEnableDialOut(Boolean enableDialOut) {
            this.enableDialOut = enableDialOut;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
