/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an <code>AppInstanceUser</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceUser implements SdkPojo, Serializable, ToCopyableBuilder<AppInstanceUser.Builder, AppInstanceUser> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(AppInstanceUser::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUserArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppInstanceUser::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AppInstanceUser::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(AppInstanceUser::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(AppInstanceUser::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            NAME_FIELD, CREATED_TIMESTAMP_FIELD, METADATA_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appInstanceUserArn;

    private final String name;

    private final Instant createdTimestamp;

    private final String metadata;

    private final Instant lastUpdatedTimestamp;

    private AppInstanceUser(BuilderImpl builder) {
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.name = builder.name;
        this.createdTimestamp = builder.createdTimestamp;
        this.metadata = builder.metadata;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code>.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The name of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The name of the <code>AppInstanceUser</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the <code>AppInstanceUser</code> was created.
     * </p>
     * 
     * @return The time at which the <code>AppInstanceUser</code> was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The metadata of the <code>AppInstanceUser</code>.
     * </p>
     * 
     * @return The metadata of the <code>AppInstanceUser</code>.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The time at which the <code>AppInstanceUser</code> was last updated.
     * </p>
     * 
     * @return The time at which the <code>AppInstanceUser</code> was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceUser)) {
            return false;
        }
        AppInstanceUser other = (AppInstanceUser) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(name(), other.name())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceUser").add("AppInstanceUserArn", appInstanceUserArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedTimestamp", createdTimestamp())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceUser, T> g) {
        return obj -> g.apply((AppInstanceUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceUser> {
        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The name of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the <code>AppInstanceUser</code> was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the <code>AppInstanceUser</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The metadata of the <code>AppInstanceUser</code>.
         * </p>
         * 
         * @param metadata
         *        The metadata of the <code>AppInstanceUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The time at which the <code>AppInstanceUser</code> was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which the <code>AppInstanceUser</code> was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private String name;

        private Instant createdTimestamp;

        private String metadata;

        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceUser model) {
            appInstanceUserArn(model.appInstanceUserArn);
            name(model.name);
            createdTimestamp(model.createdTimestamp);
            metadata(model.metadata);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final String getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public AppInstanceUser build() {
            return new AppInstanceUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
