/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The membership information, including member ARNs, the channel ARN, and membership types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchChannelMemberships implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchChannelMemberships.Builder, BatchChannelMemberships> {
    private static final SdkField<Identity> INVITED_BY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("InvitedBy").getter(getter(BatchChannelMemberships::invitedBy)).setter(setter(Builder::invitedBy))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(BatchChannelMemberships::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Identity>> MEMBERS_FIELD = SdkField
            .<List<Identity>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(BatchChannelMemberships::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Identity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Identity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(BatchChannelMemberships::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITED_BY_FIELD, TYPE_FIELD,
            MEMBERS_FIELD, CHANNEL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity invitedBy;

    private final String type;

    private final List<Identity> members;

    private final String channelArn;

    private BatchChannelMemberships(BuilderImpl builder) {
        this.invitedBy = builder.invitedBy;
        this.type = builder.type;
        this.members = builder.members;
        this.channelArn = builder.channelArn;
    }

    /**
     * Returns the value of the InvitedBy property for this object.
     * 
     * @return The value of the InvitedBy property for this object.
     */
    public final Identity invitedBy() {
        return invitedBy;
    }

    /**
     * <p>
     * The membership types set for the channel users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership types set for the channel users.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The membership types set for the channel users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership types set for the channel users.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns true if the Members property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users successfully added to the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The users successfully added to the request.
     */
    public final List<Identity> members() {
        return members;
    }

    /**
     * <p>
     * The ARN of the channel to which you're adding users.
     * </p>
     * 
     * @return The ARN of the channel to which you're adding users.
     */
    public final String channelArn() {
        return channelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchChannelMemberships)) {
            return false;
        }
        BatchChannelMemberships other = (BatchChannelMemberships) obj;
        return Objects.equals(invitedBy(), other.invitedBy()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && Objects.equals(channelArn(), other.channelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchChannelMemberships").add("InvitedBy", invitedBy()).add("Type", typeAsString())
                .add("Members", hasMembers() ? members() : null).add("ChannelArn", channelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvitedBy":
            return Optional.ofNullable(clazz.cast(invitedBy()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchChannelMemberships, T> g) {
        return obj -> g.apply((BatchChannelMemberships) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchChannelMemberships> {
        /**
         * Sets the value of the InvitedBy property for this object.
         *
         * @param invitedBy
         *        The new value for the InvitedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedBy(Identity invitedBy);

        /**
         * Sets the value of the InvitedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #invitedBy(Identity)}.
         * 
         * @param invitedBy
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitedBy(Identity)
         */
        default Builder invitedBy(Consumer<Identity.Builder> invitedBy) {
            return invitedBy(Identity.builder().applyMutation(invitedBy).build());
        }

        /**
         * <p>
         * The membership types set for the channel users.
         * </p>
         * 
         * @param type
         *        The membership types set for the channel users.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The membership types set for the channel users.
         * </p>
         * 
         * @param type
         *        The membership types set for the channel users.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The users successfully added to the request.
         * </p>
         * 
         * @param members
         *        The users successfully added to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<Identity> members);

        /**
         * <p>
         * The users successfully added to the request.
         * </p>
         * 
         * @param members
         *        The users successfully added to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Identity... members);

        /**
         * <p>
         * The users successfully added to the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Identity>.Builder} avoiding the need to
         * create one manually via {@link List<Identity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Identity>.Builder#build()} is called immediately and its
         * result is passed to {@link #members(List<Identity>)}.
         * 
         * @param members
         *        a consumer that will call methods on {@link List<Identity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(List<Identity>)
         */
        Builder members(Consumer<Identity.Builder>... members);

        /**
         * <p>
         * The ARN of the channel to which you're adding users.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel to which you're adding users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);
    }

    static final class BuilderImpl implements Builder {
        private Identity invitedBy;

        private String type;

        private List<Identity> members = DefaultSdkAutoConstructList.getInstance();

        private String channelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchChannelMemberships model) {
            invitedBy(model.invitedBy);
            type(model.type);
            members(model.members);
            channelArn(model.channelArn);
        }

        public final Identity.Builder getInvitedBy() {
            return invitedBy != null ? invitedBy.toBuilder() : null;
        }

        @Override
        public final Builder invitedBy(Identity invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final void setInvitedBy(Identity.BuilderImpl invitedBy) {
            this.invitedBy = invitedBy != null ? invitedBy.build() : null;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final List<Identity.Builder> getMembers() {
            List<Identity.Builder> result = MembersCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder members(Collection<Identity> members) {
            this.members = MembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Identity... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Identity.Builder>... members) {
            members(Stream.of(members).map(c -> Identity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<Identity.BuilderImpl> members) {
            this.members = MembersCopier.copyFromBuilder(members);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public BatchChannelMemberships build() {
            return new BatchChannelMemberships(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
