/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateAttendeeResponse extends ChimeResponse implements
        ToCopyableBuilder<BatchCreateAttendeeResponse.Builder, BatchCreateAttendeeResponse> {
    private static final SdkField<List<Attendee>> ATTENDEES_FIELD = SdkField
            .<List<Attendee>> builder(MarshallingType.LIST)
            .memberName("Attendees")
            .getter(getter(BatchCreateAttendeeResponse::attendees))
            .setter(setter(Builder::attendees))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attendee> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attendee::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CreateAttendeeError>> ERRORS_FIELD = SdkField
            .<List<CreateAttendeeError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchCreateAttendeeResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAttendeeError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAttendeeError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ATTENDEES_FIELD, ERRORS_FIELD));

    private final List<Attendee> attendees;

    private final List<CreateAttendeeError> errors;

    private BatchCreateAttendeeResponse(BuilderImpl builder) {
        super(builder);
        this.attendees = builder.attendees;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the Attendees property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttendees() {
        return attendees != null && !(attendees instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attendee information, including attendees IDs and join tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttendees()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attendee information, including attendees IDs and join tokens.
     */
    public final List<Attendee> attendees() {
        return attendees;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along
     * with error codes and error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
     *         along with error codes and error messages.
     */
    public final List<CreateAttendeeError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendees() ? attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateAttendeeResponse)) {
            return false;
        }
        BatchCreateAttendeeResponse other = (BatchCreateAttendeeResponse) obj;
        return hasAttendees() == other.hasAttendees() && Objects.equals(attendees(), other.attendees())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateAttendeeResponse").add("Attendees", hasAttendees() ? attendees() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attendees":
            return Optional.ofNullable(clazz.cast(attendees()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateAttendeeResponse, T> g) {
        return obj -> g.apply((BatchCreateAttendeeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateAttendeeResponse> {
        /**
         * <p>
         * The attendee information, including attendees IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Collection<Attendee> attendees);

        /**
         * <p>
         * The attendee information, including attendees IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Attendee... attendees);

        /**
         * <p>
         * The attendee information, including attendees IDs and join tokens.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attendee>.Builder} avoiding the need to
         * create one manually via {@link List<Attendee>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attendee>.Builder#build()} is called immediately and its
         * result is passed to {@link #attendees(List<Attendee>)}.
         * 
         * @param attendees
         *        a consumer that will call methods on {@link List<Attendee>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendees(List<Attendee>)
         */
        Builder attendees(Consumer<Attendee.Builder>... attendees);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * 
         * @param errors
         *        If the action fails for one or more of the attendees in the request, a list of the attendees is
         *        returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<CreateAttendeeError> errors);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * 
         * @param errors
         *        If the action fails for one or more of the attendees in the request, a list of the attendees is
         *        returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(CreateAttendeeError... errors);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateAttendeeError>.Builder} avoiding the
         * need to create one manually via {@link List<CreateAttendeeError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAttendeeError>.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<CreateAttendeeError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<CreateAttendeeError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<CreateAttendeeError>)
         */
        Builder errors(Consumer<CreateAttendeeError.Builder>... errors);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<Attendee> attendees = DefaultSdkAutoConstructList.getInstance();

        private List<CreateAttendeeError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateAttendeeResponse model) {
            super(model);
            attendees(model.attendees);
            errors(model.errors);
        }

        public final List<Attendee.Builder> getAttendees() {
            List<Attendee.Builder> result = AttendeeListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attendees(Collection<Attendee> attendees) {
            this.attendees = AttendeeListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Attendee... attendees) {
            attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<Attendee.Builder>... attendees) {
            attendees(Stream.of(attendees).map(c -> Attendee.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttendees(Collection<Attendee.BuilderImpl> attendees) {
            this.attendees = AttendeeListCopier.copyFromBuilder(attendees);
        }

        public final List<CreateAttendeeError.Builder> getErrors() {
            List<CreateAttendeeError.Builder> result = BatchCreateAttendeeErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<CreateAttendeeError> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CreateAttendeeError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CreateAttendeeError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> CreateAttendeeError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<CreateAttendeeError.BuilderImpl> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchCreateAttendeeResponse build() {
            return new BatchCreateAttendeeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
