/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetChannelMessageResponse extends ChimeResponse implements
        ToCopyableBuilder<GetChannelMessageResponse.Builder, GetChannelMessageResponse> {
    private static final SdkField<ChannelMessage> CHANNEL_MESSAGE_FIELD = SdkField
            .<ChannelMessage> builder(MarshallingType.SDK_POJO).memberName("ChannelMessage")
            .getter(getter(GetChannelMessageResponse::channelMessage)).setter(setter(Builder::channelMessage))
            .constructor(ChannelMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MESSAGE_FIELD));

    private final ChannelMessage channelMessage;

    private GetChannelMessageResponse(BuilderImpl builder) {
        super(builder);
        this.channelMessage = builder.channelMessage;
    }

    /**
     * <p>
     * The details of and content in the message.
     * </p>
     * 
     * @return The details of and content in the message.
     */
    public final ChannelMessage channelMessage() {
        return channelMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelMessageResponse)) {
            return false;
        }
        GetChannelMessageResponse other = (GetChannelMessageResponse) obj;
        return Objects.equals(channelMessage(), other.channelMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetChannelMessageResponse").add("ChannelMessage", channelMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelMessage":
            return Optional.ofNullable(clazz.cast(channelMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelMessageResponse, T> g) {
        return obj -> g.apply((GetChannelMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetChannelMessageResponse> {
        /**
         * <p>
         * The details of and content in the message.
         * </p>
         * 
         * @param channelMessage
         *        The details of and content in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMessage(ChannelMessage channelMessage);

        /**
         * <p>
         * The details of and content in the message.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelMessage.Builder} avoiding the need to
         * create one manually via {@link ChannelMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #channelMessage(ChannelMessage)}.
         * 
         * @param channelMessage
         *        a consumer that will call methods on {@link ChannelMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMessage(ChannelMessage)
         */
        default Builder channelMessage(Consumer<ChannelMessage.Builder> channelMessage) {
            return channelMessage(ChannelMessage.builder().applyMutation(channelMessage).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private ChannelMessage channelMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelMessageResponse model) {
            super(model);
            channelMessage(model.channelMessage);
        }

        public final ChannelMessage.Builder getChannelMessage() {
            return channelMessage != null ? channelMessage.toBuilder() : null;
        }

        @Override
        public final Builder channelMessage(ChannelMessage channelMessage) {
            this.channelMessage = channelMessage;
            return this;
        }

        public final void setChannelMessage(ChannelMessage.BuilderImpl channelMessage) {
            this.channelMessage = channelMessage != null ? channelMessage.build() : null;
        }

        @Override
        public GetChannelMessageResponse build() {
            return new GetChannelMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
