/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSupportedPhoneNumberCountriesResponse extends ChimeResponse implements
        ToCopyableBuilder<ListSupportedPhoneNumberCountriesResponse.Builder, ListSupportedPhoneNumberCountriesResponse> {
    private static final SdkField<List<PhoneNumberCountry>> PHONE_NUMBER_COUNTRIES_FIELD = SdkField
            .<List<PhoneNumberCountry>> builder(MarshallingType.LIST)
            .memberName("PhoneNumberCountries")
            .getter(getter(ListSupportedPhoneNumberCountriesResponse::phoneNumberCountries))
            .setter(setter(Builder::phoneNumberCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberCountry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberCountry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_COUNTRIES_FIELD));

    private final List<PhoneNumberCountry> phoneNumberCountries;

    private ListSupportedPhoneNumberCountriesResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberCountries = builder.phoneNumberCountries;
    }

    /**
     * Returns true if the PhoneNumberCountries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPhoneNumberCountries() {
        return phoneNumberCountries != null && !(phoneNumberCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported phone number countries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumberCountries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported phone number countries.
     */
    public final List<PhoneNumberCountry> phoneNumberCountries() {
        return phoneNumberCountries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumberCountries() ? phoneNumberCountries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedPhoneNumberCountriesResponse)) {
            return false;
        }
        ListSupportedPhoneNumberCountriesResponse other = (ListSupportedPhoneNumberCountriesResponse) obj;
        return hasPhoneNumberCountries() == other.hasPhoneNumberCountries()
                && Objects.equals(phoneNumberCountries(), other.phoneNumberCountries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSupportedPhoneNumberCountriesResponse")
                .add("PhoneNumberCountries", hasPhoneNumberCountries() ? phoneNumberCountries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberCountries":
            return Optional.ofNullable(clazz.cast(phoneNumberCountries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedPhoneNumberCountriesResponse, T> g) {
        return obj -> g.apply((ListSupportedPhoneNumberCountriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSupportedPhoneNumberCountriesResponse> {
        /**
         * <p>
         * The supported phone number countries.
         * </p>
         * 
         * @param phoneNumberCountries
         *        The supported phone number countries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountries(Collection<PhoneNumberCountry> phoneNumberCountries);

        /**
         * <p>
         * The supported phone number countries.
         * </p>
         * 
         * @param phoneNumberCountries
         *        The supported phone number countries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberCountries(PhoneNumberCountry... phoneNumberCountries);

        /**
         * <p>
         * The supported phone number countries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumberCountry>.Builder} avoiding the
         * need to create one manually via {@link List<PhoneNumberCountry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumberCountry>.Builder#build()} is called immediately
         * and its result is passed to {@link #phoneNumberCountries(List<PhoneNumberCountry>)}.
         * 
         * @param phoneNumberCountries
         *        a consumer that will call methods on {@link List<PhoneNumberCountry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberCountries(List<PhoneNumberCountry>)
         */
        Builder phoneNumberCountries(Consumer<PhoneNumberCountry.Builder>... phoneNumberCountries);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<PhoneNumberCountry> phoneNumberCountries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedPhoneNumberCountriesResponse model) {
            super(model);
            phoneNumberCountries(model.phoneNumberCountries);
        }

        public final List<PhoneNumberCountry.Builder> getPhoneNumberCountries() {
            List<PhoneNumberCountry.Builder> result = PhoneNumberCountriesListCopier.copyToBuilder(this.phoneNumberCountries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder phoneNumberCountries(Collection<PhoneNumberCountry> phoneNumberCountries) {
            this.phoneNumberCountries = PhoneNumberCountriesListCopier.copy(phoneNumberCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountries(PhoneNumberCountry... phoneNumberCountries) {
            phoneNumberCountries(Arrays.asList(phoneNumberCountries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountries(Consumer<PhoneNumberCountry.Builder>... phoneNumberCountries) {
            phoneNumberCountries(Stream.of(phoneNumberCountries).map(c -> PhoneNumberCountry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberCountries(Collection<PhoneNumberCountry.BuilderImpl> phoneNumberCountries) {
            this.phoneNumberCountries = PhoneNumberCountriesListCopier.copyFromBuilder(phoneNumberCountries);
        }

        @Override
        public ListSupportedPhoneNumberCountriesResponse build() {
            return new ListSupportedPhoneNumberCountriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
