/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the SIP media application, including name and endpoints. An AWS account can have multiple SIP media
 * applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SipMediaApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<SipMediaApplication.Builder, SipMediaApplication> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SipMediaApplicationId").getter(getter(SipMediaApplication::sipMediaApplicationId))
            .setter(setter(Builder::sipMediaApplicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipMediaApplicationId").build())
            .build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsRegion").getter(getter(SipMediaApplication::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SipMediaApplication::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SipMediaApplicationEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<SipMediaApplicationEndpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(SipMediaApplication::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SipMediaApplicationEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(SipMediaApplicationEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(SipMediaApplication::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(SipMediaApplication::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIP_MEDIA_APPLICATION_ID_FIELD, AWS_REGION_FIELD, NAME_FIELD, ENDPOINTS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sipMediaApplicationId;

    private final String awsRegion;

    private final String name;

    private final List<SipMediaApplicationEndpoint> endpoints;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private SipMediaApplication(BuilderImpl builder) {
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.awsRegion = builder.awsRegion;
        this.name = builder.name;
        this.endpoints = builder.endpoints;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The SIP media application ID.
     * </p>
     * 
     * @return The SIP media application ID.
     */
    public final String sipMediaApplicationId() {
        return sipMediaApplicationId;
    }

    /**
     * <p>
     * The AWS Region in which the SIP media application is created.
     * </p>
     * 
     * @return The AWS Region in which the SIP media application is created.
     */
    public final String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The name of the SIP media application.
     * </p>
     * 
     * @return The name of the SIP media application.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is permitted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
     *         permitted.
     */
    public final List<SipMediaApplicationEndpoint> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * The SIP media application creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The SIP media application creation timestamp, in ISO 8601 format.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The SIP media application updated timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The SIP media application updated timestamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SipMediaApplication)) {
            return false;
        }
        SipMediaApplication other = (SipMediaApplication) obj;
        return Objects.equals(sipMediaApplicationId(), other.sipMediaApplicationId())
                && Objects.equals(awsRegion(), other.awsRegion()) && Objects.equals(name(), other.name())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SipMediaApplication").add("SipMediaApplicationId", sipMediaApplicationId())
                .add("AwsRegion", awsRegion()).add("Name", name()).add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SipMediaApplicationId":
            return Optional.ofNullable(clazz.cast(sipMediaApplicationId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SipMediaApplication, T> g) {
        return obj -> g.apply((SipMediaApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SipMediaApplication> {
        /**
         * <p>
         * The SIP media application ID.
         * </p>
         * 
         * @param sipMediaApplicationId
         *        The SIP media application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sipMediaApplicationId(String sipMediaApplicationId);

        /**
         * <p>
         * The AWS Region in which the SIP media application is created.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region in which the SIP media application is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The name of the SIP media application.
         * </p>
         * 
         * @param name
         *        The name of the SIP media application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
         * permitted.
         * </p>
         * 
         * @param endpoints
         *        List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
         *        permitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints);

        /**
         * <p>
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
         * permitted.
         * </p>
         * 
         * @param endpoints
         *        List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
         *        permitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(SipMediaApplicationEndpoint... endpoints);

        /**
         * <p>
         * List of endpoints for SIP media application. Currently, only one endpoint per SIP media application is
         * permitted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SipMediaApplicationEndpoint>.Builder}
         * avoiding the need to create one manually via {@link List<SipMediaApplicationEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SipMediaApplicationEndpoint>.Builder#build()} is called
         * immediately and its result is passed to {@link #endpoints(List<SipMediaApplicationEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<SipMediaApplicationEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<SipMediaApplicationEndpoint>)
         */
        Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints);

        /**
         * <p>
         * The SIP media application creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The SIP media application creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The SIP media application updated timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The SIP media application updated timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String sipMediaApplicationId;

        private String awsRegion;

        private String name;

        private List<SipMediaApplicationEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SipMediaApplication model) {
            sipMediaApplicationId(model.sipMediaApplicationId);
            awsRegion(model.awsRegion);
            name(model.name);
            endpoints(model.endpoints);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSipMediaApplicationId() {
            return sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<SipMediaApplicationEndpoint.Builder> getEndpoints() {
            List<SipMediaApplicationEndpoint.Builder> result = SipMediaApplicationEndpointListCopier
                    .copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder endpoints(Collection<SipMediaApplicationEndpoint> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(SipMediaApplicationEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<SipMediaApplicationEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> SipMediaApplicationEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<SipMediaApplicationEndpoint.BuilderImpl> endpoints) {
            this.endpoints = SipMediaApplicationEndpointListCopier.copyFromBuilder(endpoints);
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public SipMediaApplication build() {
            return new SipMediaApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
