/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SipRuleTargetApplicationListCopier {
    static List<SipRuleTargetApplication> copy(Collection<? extends SipRuleTargetApplication> sipRuleTargetApplicationListParam) {
        List<SipRuleTargetApplication> list;
        if (sipRuleTargetApplicationListParam == null || sipRuleTargetApplicationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRuleTargetApplication> modifiableList = new ArrayList<>();
            sipRuleTargetApplicationListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SipRuleTargetApplication> copyFromBuilder(
            Collection<? extends SipRuleTargetApplication.Builder> sipRuleTargetApplicationListParam) {
        List<SipRuleTargetApplication> list;
        if (sipRuleTargetApplicationListParam == null || sipRuleTargetApplicationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRuleTargetApplication> modifiableList = new ArrayList<>();
            sipRuleTargetApplicationListParam.forEach(entry -> {
                SipRuleTargetApplication member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SipRuleTargetApplication.Builder> copyToBuilder(
            Collection<? extends SipRuleTargetApplication> sipRuleTargetApplicationListParam) {
        List<SipRuleTargetApplication.Builder> list;
        if (sipRuleTargetApplicationListParam == null || sipRuleTargetApplicationListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SipRuleTargetApplication.Builder> modifiableList = new ArrayList<>();
            sipRuleTargetApplicationListParam.forEach(entry -> {
                SipRuleTargetApplication.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
