/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Alexa for Business metadata associated with an Amazon Chime user, used to integrate Alexa for Business with a
 * device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlexaForBusinessMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AlexaForBusinessMetadata.Builder, AlexaForBusinessMetadata> {
    private static final SdkField<Boolean> IS_ALEXA_FOR_BUSINESS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("IsAlexaForBusinessEnabled")
            .getter(getter(AlexaForBusinessMetadata::isAlexaForBusinessEnabled))
            .setter(setter(Builder::isAlexaForBusinessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAlexaForBusinessEnabled").build())
            .build();

    private static final SdkField<String> ALEXA_FOR_BUSINESS_ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlexaForBusinessRoomArn").getter(getter(AlexaForBusinessMetadata::alexaForBusinessRoomArn))
            .setter(setter(Builder::alexaForBusinessRoomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlexaForBusinessRoomArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IS_ALEXA_FOR_BUSINESS_ENABLED_FIELD, ALEXA_FOR_BUSINESS_ROOM_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isAlexaForBusinessEnabled;

    private final String alexaForBusinessRoomArn;

    private AlexaForBusinessMetadata(BuilderImpl builder) {
        this.isAlexaForBusinessEnabled = builder.isAlexaForBusinessEnabled;
        this.alexaForBusinessRoomArn = builder.alexaForBusinessRoomArn;
    }

    /**
     * <p>
     * Starts or stops Alexa for Business.
     * </p>
     * 
     * @return Starts or stops Alexa for Business.
     */
    public final Boolean isAlexaForBusinessEnabled() {
        return isAlexaForBusinessEnabled;
    }

    /**
     * <p>
     * The ARN of the room resource.
     * </p>
     * 
     * @return The ARN of the room resource.
     */
    public final String alexaForBusinessRoomArn() {
        return alexaForBusinessRoomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isAlexaForBusinessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(alexaForBusinessRoomArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlexaForBusinessMetadata)) {
            return false;
        }
        AlexaForBusinessMetadata other = (AlexaForBusinessMetadata) obj;
        return Objects.equals(isAlexaForBusinessEnabled(), other.isAlexaForBusinessEnabled())
                && Objects.equals(alexaForBusinessRoomArn(), other.alexaForBusinessRoomArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlexaForBusinessMetadata").add("IsAlexaForBusinessEnabled", isAlexaForBusinessEnabled())
                .add("AlexaForBusinessRoomArn", alexaForBusinessRoomArn() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsAlexaForBusinessEnabled":
            return Optional.ofNullable(clazz.cast(isAlexaForBusinessEnabled()));
        case "AlexaForBusinessRoomArn":
            return Optional.ofNullable(clazz.cast(alexaForBusinessRoomArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlexaForBusinessMetadata, T> g) {
        return obj -> g.apply((AlexaForBusinessMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlexaForBusinessMetadata> {
        /**
         * <p>
         * Starts or stops Alexa for Business.
         * </p>
         * 
         * @param isAlexaForBusinessEnabled
         *        Starts or stops Alexa for Business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAlexaForBusinessEnabled(Boolean isAlexaForBusinessEnabled);

        /**
         * <p>
         * The ARN of the room resource.
         * </p>
         * 
         * @param alexaForBusinessRoomArn
         *        The ARN of the room resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alexaForBusinessRoomArn(String alexaForBusinessRoomArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isAlexaForBusinessEnabled;

        private String alexaForBusinessRoomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AlexaForBusinessMetadata model) {
            isAlexaForBusinessEnabled(model.isAlexaForBusinessEnabled);
            alexaForBusinessRoomArn(model.alexaForBusinessRoomArn);
        }

        public final Boolean getIsAlexaForBusinessEnabled() {
            return isAlexaForBusinessEnabled;
        }

        @Override
        public final Builder isAlexaForBusinessEnabled(Boolean isAlexaForBusinessEnabled) {
            this.isAlexaForBusinessEnabled = isAlexaForBusinessEnabled;
            return this;
        }

        public final void setIsAlexaForBusinessEnabled(Boolean isAlexaForBusinessEnabled) {
            this.isAlexaForBusinessEnabled = isAlexaForBusinessEnabled;
        }

        public final String getAlexaForBusinessRoomArn() {
            return alexaForBusinessRoomArn;
        }

        @Override
        public final Builder alexaForBusinessRoomArn(String alexaForBusinessRoomArn) {
            this.alexaForBusinessRoomArn = alexaForBusinessRoomArn;
            return this;
        }

        public final void setAlexaForBusinessRoomArn(String alexaForBusinessRoomArn) {
            this.alexaForBusinessRoomArn = alexaForBusinessRoomArn;
        }

        @Override
        public AlexaForBusinessMetadata build() {
            return new AlexaForBusinessMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
