/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateChannelMembershipRequest extends ChimeRequest implements
        ToCopyableBuilder<BatchCreateChannelMembershipRequest.Builder, BatchCreateChannelMembershipRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(BatchCreateChannelMembershipRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(BatchCreateChannelMembershipRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> MEMBER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MemberArns")
            .getter(getter(BatchCreateChannelMembershipRequest::memberArns))
            .setter(setter(Builder::memberArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(BatchCreateChannelMembershipRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, TYPE_FIELD,
            MEMBER_ARNS_FIELD, CHIME_BEARER_FIELD));

    private final String channelArn;

    private final String type;

    private final List<String> memberArns;

    private final String chimeBearer;

    private BatchCreateChannelMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.type = builder.type;
        this.memberArns = builder.memberArns;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the channel to which you're adding users.
     * </p>
     * 
     * @return The ARN of the channel to which you're adding users.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned
     * as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in
     * <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This
     * is only supported by moderators.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
     *         returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
     *         filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
     *         not returned. This is only supported by moderators.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned
     * as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in
     * <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This
     * is only supported by moderators.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
     *         returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
     *         filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
     *         not returned. This is only supported by moderators.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * Returns true if the MemberArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMemberArns() {
        return memberArns != null && !(memberArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the members you want to add to the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of the members you want to add to the channel.
     */
    public final List<String> memberArns() {
        return memberArns;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberArns() ? memberArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateChannelMembershipRequest)) {
            return false;
        }
        BatchCreateChannelMembershipRequest other = (BatchCreateChannelMembershipRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasMemberArns() == other.hasMemberArns() && Objects.equals(memberArns(), other.memberArns())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateChannelMembershipRequest").add("ChannelArn", channelArn())
                .add("Type", typeAsString()).add("MemberArns", hasMemberArns() ? memberArns() : null)
                .add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "MemberArns":
            return Optional.ofNullable(clazz.cast(memberArns()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateChannelMembershipRequest, T> g) {
        return obj -> g.apply((BatchCreateChannelMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateChannelMembershipRequest> {
        /**
         * <p>
         * The ARN of the channel to which you're adding users.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel to which you're adding users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         * returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter
         * in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.
         * This is only supported by moderators.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         *        returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
         *        filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
         *        not returned. This is only supported by moderators.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         * returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter
         * in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned.
         * This is only supported by moderators.
         * </p>
         * 
         * @param type
         *        The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always
         *        returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type
         *        filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are
         *        not returned. This is only supported by moderators.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The ARNs of the members you want to add to the channel.
         * </p>
         * 
         * @param memberArns
         *        The ARNs of the members you want to add to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArns(Collection<String> memberArns);

        /**
         * <p>
         * The ARNs of the members you want to add to the channel.
         * </p>
         * 
         * @param memberArns
         *        The ARNs of the members you want to add to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArns(String... memberArns);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String type;

        private List<String> memberArns = DefaultSdkAutoConstructList.getInstance();

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateChannelMembershipRequest model) {
            super(model);
            channelArn(model.channelArn);
            type(model.type);
            memberArns(model.memberArns);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<String> getMemberArns() {
            if (memberArns instanceof SdkAutoConstructList) {
                return null;
            }
            return memberArns;
        }

        @Override
        public final Builder memberArns(Collection<String> memberArns) {
            this.memberArns = MemberArnsCopier.copy(memberArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberArns(String... memberArns) {
            memberArns(Arrays.asList(memberArns));
            return this;
        }

        public final void setMemberArns(Collection<String> memberArns) {
            this.memberArns = MemberArnsCopier.copy(memberArns);
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateChannelMembershipRequest build() {
            return new BatchCreateChannelMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
