/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateRoomMembershipRequest extends ChimeRequest implements
        ToCopyableBuilder<BatchCreateRoomMembershipRequest.Builder, BatchCreateRoomMembershipRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(BatchCreateRoomMembershipRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()).build();

    private static final SdkField<String> ROOM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoomId")
            .getter(getter(BatchCreateRoomMembershipRequest::roomId)).setter(setter(Builder::roomId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("roomId").build()).build();

    private static final SdkField<List<MembershipItem>> MEMBERSHIP_ITEM_LIST_FIELD = SdkField
            .<List<MembershipItem>> builder(MarshallingType.LIST)
            .memberName("MembershipItemList")
            .getter(getter(BatchCreateRoomMembershipRequest::membershipItemList))
            .setter(setter(Builder::membershipItemList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipItemList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MembershipItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MembershipItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ROOM_ID_FIELD, MEMBERSHIP_ITEM_LIST_FIELD));

    private final String accountId;

    private final String roomId;

    private final List<MembershipItem> membershipItemList;

    private BatchCreateRoomMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.roomId = builder.roomId;
        this.membershipItemList = builder.membershipItemList;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The room ID.
     * </p>
     * 
     * @return The room ID.
     */
    public final String roomId() {
        return roomId;
    }

    /**
     * Returns true if the MembershipItemList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMembershipItemList() {
        return membershipItemList != null && !(membershipItemList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of membership items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMembershipItemList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of membership items.
     */
    public final List<MembershipItem> membershipItemList() {
        return membershipItemList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(roomId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMembershipItemList() ? membershipItemList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateRoomMembershipRequest)) {
            return false;
        }
        BatchCreateRoomMembershipRequest other = (BatchCreateRoomMembershipRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(roomId(), other.roomId())
                && hasMembershipItemList() == other.hasMembershipItemList()
                && Objects.equals(membershipItemList(), other.membershipItemList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateRoomMembershipRequest").add("AccountId", accountId()).add("RoomId", roomId())
                .add("MembershipItemList", hasMembershipItemList() ? membershipItemList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RoomId":
            return Optional.ofNullable(clazz.cast(roomId()));
        case "MembershipItemList":
            return Optional.ofNullable(clazz.cast(membershipItemList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateRoomMembershipRequest, T> g) {
        return obj -> g.apply((BatchCreateRoomMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchCreateRoomMembershipRequest> {
        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The room ID.
         * </p>
         * 
         * @param roomId
         *        The room ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomId(String roomId);

        /**
         * <p>
         * The list of membership items.
         * </p>
         * 
         * @param membershipItemList
         *        The list of membership items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipItemList(Collection<MembershipItem> membershipItemList);

        /**
         * <p>
         * The list of membership items.
         * </p>
         * 
         * @param membershipItemList
         *        The list of membership items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipItemList(MembershipItem... membershipItemList);

        /**
         * <p>
         * The list of membership items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MembershipItem>.Builder} avoiding the need
         * to create one manually via {@link List<MembershipItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MembershipItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #membershipItemList(List<MembershipItem>)}.
         * 
         * @param membershipItemList
         *        a consumer that will call methods on {@link List<MembershipItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membershipItemList(List<MembershipItem>)
         */
        Builder membershipItemList(Consumer<MembershipItem.Builder>... membershipItemList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String accountId;

        private String roomId;

        private List<MembershipItem> membershipItemList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateRoomMembershipRequest model) {
            super(model);
            accountId(model.accountId);
            roomId(model.roomId);
            membershipItemList(model.membershipItemList);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getRoomId() {
            return roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public final List<MembershipItem.Builder> getMembershipItemList() {
            List<MembershipItem.Builder> result = MembershipItemListCopier.copyToBuilder(this.membershipItemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder membershipItemList(Collection<MembershipItem> membershipItemList) {
            this.membershipItemList = MembershipItemListCopier.copy(membershipItemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipItemList(MembershipItem... membershipItemList) {
            membershipItemList(Arrays.asList(membershipItemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipItemList(Consumer<MembershipItem.Builder>... membershipItemList) {
            membershipItemList(Stream.of(membershipItemList).map(c -> MembershipItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMembershipItemList(Collection<MembershipItem.BuilderImpl> membershipItemList) {
            this.membershipItemList = MembershipItemListCopier.copyFromBuilder(membershipItemList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateRoomMembershipRequest build() {
            return new BatchCreateRoomMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
