/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProxySessionRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateProxySessionRequest.Builder, CreateProxySessionRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(CreateProxySessionRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<List<String>> PARTICIPANT_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParticipantPhoneNumbers")
            .getter(getter(CreateProxySessionRequest::participantPhoneNumbers))
            .setter(setter(Builder::participantPhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantPhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateProxySessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> EXPIRY_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpiryMinutes").getter(getter(CreateProxySessionRequest::expiryMinutes))
            .setter(setter(Builder::expiryMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryMinutes").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(CreateProxySessionRequest::capabilitiesAsStrings))
            .setter(setter(Builder::capabilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NUMBER_SELECTION_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NumberSelectionBehavior").getter(getter(CreateProxySessionRequest::numberSelectionBehaviorAsString))
            .setter(setter(Builder::numberSelectionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberSelectionBehavior").build())
            .build();

    private static final SdkField<String> GEO_MATCH_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeoMatchLevel").getter(getter(CreateProxySessionRequest::geoMatchLevelAsString))
            .setter(setter(Builder::geoMatchLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchLevel").build()).build();

    private static final SdkField<GeoMatchParams> GEO_MATCH_PARAMS_FIELD = SdkField
            .<GeoMatchParams> builder(MarshallingType.SDK_POJO).memberName("GeoMatchParams")
            .getter(getter(CreateProxySessionRequest::geoMatchParams)).setter(setter(Builder::geoMatchParams))
            .constructor(GeoMatchParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoMatchParams").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            PARTICIPANT_PHONE_NUMBERS_FIELD, NAME_FIELD, EXPIRY_MINUTES_FIELD, CAPABILITIES_FIELD,
            NUMBER_SELECTION_BEHAVIOR_FIELD, GEO_MATCH_LEVEL_FIELD, GEO_MATCH_PARAMS_FIELD));

    private final String voiceConnectorId;

    private final List<String> participantPhoneNumbers;

    private final String name;

    private final Integer expiryMinutes;

    private final List<String> capabilities;

    private final String numberSelectionBehavior;

    private final String geoMatchLevel;

    private final GeoMatchParams geoMatchParams;

    private CreateProxySessionRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.participantPhoneNumbers = builder.participantPhoneNumbers;
        this.name = builder.name;
        this.expiryMinutes = builder.expiryMinutes;
        this.capabilities = builder.capabilities;
        this.numberSelectionBehavior = builder.numberSelectionBehavior;
        this.geoMatchLevel = builder.geoMatchLevel;
        this.geoMatchParams = builder.geoMatchParams;
    }

    /**
     * <p>
     * The Amazon Chime voice connector ID.
     * </p>
     * 
     * @return The Amazon Chime voice connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * Returns true if the ParticipantPhoneNumbers property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasParticipantPhoneNumbers() {
        return participantPhoneNumbers != null && !(participantPhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The participant phone numbers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParticipantPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The participant phone numbers.
     */
    public final List<String> participantPhoneNumbers() {
        return participantPhoneNumbers;
    }

    /**
     * <p>
     * The name of the proxy session.
     * </p>
     * 
     * @return The name of the proxy session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of minutes allowed for the proxy session.
     * </p>
     * 
     * @return The number of minutes allowed for the proxy session.
     */
    public final Integer expiryMinutes() {
        return expiryMinutes;
    }

    /**
     * <p>
     * The proxy session capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The proxy session capabilities.
     */
    public final List<Capability> capabilities() {
        return CapabilityListCopier.copyStringToEnum(capabilities);
    }

    /**
     * Returns true if the Capabilities property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The proxy session capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCapabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The proxy session capabilities.
     */
    public final List<String> capabilitiesAsStrings() {
        return capabilities;
    }

    /**
     * <p>
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #numberSelectionBehavior} will return {@link NumberSelectionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #numberSelectionBehaviorAsString}.
     * </p>
     * 
     * @return The preference for proxy phone number reuse, or stickiness, between the same participants across
     *         sessions.
     * @see NumberSelectionBehavior
     */
    public final NumberSelectionBehavior numberSelectionBehavior() {
        return NumberSelectionBehavior.fromValue(numberSelectionBehavior);
    }

    /**
     * <p>
     * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #numberSelectionBehavior} will return {@link NumberSelectionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #numberSelectionBehaviorAsString}.
     * </p>
     * 
     * @return The preference for proxy phone number reuse, or stickiness, between the same participants across
     *         sessions.
     * @see NumberSelectionBehavior
     */
    public final String numberSelectionBehaviorAsString() {
        return numberSelectionBehavior;
    }

    /**
     * <p>
     * The preference for matching the country or area code of the proxy phone number with that of the first
     * participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #geoMatchLevel}
     * will return {@link GeoMatchLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #geoMatchLevelAsString}.
     * </p>
     * 
     * @return The preference for matching the country or area code of the proxy phone number with that of the first
     *         participant.
     * @see GeoMatchLevel
     */
    public final GeoMatchLevel geoMatchLevel() {
        return GeoMatchLevel.fromValue(geoMatchLevel);
    }

    /**
     * <p>
     * The preference for matching the country or area code of the proxy phone number with that of the first
     * participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #geoMatchLevel}
     * will return {@link GeoMatchLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #geoMatchLevelAsString}.
     * </p>
     * 
     * @return The preference for matching the country or area code of the proxy phone number with that of the first
     *         participant.
     * @see GeoMatchLevel
     */
    public final String geoMatchLevelAsString() {
        return geoMatchLevel;
    }

    /**
     * <p>
     * The country and area code for the proxy phone number.
     * </p>
     * 
     * @return The country and area code for the proxy phone number.
     */
    public final GeoMatchParams geoMatchParams() {
        return geoMatchParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParticipantPhoneNumbers() ? participantPhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(expiryMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberSelectionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geoMatchParams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxySessionRequest)) {
            return false;
        }
        CreateProxySessionRequest other = (CreateProxySessionRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && hasParticipantPhoneNumbers() == other.hasParticipantPhoneNumbers()
                && Objects.equals(participantPhoneNumbers(), other.participantPhoneNumbers())
                && Objects.equals(name(), other.name()) && Objects.equals(expiryMinutes(), other.expiryMinutes())
                && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilitiesAsStrings(), other.capabilitiesAsStrings())
                && Objects.equals(numberSelectionBehaviorAsString(), other.numberSelectionBehaviorAsString())
                && Objects.equals(geoMatchLevelAsString(), other.geoMatchLevelAsString())
                && Objects.equals(geoMatchParams(), other.geoMatchParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProxySessionRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("ParticipantPhoneNumbers", participantPhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ExpiryMinutes", expiryMinutes())
                .add("Capabilities", hasCapabilities() ? capabilitiesAsStrings() : null)
                .add("NumberSelectionBehavior", numberSelectionBehaviorAsString()).add("GeoMatchLevel", geoMatchLevelAsString())
                .add("GeoMatchParams", geoMatchParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "ParticipantPhoneNumbers":
            return Optional.ofNullable(clazz.cast(participantPhoneNumbers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ExpiryMinutes":
            return Optional.ofNullable(clazz.cast(expiryMinutes()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilitiesAsStrings()));
        case "NumberSelectionBehavior":
            return Optional.ofNullable(clazz.cast(numberSelectionBehaviorAsString()));
        case "GeoMatchLevel":
            return Optional.ofNullable(clazz.cast(geoMatchLevelAsString()));
        case "GeoMatchParams":
            return Optional.ofNullable(clazz.cast(geoMatchParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProxySessionRequest, T> g) {
        return obj -> g.apply((CreateProxySessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProxySessionRequest> {
        /**
         * <p>
         * The Amazon Chime voice connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime voice connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The participant phone numbers.
         * </p>
         * 
         * @param participantPhoneNumbers
         *        The participant phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantPhoneNumbers(Collection<String> participantPhoneNumbers);

        /**
         * <p>
         * The participant phone numbers.
         * </p>
         * 
         * @param participantPhoneNumbers
         *        The participant phone numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantPhoneNumbers(String... participantPhoneNumbers);

        /**
         * <p>
         * The name of the proxy session.
         * </p>
         * 
         * @param name
         *        The name of the proxy session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of minutes allowed for the proxy session.
         * </p>
         * 
         * @param expiryMinutes
         *        The number of minutes allowed for the proxy session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryMinutes(Integer expiryMinutes);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(Collection<String> capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilitiesWithStrings(String... capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<Capability> capabilities);

        /**
         * <p>
         * The proxy session capabilities.
         * </p>
         * 
         * @param capabilities
         *        The proxy session capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Capability... capabilities);

        /**
         * <p>
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         * </p>
         * 
         * @param numberSelectionBehavior
         *        The preference for proxy phone number reuse, or stickiness, between the same participants across
         *        sessions.
         * @see NumberSelectionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberSelectionBehavior
         */
        Builder numberSelectionBehavior(String numberSelectionBehavior);

        /**
         * <p>
         * The preference for proxy phone number reuse, or stickiness, between the same participants across sessions.
         * </p>
         * 
         * @param numberSelectionBehavior
         *        The preference for proxy phone number reuse, or stickiness, between the same participants across
         *        sessions.
         * @see NumberSelectionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumberSelectionBehavior
         */
        Builder numberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior);

        /**
         * <p>
         * The preference for matching the country or area code of the proxy phone number with that of the first
         * participant.
         * </p>
         * 
         * @param geoMatchLevel
         *        The preference for matching the country or area code of the proxy phone number with that of the first
         *        participant.
         * @see GeoMatchLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchLevel
         */
        Builder geoMatchLevel(String geoMatchLevel);

        /**
         * <p>
         * The preference for matching the country or area code of the proxy phone number with that of the first
         * participant.
         * </p>
         * 
         * @param geoMatchLevel
         *        The preference for matching the country or area code of the proxy phone number with that of the first
         *        participant.
         * @see GeoMatchLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeoMatchLevel
         */
        Builder geoMatchLevel(GeoMatchLevel geoMatchLevel);

        /**
         * <p>
         * The country and area code for the proxy phone number.
         * </p>
         * 
         * @param geoMatchParams
         *        The country and area code for the proxy phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoMatchParams(GeoMatchParams geoMatchParams);

        /**
         * <p>
         * The country and area code for the proxy phone number.
         * </p>
         * This is a convenience that creates an instance of the {@link GeoMatchParams.Builder} avoiding the need to
         * create one manually via {@link GeoMatchParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoMatchParams.Builder#build()} is called immediately and its
         * result is passed to {@link #geoMatchParams(GeoMatchParams)}.
         * 
         * @param geoMatchParams
         *        a consumer that will call methods on {@link GeoMatchParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoMatchParams(GeoMatchParams)
         */
        default Builder geoMatchParams(Consumer<GeoMatchParams.Builder> geoMatchParams) {
            return geoMatchParams(GeoMatchParams.builder().applyMutation(geoMatchParams).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private List<String> participantPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private Integer expiryMinutes;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String numberSelectionBehavior;

        private String geoMatchLevel;

        private GeoMatchParams geoMatchParams;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProxySessionRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            participantPhoneNumbers(model.participantPhoneNumbers);
            name(model.name);
            expiryMinutes(model.expiryMinutes);
            capabilitiesWithStrings(model.capabilities);
            numberSelectionBehavior(model.numberSelectionBehavior);
            geoMatchLevel(model.geoMatchLevel);
            geoMatchParams(model.geoMatchParams);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Collection<String> getParticipantPhoneNumbers() {
            if (participantPhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return participantPhoneNumbers;
        }

        @Override
        public final Builder participantPhoneNumbers(Collection<String> participantPhoneNumbers) {
            this.participantPhoneNumbers = ParticipantPhoneNumberListCopier.copy(participantPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participantPhoneNumbers(String... participantPhoneNumbers) {
            participantPhoneNumbers(Arrays.asList(participantPhoneNumbers));
            return this;
        }

        public final void setParticipantPhoneNumbers(Collection<String> participantPhoneNumbers) {
            this.participantPhoneNumbers = ParticipantPhoneNumberListCopier.copy(participantPhoneNumbers);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getExpiryMinutes() {
            return expiryMinutes;
        }

        @Override
        public final Builder expiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
            return this;
        }

        public final void setExpiryMinutes(Integer expiryMinutes) {
            this.expiryMinutes = expiryMinutes;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String... capabilities) {
            capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilityListCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
        }

        public final String getNumberSelectionBehavior() {
            return numberSelectionBehavior;
        }

        @Override
        public final Builder numberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
            return this;
        }

        @Override
        public final Builder numberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior) {
            this.numberSelectionBehavior(numberSelectionBehavior == null ? null : numberSelectionBehavior.toString());
            return this;
        }

        public final void setNumberSelectionBehavior(String numberSelectionBehavior) {
            this.numberSelectionBehavior = numberSelectionBehavior;
        }

        public final String getGeoMatchLevel() {
            return geoMatchLevel;
        }

        @Override
        public final Builder geoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
            return this;
        }

        @Override
        public final Builder geoMatchLevel(GeoMatchLevel geoMatchLevel) {
            this.geoMatchLevel(geoMatchLevel == null ? null : geoMatchLevel.toString());
            return this;
        }

        public final void setGeoMatchLevel(String geoMatchLevel) {
            this.geoMatchLevel = geoMatchLevel;
        }

        public final GeoMatchParams.Builder getGeoMatchParams() {
            return geoMatchParams != null ? geoMatchParams.toBuilder() : null;
        }

        @Override
        public final Builder geoMatchParams(GeoMatchParams geoMatchParams) {
            this.geoMatchParams = geoMatchParams;
            return this;
        }

        public final void setGeoMatchParams(GeoMatchParams.BuilderImpl geoMatchParams) {
            this.geoMatchParams = geoMatchParams != null ? geoMatchParams.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProxySessionRequest build() {
            return new CreateProxySessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
