/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChannelsModeratedByAppInstanceUserRequest extends ChimeRequest implements
        ToCopyableBuilder<ListChannelsModeratedByAppInstanceUserRequest.Builder, ListChannelsModeratedByAppInstanceUserRequest> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceUserArn").getter(getter(ListChannelsModeratedByAppInstanceUserRequest::appInstanceUserArn))
            .setter(setter(Builder::appInstanceUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("app-instance-user-arn").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListChannelsModeratedByAppInstanceUserRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChannelsModeratedByAppInstanceUserRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(ListChannelsModeratedByAppInstanceUserRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CHIME_BEARER_FIELD));

    private final String appInstanceUserArn;

    private final Integer maxResults;

    private final String nextToken;

    private final String chimeBearer;

    private ListChannelsModeratedByAppInstanceUserRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the user in the moderated channel.
     * </p>
     * 
     * @return The ARN of the user in the moderated channel.
     */
    public final String appInstanceUserArn() {
        return appInstanceUserArn;
    }

    /**
     * <p>
     * The maximum number of channels in the request.
     * </p>
     * 
     * @return The maximum number of channels in the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from previous API requests until the number of channels moderated by the user is reached.
     * </p>
     * 
     * @return The token returned from previous API requests until the number of channels moderated by the user is
     *         reached.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsModeratedByAppInstanceUserRequest)) {
            return false;
        }
        ListChannelsModeratedByAppInstanceUserRequest other = (ListChannelsModeratedByAppInstanceUserRequest) obj;
        return Objects.equals(appInstanceUserArn(), other.appInstanceUserArn())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChannelsModeratedByAppInstanceUserRequest").add("AppInstanceUserArn", appInstanceUserArn())
                .add("MaxResults", maxResults()).add("NextToken", nextToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChimeBearer", chimeBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserArn":
            return Optional.ofNullable(clazz.cast(appInstanceUserArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsModeratedByAppInstanceUserRequest, T> g) {
        return obj -> g.apply((ListChannelsModeratedByAppInstanceUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListChannelsModeratedByAppInstanceUserRequest> {
        /**
         * <p>
         * The ARN of the user in the moderated channel.
         * </p>
         * 
         * @param appInstanceUserArn
         *        The ARN of the user in the moderated channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserArn(String appInstanceUserArn);

        /**
         * <p>
         * The maximum number of channels in the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of channels in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from previous API requests until the number of channels moderated by the user is reached.
         * </p>
         * 
         * @param nextToken
         *        The token returned from previous API requests until the number of channels moderated by the user is
         *        reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String appInstanceUserArn;

        private Integer maxResults;

        private String nextToken;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsModeratedByAppInstanceUserRequest model) {
            super(model);
            appInstanceUserArn(model.appInstanceUserArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            chimeBearer(model.chimeBearer);
        }

        public final String getAppInstanceUserArn() {
            return appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChannelsModeratedByAppInstanceUserRequest build() {
            return new ListChannelsModeratedByAppInstanceUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
