/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAppInstanceStreamingConfigurationsRequest extends ChimeRequest implements
        ToCopyableBuilder<PutAppInstanceStreamingConfigurationsRequest.Builder, PutAppInstanceStreamingConfigurationsRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceArn").getter(getter(PutAppInstanceStreamingConfigurationsRequest::appInstanceArn))
            .setter(setter(Builder::appInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appInstanceArn").build()).build();

    private static final SdkField<List<AppInstanceStreamingConfiguration>> APP_INSTANCE_STREAMING_CONFIGURATIONS_FIELD = SdkField
            .<List<AppInstanceStreamingConfiguration>> builder(MarshallingType.LIST)
            .memberName("AppInstanceStreamingConfigurations")
            .getter(getter(PutAppInstanceStreamingConfigurationsRequest::appInstanceStreamingConfigurations))
            .setter(setter(Builder::appInstanceStreamingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceStreamingConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppInstanceStreamingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppInstanceStreamingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD,
            APP_INSTANCE_STREAMING_CONFIGURATIONS_FIELD));

    private final String appInstanceArn;

    private final List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations;

    private PutAppInstanceStreamingConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceStreamingConfigurations = builder.appInstanceStreamingConfigurations;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstance</code>.
     * </p>
     * 
     * @return The ARN of the <code>AppInstance</code>.
     */
    public final String appInstanceArn() {
        return appInstanceArn;
    }

    /**
     * Returns true if the AppInstanceStreamingConfigurations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasAppInstanceStreamingConfigurations() {
        return appInstanceStreamingConfigurations != null
                && !(appInstanceStreamingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The streaming configurations set for an <code>AppInstance</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAppInstanceStreamingConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The streaming configurations set for an <code>AppInstance</code>.
     */
    public final List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations() {
        return appInstanceStreamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAppInstanceStreamingConfigurations() ? appInstanceStreamingConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAppInstanceStreamingConfigurationsRequest)) {
            return false;
        }
        PutAppInstanceStreamingConfigurationsRequest other = (PutAppInstanceStreamingConfigurationsRequest) obj;
        return Objects.equals(appInstanceArn(), other.appInstanceArn())
                && hasAppInstanceStreamingConfigurations() == other.hasAppInstanceStreamingConfigurations()
                && Objects.equals(appInstanceStreamingConfigurations(), other.appInstanceStreamingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PutAppInstanceStreamingConfigurationsRequest")
                .add("AppInstanceArn", appInstanceArn())
                .add("AppInstanceStreamingConfigurations",
                        hasAppInstanceStreamingConfigurations() ? appInstanceStreamingConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceArn":
            return Optional.ofNullable(clazz.cast(appInstanceArn()));
        case "AppInstanceStreamingConfigurations":
            return Optional.ofNullable(clazz.cast(appInstanceStreamingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAppInstanceStreamingConfigurationsRequest, T> g) {
        return obj -> g.apply((PutAppInstanceStreamingConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAppInstanceStreamingConfigurationsRequest> {
        /**
         * <p>
         * The ARN of the <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceArn
         *        The ARN of the <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceArn(String appInstanceArn);

        /**
         * <p>
         * The streaming configurations set for an <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceStreamingConfigurations
         *        The streaming configurations set for an <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceStreamingConfigurations(
                Collection<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations);

        /**
         * <p>
         * The streaming configurations set for an <code>AppInstance</code>.
         * </p>
         * 
         * @param appInstanceStreamingConfigurations
         *        The streaming configurations set for an <code>AppInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceStreamingConfigurations(AppInstanceStreamingConfiguration... appInstanceStreamingConfigurations);

        /**
         * <p>
         * The streaming configurations set for an <code>AppInstance</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppInstanceStreamingConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<AppInstanceStreamingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppInstanceStreamingConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #appInstanceStreamingConfigurations(List<AppInstanceStreamingConfiguration>)}.
         * 
         * @param appInstanceStreamingConfigurations
         *        a consumer that will call methods on {@link List<AppInstanceStreamingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceStreamingConfigurations(List<AppInstanceStreamingConfiguration>)
         */
        Builder appInstanceStreamingConfigurations(
                Consumer<AppInstanceStreamingConfiguration.Builder>... appInstanceStreamingConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String appInstanceArn;

        private List<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAppInstanceStreamingConfigurationsRequest model) {
            super(model);
            appInstanceArn(model.appInstanceArn);
            appInstanceStreamingConfigurations(model.appInstanceStreamingConfigurations);
        }

        public final String getAppInstanceArn() {
            return appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        public final List<AppInstanceStreamingConfiguration.Builder> getAppInstanceStreamingConfigurations() {
            List<AppInstanceStreamingConfiguration.Builder> result = AppInstanceStreamingConfigurationListCopier
                    .copyToBuilder(this.appInstanceStreamingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder appInstanceStreamingConfigurations(
                Collection<AppInstanceStreamingConfiguration> appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations = AppInstanceStreamingConfigurationListCopier
                    .copy(appInstanceStreamingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceStreamingConfigurations(
                AppInstanceStreamingConfiguration... appInstanceStreamingConfigurations) {
            appInstanceStreamingConfigurations(Arrays.asList(appInstanceStreamingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceStreamingConfigurations(
                Consumer<AppInstanceStreamingConfiguration.Builder>... appInstanceStreamingConfigurations) {
            appInstanceStreamingConfigurations(Stream.of(appInstanceStreamingConfigurations)
                    .map(c -> AppInstanceStreamingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAppInstanceStreamingConfigurations(
                Collection<AppInstanceStreamingConfiguration.BuilderImpl> appInstanceStreamingConfigurations) {
            this.appInstanceStreamingConfigurations = AppInstanceStreamingConfigurationListCopier
                    .copyFromBuilder(appInstanceStreamingConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAppInstanceStreamingConfigurationsRequest build() {
            return new PutAppInstanceStreamingConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
