/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The streaming configuration associated with an Amazon Chime Voice Connector. Specifies whether media streaming is
 * enabled for sending to Amazon Kinesis, and shows the retention period for the Amazon Kinesis data, in hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingConfiguration.Builder, StreamingConfiguration> {
    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRetentionInHours").getter(getter(StreamingConfiguration::dataRetentionInHours))
            .setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(StreamingConfiguration::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<List<StreamingNotificationTarget>> STREAMING_NOTIFICATION_TARGETS_FIELD = SdkField
            .<List<StreamingNotificationTarget>> builder(MarshallingType.LIST)
            .memberName("StreamingNotificationTargets")
            .getter(getter(StreamingConfiguration::streamingNotificationTargets))
            .setter(setter(Builder::streamingNotificationTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingNotificationTargets")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamingNotificationTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamingNotificationTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_RETENTION_IN_HOURS_FIELD,
            DISABLED_FIELD, STREAMING_NOTIFICATION_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataRetentionInHours;

    private final Boolean disabled;

    private final List<StreamingNotificationTarget> streamingNotificationTargets;

    private StreamingConfiguration(BuilderImpl builder) {
        this.dataRetentionInHours = builder.dataRetentionInHours;
        this.disabled = builder.disabled;
        this.streamingNotificationTargets = builder.streamingNotificationTargets;
    }

    /**
     * <p>
     * The retention period, in hours, for the Amazon Kinesis data.
     * </p>
     * 
     * @return The retention period, in hours, for the Amazon Kinesis data.
     */
    public final Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    /**
     * <p>
     * When true, media streaming to Amazon Kinesis is turned off.
     * </p>
     * 
     * @return When true, media streaming to Amazon Kinesis is turned off.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * Returns true if the StreamingNotificationTargets property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasStreamingNotificationTargets() {
        return streamingNotificationTargets != null && !(streamingNotificationTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The streaming notification targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStreamingNotificationTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The streaming notification targets.
     */
    public final List<StreamingNotificationTarget> streamingNotificationTargets() {
        return streamingNotificationTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamingNotificationTargets() ? streamingNotificationTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration) obj;
        return Objects.equals(dataRetentionInHours(), other.dataRetentionInHours())
                && Objects.equals(disabled(), other.disabled())
                && hasStreamingNotificationTargets() == other.hasStreamingNotificationTargets()
                && Objects.equals(streamingNotificationTargets(), other.streamingNotificationTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingConfiguration").add("DataRetentionInHours", dataRetentionInHours())
                .add("Disabled", disabled())
                .add("StreamingNotificationTargets", hasStreamingNotificationTargets() ? streamingNotificationTargets() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "StreamingNotificationTargets":
            return Optional.ofNullable(clazz.cast(streamingNotificationTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingConfiguration, T> g) {
        return obj -> g.apply((StreamingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingConfiguration> {
        /**
         * <p>
         * The retention period, in hours, for the Amazon Kinesis data.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The retention period, in hours, for the Amazon Kinesis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);

        /**
         * <p>
         * When true, media streaming to Amazon Kinesis is turned off.
         * </p>
         * 
         * @param disabled
         *        When true, media streaming to Amazon Kinesis is turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The streaming notification targets.
         * </p>
         * 
         * @param streamingNotificationTargets
         *        The streaming notification targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingNotificationTargets(Collection<StreamingNotificationTarget> streamingNotificationTargets);

        /**
         * <p>
         * The streaming notification targets.
         * </p>
         * 
         * @param streamingNotificationTargets
         *        The streaming notification targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingNotificationTargets(StreamingNotificationTarget... streamingNotificationTargets);

        /**
         * <p>
         * The streaming notification targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StreamingNotificationTarget>.Builder}
         * avoiding the need to create one manually via {@link List<StreamingNotificationTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StreamingNotificationTarget>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #streamingNotificationTargets(List<StreamingNotificationTarget>)}.
         * 
         * @param streamingNotificationTargets
         *        a consumer that will call methods on {@link List<StreamingNotificationTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingNotificationTargets(List<StreamingNotificationTarget>)
         */
        Builder streamingNotificationTargets(Consumer<StreamingNotificationTarget.Builder>... streamingNotificationTargets);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataRetentionInHours;

        private Boolean disabled;

        private List<StreamingNotificationTarget> streamingNotificationTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingConfiguration model) {
            dataRetentionInHours(model.dataRetentionInHours);
            disabled(model.disabled);
            streamingNotificationTargets(model.streamingNotificationTargets);
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        public final List<StreamingNotificationTarget.Builder> getStreamingNotificationTargets() {
            List<StreamingNotificationTarget.Builder> result = StreamingNotificationTargetListCopier
                    .copyToBuilder(this.streamingNotificationTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder streamingNotificationTargets(Collection<StreamingNotificationTarget> streamingNotificationTargets) {
            this.streamingNotificationTargets = StreamingNotificationTargetListCopier.copy(streamingNotificationTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingNotificationTargets(StreamingNotificationTarget... streamingNotificationTargets) {
            streamingNotificationTargets(Arrays.asList(streamingNotificationTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingNotificationTargets(
                Consumer<StreamingNotificationTarget.Builder>... streamingNotificationTargets) {
            streamingNotificationTargets(Stream.of(streamingNotificationTargets)
                    .map(c -> StreamingNotificationTarget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreamingNotificationTargets(
                Collection<StreamingNotificationTarget.BuilderImpl> streamingNotificationTargets) {
            this.streamingNotificationTargets = StreamingNotificationTargetListCopier
                    .copyFromBuilder(streamingNotificationTargets);
        }

        @Override
        public StreamingConfiguration build() {
            return new StreamingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
